/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.resourcemanager.appplatform.fluent.models.AppResourceInner;
import com.azure.resourcemanager.appplatform.models.BindingResourceProperties;
import com.azure.resourcemanager.appplatform.models.ManagedIdentityProperties;
import com.azure.resourcemanager.appplatform.models.PersistentDisk;
import com.azure.resourcemanager.appplatform.models.ResourceUploadDefinition;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployments;
import com.azure.resourcemanager.appplatform.models.SpringAppDomains;
import com.azure.resourcemanager.appplatform.models.SpringAppServiceBindings;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.TemporaryDisk;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ExternalChildResource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public interface SpringApp
extends ExternalChildResource<SpringApp, SpringService>,
HasInnerModel<AppResourceInner>,
Updatable<Update> {
    public boolean isPublic();

    public boolean isHttpsOnly();

    public String url();

    public String fqdn();

    public TemporaryDisk temporaryDisk();

    public PersistentDisk persistentDisk();

    public ManagedIdentityProperties identity();

    public OffsetDateTime createdTime();

    public String activeDeploymentName();

    public SpringAppDeployment getActiveDeployment();

    public Mono<SpringAppDeployment> getActiveDeploymentAsync();

    public <T extends SpringAppDeployment.DefinitionStages.WithCreate<T>> SpringAppDeployments<T> deployments();

    public SpringAppServiceBindings serviceBindings();

    public SpringAppDomains customDomains();

    public Mono<ResourceUploadDefinition> getResourceUploadUrlAsync();

    public ResourceUploadDefinition getResourceUploadUrl();

    public static interface UpdateStages {

        public static interface WithServiceBinding {
            public Update withServiceBinding(String var1, BindingResourceProperties var2);

            public Update withoutServiceBinding(String var1);
        }

        public static interface WithDeployment {
            public Update withActiveDeployment(String var1);
        }

        public static interface WithDisk {
            public Update withTemporaryDisk(int var1, String var2);

            public Update withPersistentDisk(int var1, String var2);
        }

        public static interface WithEndpoint {
            public Update withDefaultPublicEndpoint();

            public Update withoutDefaultPublicEndpoint();

            public Update withCustomDomain(String var1);

            public Update withCustomDomain(String var1, String var2);

            public Update withoutCustomDomain(String var1);

            public Update withHttpsOnly();

            public Update withoutHttpsOnly();
        }
    }

    public static interface Update
    extends Appliable<SpringApp>,
    UpdateStages.WithEndpoint,
    UpdateStages.WithDisk,
    UpdateStages.WithDeployment,
    UpdateStages.WithServiceBinding {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<SpringApp>,
        WithEndpoint,
        WithDisk,
        WithDeployment,
        WithServiceBinding {
        }

        public static interface WithServiceBinding {
            public WithCreate withServiceBinding(String var1, BindingResourceProperties var2);

            public WithCreate withoutServiceBinding(String var1);
        }

        public static interface WithDisk {
            public WithCreate withTemporaryDisk(int var1, String var2);

            public WithCreate withPersistentDisk(int var1, String var2);
        }

        public static interface WithEndpoint {
            public WithCreate withDefaultPublicEndpoint();

            public WithCreate withCustomDomain(String var1);

            public WithCreate withCustomDomain(String var1, String var2);

            public WithCreate withHttpsOnly();
        }

        public static interface WithDeployment {
            public WithCreate withDefaultActiveDeployment();

            public <T extends SpringAppDeployment.DefinitionStages.WithAttach<? extends WithCreate, T>> SpringAppDeployment.DefinitionStages.Blank<T> defineActiveDeployment(String var1);
        }

        public static interface Blank
        extends WithDeployment {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate {
    }
}

