// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/** The interface for AppPlatformManagementClient class. */
public interface AppPlatformManagementClient {
    /**
     * Gets Gets subscription ID which uniquely identify the Microsoft Azure subscription. The subscription ID forms
     * part of the URI for every service call.
     *
     * @return the subscriptionId value.
     */
    String getSubscriptionId();

    /**
     * Gets server parameter.
     *
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    String getApiVersion();

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     *
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the ServicesClient object to access its operations.
     *
     * @return the ServicesClient object.
     */
    ServicesClient getServices();

    /**
     * Gets the ConfigServersClient object to access its operations.
     *
     * @return the ConfigServersClient object.
     */
    ConfigServersClient getConfigServers();

    /**
     * Gets the MonitoringSettingsClient object to access its operations.
     *
     * @return the MonitoringSettingsClient object.
     */
    MonitoringSettingsClient getMonitoringSettings();

    /**
     * Gets the AppsClient object to access its operations.
     *
     * @return the AppsClient object.
     */
    AppsClient getApps();

    /**
     * Gets the BindingsClient object to access its operations.
     *
     * @return the BindingsClient object.
     */
    BindingsClient getBindings();

    /**
     * Gets the CertificatesClient object to access its operations.
     *
     * @return the CertificatesClient object.
     */
    CertificatesClient getCertificates();

    /**
     * Gets the CustomDomainsClient object to access its operations.
     *
     * @return the CustomDomainsClient object.
     */
    CustomDomainsClient getCustomDomains();

    /**
     * Gets the DeploymentsClient object to access its operations.
     *
     * @return the DeploymentsClient object.
     */
    DeploymentsClient getDeployments();

    /**
     * Gets the OperationsClient object to access its operations.
     *
     * @return the OperationsClient object.
     */
    OperationsClient getOperations();

    /**
     * Gets the RuntimeVersionsClient object to access its operations.
     *
     * @return the RuntimeVersionsClient object.
     */
    RuntimeVersionsClient getRuntimeVersions();

    /**
     * Gets the SkusClient object to access its operations.
     *
     * @return the SkusClient object.
     */
    SkusClient getSkus();
}
