// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Service properties payload. */
@Fluent
public final class ClusterResourceProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ClusterResourceProperties.class);

    /*
     * Provisioning state of the Service
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * Network profile of the Service
     */
    @JsonProperty(value = "networkProfile")
    private NetworkProfile networkProfile;

    /*
     * Version of the Service
     */
    @JsonProperty(value = "version", access = JsonProperty.Access.WRITE_ONLY)
    private Integer version;

    /*
     * ServiceInstanceEntity GUID which uniquely identifies a created resource
     */
    @JsonProperty(value = "serviceId", access = JsonProperty.Access.WRITE_ONLY)
    private String serviceId;

    /**
     * Get the provisioningState property: Provisioning state of the Service.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the networkProfile property: Network profile of the Service.
     *
     * @return the networkProfile value.
     */
    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile property: Network profile of the Service.
     *
     * @param networkProfile the networkProfile value to set.
     * @return the ClusterResourceProperties object itself.
     */
    public ClusterResourceProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get the version property: Version of the Service.
     *
     * @return the version value.
     */
    public Integer version() {
        return this.version;
    }

    /**
     * Get the serviceId property: ServiceInstanceEntity GUID which uniquely identifies a created resource.
     *
     * @return the serviceId value.
     */
    public String serviceId() {
        return this.serviceId;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkProfile() != null) {
            networkProfile().validate();
        }
    }
}
