/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.ConfigServersClient;
import com.azure.resourcemanager.appplatform.fluent.models.ConfigServerResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.ConfigServerSettingsValidateResultInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.azure.resourcemanager.appplatform.models.ConfigServerGitProperty;
import com.azure.resourcemanager.appplatform.models.ConfigServerProperties;
import com.azure.resourcemanager.appplatform.models.ConfigServerSettings;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ConfigServersClientImpl
implements ConfigServersClient {
    private final ClientLogger logger = new ClientLogger(ConfigServersClientImpl.class);
    private final ConfigServersService service;
    private final AppPlatformManagementClientImpl client;

    ConfigServersClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (ConfigServersService)RestProxy.create(ConfigServersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ConfigServerResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ConfigServerResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", context);
    }

    @Override
    public Mono<ConfigServerResourceInner> getAsync(String resourceGroupName, String serviceName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConfigServerResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ConfigServerResourceInner get(String resourceGroupName, String serviceName) {
        return (ConfigServerResourceInner)((Object)this.getAsync(resourceGroupName, serviceName).block());
    }

    @Override
    public Response<ConfigServerResourceInner> getWithResponse(String resourceGroupName, String serviceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serviceName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updatePutWithResponseAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        String accept = "application/json";
        ConfigServerResourceInner configServerResource = new ConfigServerResourceInner();
        configServerResource.withProperties(properties);
        return FluxUtil.withContext(context -> this.service.updatePut(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configServerResource, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updatePutWithResponseAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        String accept = "application/json";
        ConfigServerResourceInner configServerResource = new ConfigServerResourceInner();
        configServerResource.withProperties(properties);
        context = this.client.mergeContext(context);
        return this.service.updatePut(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configServerResource, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePutAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePutWithResponseAsync(resourceGroupName, serviceName, properties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConfigServerResourceInner.class), (Type)((Object)ConfigServerResourceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePutAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePutWithResponseAsync(resourceGroupName, serviceName, properties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConfigServerResourceInner.class), (Type)((Object)ConfigServerResourceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePut(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePut(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties, context).getSyncPoller();
    }

    @Override
    public Mono<ConfigServerResourceInner> updatePutAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<ConfigServerResourceInner> updatePutAsync(String resourceGroupName, String serviceName) {
        ConfigServerProperties properties = null;
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ConfigServerResourceInner> updatePutAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ConfigServerResourceInner updatePut(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return (ConfigServerResourceInner)((Object)this.updatePutAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    public ConfigServerResourceInner updatePut(String resourceGroupName, String serviceName) {
        ConfigServerProperties properties = null;
        return (ConfigServerResourceInner)((Object)this.updatePutAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    public ConfigServerResourceInner updatePut(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return (ConfigServerResourceInner)((Object)this.updatePutAsync(resourceGroupName, serviceName, properties, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updatePatchWithResponseAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        String accept = "application/json";
        ConfigServerResourceInner configServerResource = new ConfigServerResourceInner();
        configServerResource.withProperties(properties);
        return FluxUtil.withContext(context -> this.service.updatePatch(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configServerResource, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updatePatchWithResponseAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        String accept = "application/json";
        ConfigServerResourceInner configServerResource = new ConfigServerResourceInner();
        configServerResource.withProperties(properties);
        context = this.client.mergeContext(context);
        return this.service.updatePatch(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configServerResource, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePatchAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePatchWithResponseAsync(resourceGroupName, serviceName, properties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConfigServerResourceInner.class), (Type)((Object)ConfigServerResourceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePatchAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePatchWithResponseAsync(resourceGroupName, serviceName, properties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConfigServerResourceInner.class), (Type)((Object)ConfigServerResourceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePatch(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePatch(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties, context).getSyncPoller();
    }

    @Override
    public Mono<ConfigServerResourceInner> updatePatchAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<ConfigServerResourceInner> updatePatchAsync(String resourceGroupName, String serviceName) {
        ConfigServerProperties properties = null;
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ConfigServerResourceInner> updatePatchAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ConfigServerResourceInner updatePatch(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return (ConfigServerResourceInner)((Object)this.updatePatchAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    public ConfigServerResourceInner updatePatch(String resourceGroupName, String serviceName) {
        ConfigServerProperties properties = null;
        return (ConfigServerResourceInner)((Object)this.updatePatchAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    public ConfigServerResourceInner updatePatch(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return (ConfigServerResourceInner)((Object)this.updatePatchAsync(resourceGroupName, serviceName, properties, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName, ConfigServerGitProperty gitProperty) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (gitProperty != null) {
            gitProperty.validate();
        }
        String accept = "application/json";
        ConfigServerSettings configServerSettings = new ConfigServerSettings();
        configServerSettings.withGitProperty(gitProperty);
        return FluxUtil.withContext(context -> this.service.validate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configServerSettings, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName, ConfigServerGitProperty gitProperty, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (gitProperty != null) {
            gitProperty.validate();
        }
        String accept = "application/json";
        ConfigServerSettings configServerSettings = new ConfigServerSettings();
        configServerSettings.withGitProperty(gitProperty);
        context = this.client.mergeContext(context);
        return this.service.validate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configServerSettings, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<ConfigServerSettingsValidateResultInner>, ConfigServerSettingsValidateResultInner> beginValidateAsync(String resourceGroupName, String serviceName, ConfigServerGitProperty gitProperty) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateWithResponseAsync(resourceGroupName, serviceName, gitProperty);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConfigServerSettingsValidateResultInner.class), (Type)((Object)ConfigServerSettingsValidateResultInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ConfigServerSettingsValidateResultInner>, ConfigServerSettingsValidateResultInner> beginValidateAsync(String resourceGroupName, String serviceName, ConfigServerGitProperty gitProperty, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateWithResponseAsync(resourceGroupName, serviceName, gitProperty, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConfigServerSettingsValidateResultInner.class), (Type)((Object)ConfigServerSettingsValidateResultInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ConfigServerSettingsValidateResultInner>, ConfigServerSettingsValidateResultInner> beginValidate(String resourceGroupName, String serviceName, ConfigServerGitProperty gitProperty) {
        return this.beginValidateAsync(resourceGroupName, serviceName, gitProperty).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ConfigServerSettingsValidateResultInner>, ConfigServerSettingsValidateResultInner> beginValidate(String resourceGroupName, String serviceName, ConfigServerGitProperty gitProperty, Context context) {
        return this.beginValidateAsync(resourceGroupName, serviceName, gitProperty, context).getSyncPoller();
    }

    @Override
    public Mono<ConfigServerSettingsValidateResultInner> validateAsync(String resourceGroupName, String serviceName, ConfigServerGitProperty gitProperty) {
        return this.beginValidateAsync(resourceGroupName, serviceName, gitProperty).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<ConfigServerSettingsValidateResultInner> validateAsync(String resourceGroupName, String serviceName) {
        ConfigServerGitProperty gitProperty = null;
        return this.beginValidateAsync(resourceGroupName, serviceName, gitProperty).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ConfigServerSettingsValidateResultInner> validateAsync(String resourceGroupName, String serviceName, ConfigServerGitProperty gitProperty, Context context) {
        return this.beginValidateAsync(resourceGroupName, serviceName, gitProperty, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ConfigServerSettingsValidateResultInner validate(String resourceGroupName, String serviceName, ConfigServerGitProperty gitProperty) {
        return (ConfigServerSettingsValidateResultInner)this.validateAsync(resourceGroupName, serviceName, gitProperty).block();
    }

    @Override
    public ConfigServerSettingsValidateResultInner validate(String resourceGroupName, String serviceName) {
        ConfigServerGitProperty gitProperty = null;
        return (ConfigServerSettingsValidateResultInner)this.validateAsync(resourceGroupName, serviceName, gitProperty).block();
    }

    @Override
    public ConfigServerSettingsValidateResultInner validate(String resourceGroupName, String serviceName, ConfigServerGitProperty gitProperty, Context context) {
        return (ConfigServerSettingsValidateResultInner)this.validateAsync(resourceGroupName, serviceName, gitProperty, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    private static interface ConfigServersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configServers/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigServerResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configServers/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updatePut(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @BodyParam(value="application/json") ConfigServerResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configServers/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updatePatch(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @BodyParam(value="application/json") ConfigServerResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configServers/validate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @BodyParam(value="application/json") ConfigServerSettings var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

