// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appplatform.models.BindingResourceProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Binding resource payload. */
@Fluent
public final class BindingResourceInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(BindingResourceInner.class);

    /*
     * Properties of the Binding resource
     */
    @JsonProperty(value = "properties")
    private BindingResourceProperties properties;

    /**
     * Get the properties property: Properties of the Binding resource.
     *
     * @return the properties value.
     */
    public BindingResourceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the Binding resource.
     *
     * @param properties the properties value to set.
     * @return the BindingResourceInner object itself.
     */
    public BindingResourceInner withProperties(BindingResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
