// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appplatform.fluent.CustomDomainsClient;
import com.azure.resourcemanager.appplatform.fluent.models.CustomDomainResourceInner;
import com.azure.resourcemanager.appplatform.models.CustomDomainProperties;
import com.azure.resourcemanager.appplatform.models.CustomDomainResourceCollection;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in CustomDomainsClient. */
public final class CustomDomainsClientImpl implements CustomDomainsClient {
    private final ClientLogger logger = new ClientLogger(CustomDomainsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final CustomDomainsService service;

    /** The service client containing this operation class. */
    private final AppPlatformManagementClientImpl client;

    /**
     * Initializes an instance of CustomDomainsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    CustomDomainsClientImpl(AppPlatformManagementClientImpl client) {
        this.service =
            RestProxy.create(CustomDomainsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AppPlatformManagementClientCustomDomains to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AppPlatformManagemen")
    private interface CustomDomainsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring"
                + "/{serviceName}/apps/{appName}/domains/{domainName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CustomDomainResourceInner>> get(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("serviceName") String serviceName,
            @PathParam("appName") String appName,
            @PathParam("domainName") String domainName,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring"
                + "/{serviceName}/apps/{appName}/domains/{domainName}")
        @ExpectedResponses({200, 201, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("serviceName") String serviceName,
            @PathParam("appName") String appName,
            @PathParam("domainName") String domainName,
            @BodyParam("application/json") CustomDomainResourceInner domainResource,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring"
                + "/{serviceName}/apps/{appName}/domains/{domainName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("serviceName") String serviceName,
            @PathParam("appName") String appName,
            @PathParam("domainName") String domainName,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring"
                + "/{serviceName}/apps/{appName}/domains/{domainName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("serviceName") String serviceName,
            @PathParam("appName") String appName,
            @PathParam("domainName") String domainName,
            @BodyParam("application/json") CustomDomainResourceInner domainResource,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring"
                + "/{serviceName}/apps/{appName}/domains")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CustomDomainResourceCollection>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("serviceName") String serviceName,
            @PathParam("appName") String appName,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CustomDomainResourceCollection>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Get the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the custom domain of one lifecycle application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CustomDomainResourceInner>> getWithResponseAsync(
        String resourceGroupName, String serviceName, String appName, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            serviceName,
                            appName,
                            domainName,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the custom domain of one lifecycle application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CustomDomainResourceInner>> getWithResponseAsync(
        String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                serviceName,
                appName,
                domainName,
                accept,
                context);
    }

    /**
     * Get the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the custom domain of one lifecycle application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CustomDomainResourceInner> getAsync(
        String resourceGroupName, String serviceName, String appName, String domainName) {
        return getWithResponseAsync(resourceGroupName, serviceName, appName, domainName)
            .flatMap(
                (Response<CustomDomainResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the custom domain of one lifecycle application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomDomainResourceInner get(
        String resourceGroupName, String serviceName, String appName, String domainName) {
        return getAsync(resourceGroupName, serviceName, appName, domainName).block();
    }

    /**
     * Get the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the custom domain of one lifecycle application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CustomDomainResourceInner> getWithResponse(
        String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        return getWithResponseAsync(resourceGroupName, serviceName, appName, domainName, context).block();
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        final String accept = "application/json";
        CustomDomainResourceInner domainResource = new CustomDomainResourceInner();
        domainResource.withProperties(properties);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            serviceName,
                            appName,
                            domainName,
                            domainResource,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        final String accept = "application/json";
        CustomDomainResourceInner domainResource = new CustomDomainResourceInner();
        domainResource.withProperties(properties);
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                serviceName,
                appName,
                domainName,
                domainResource,
                accept,
                context);
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, serviceName, appName, domainName, properties);
        return this
            .client
            .<CustomDomainResourceInner, CustomDomainResourceInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                CustomDomainResourceInner.class,
                CustomDomainResourceInner.class,
                Context.NONE);
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, serviceName, appName, domainName, properties, context);
        return this
            .client
            .<CustomDomainResourceInner, CustomDomainResourceInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                CustomDomainResourceInner.class,
                CustomDomainResourceInner.class,
                context);
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginCreateOrUpdate(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties) {
        return beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties)
            .getSyncPoller();
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginCreateOrUpdate(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties, context)
            .getSyncPoller();
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CustomDomainResourceInner> createOrUpdateAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties) {
        return beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CustomDomainResourceInner> createOrUpdateAsync(
        String resourceGroupName, String serviceName, String appName, String domainName) {
        final CustomDomainProperties properties = null;
        return beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CustomDomainResourceInner> createOrUpdateAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomDomainResourceInner createOrUpdate(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties) {
        return createOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties).block();
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomDomainResourceInner createOrUpdate(
        String resourceGroupName, String serviceName, String appName, String domainName) {
        final CustomDomainProperties properties = null;
        return createOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties).block();
    }

    /**
     * Create or update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomDomainResourceInner createOrUpdate(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties, context).block();
    }

    /**
     * Delete the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String serviceName, String appName, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            serviceName,
                            appName,
                            domainName,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                serviceName,
                appName,
                domainName,
                accept,
                context);
    }

    /**
     * Delete the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String serviceName, String appName, String domainName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, serviceName, appName, domainName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Delete the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, serviceName, appName, domainName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Delete the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String serviceName, String appName, String domainName) {
        return beginDeleteAsync(resourceGroupName, serviceName, appName, domainName).getSyncPoller();
    }

    /**
     * Delete the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        return beginDeleteAsync(resourceGroupName, serviceName, appName, domainName, context).getSyncPoller();
    }

    /**
     * Delete the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String appName, String domainName) {
        return beginDeleteAsync(resourceGroupName, serviceName, appName, domainName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        return beginDeleteAsync(resourceGroupName, serviceName, appName, domainName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String appName, String domainName) {
        deleteAsync(resourceGroupName, serviceName, appName, domainName).block();
    }

    /**
     * Delete the custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        deleteAsync(resourceGroupName, serviceName, appName, domainName, context).block();
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        final String accept = "application/json";
        CustomDomainResourceInner domainResource = new CustomDomainResourceInner();
        domainResource.withProperties(properties);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            serviceName,
                            appName,
                            domainName,
                            domainResource,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        final String accept = "application/json";
        CustomDomainResourceInner domainResource = new CustomDomainResourceInner();
        domainResource.withProperties(properties);
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                serviceName,
                appName,
                domainName,
                domainResource,
                accept,
                context);
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginUpdateAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, serviceName, appName, domainName, properties);
        return this
            .client
            .<CustomDomainResourceInner, CustomDomainResourceInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                CustomDomainResourceInner.class,
                CustomDomainResourceInner.class,
                Context.NONE);
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginUpdateAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, serviceName, appName, domainName, properties, context);
        return this
            .client
            .<CustomDomainResourceInner, CustomDomainResourceInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                CustomDomainResourceInner.class,
                CustomDomainResourceInner.class,
                context);
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginUpdate(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties) {
        return beginUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties).getSyncPoller();
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginUpdate(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties,
        Context context) {
        return beginUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties, context)
            .getSyncPoller();
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CustomDomainResourceInner> updateAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties) {
        return beginUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CustomDomainResourceInner> updateAsync(
        String resourceGroupName, String serviceName, String appName, String domainName) {
        final CustomDomainProperties properties = null;
        return beginUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CustomDomainResourceInner> updateAsync(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties,
        Context context) {
        return beginUpdateAsync(resourceGroupName, serviceName, appName, domainName, properties, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomDomainResourceInner update(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties) {
        return updateAsync(resourceGroupName, serviceName, appName, domainName, properties).block();
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomDomainResourceInner update(
        String resourceGroupName, String serviceName, String appName, String domainName) {
        final CustomDomainProperties properties = null;
        return updateAsync(resourceGroupName, serviceName, appName, domainName, properties).block();
    }

    /**
     * Update custom domain of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param properties Properties of the custom domain resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain resource payload.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CustomDomainResourceInner update(
        String resourceGroupName,
        String serviceName,
        String appName,
        String domainName,
        CustomDomainProperties properties,
        Context context) {
        return updateAsync(resourceGroupName, serviceName, appName, domainName, properties, context).block();
    }

    /**
     * List the custom domains of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection compose of a custom domain resources list and a possible link for next page.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainResourceInner>> listSinglePageAsync(
        String resourceGroupName, String serviceName, String appName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            serviceName,
                            appName,
                            accept,
                            context))
            .<PagedResponse<CustomDomainResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * List the custom domains of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection compose of a custom domain resources list and a possible link for next page.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainResourceInner>> listSinglePageAsync(
        String resourceGroupName, String serviceName, String appName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                serviceName,
                appName,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * List the custom domains of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection compose of a custom domain resources list and a possible link for next page.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CustomDomainResourceInner> listAsync(
        String resourceGroupName, String serviceName, String appName) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, serviceName, appName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * List the custom domains of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection compose of a custom domain resources list and a possible link for next page.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<CustomDomainResourceInner> listAsync(
        String resourceGroupName, String serviceName, String appName, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, serviceName, appName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * List the custom domains of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection compose of a custom domain resources list and a possible link for next page.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CustomDomainResourceInner> list(String resourceGroupName, String serviceName, String appName) {
        return new PagedIterable<>(listAsync(resourceGroupName, serviceName, appName));
    }

    /**
     * List the custom domains of one lifecycle application.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param appName The name of the App resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection compose of a custom domain resources list and a possible link for next page.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CustomDomainResourceInner> list(
        String resourceGroupName, String serviceName, String appName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, serviceName, appName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection compose of a custom domain resources list and a possible link for next page.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<CustomDomainResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection compose of a custom domain resources list and a possible link for next page.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
