/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appplatform.models.AppResourceProvisioningState;
import com.azure.resourcemanager.appplatform.models.PersistentDisk;
import com.azure.resourcemanager.appplatform.models.TemporaryDisk;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class AppResourceProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AppResourceProperties.class);
    @JsonProperty(value="public")
    private Boolean publicProperty;
    @JsonProperty(value="url", access=JsonProperty.Access.WRITE_ONLY)
    private String url;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private AppResourceProvisioningState provisioningState;
    @JsonProperty(value="activeDeploymentName")
    private String activeDeploymentName;
    @JsonProperty(value="fqdn")
    private String fqdn;
    @JsonProperty(value="httpsOnly")
    private Boolean httpsOnly;
    @JsonProperty(value="enableEndToEndTLS")
    private Boolean enableEndToEndTls;
    @JsonProperty(value="createdTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdTime;
    @JsonProperty(value="temporaryDisk")
    private TemporaryDisk temporaryDisk;
    @JsonProperty(value="persistentDisk")
    private PersistentDisk persistentDisk;

    public Boolean publicProperty() {
        return this.publicProperty;
    }

    public AppResourceProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    public String url() {
        return this.url;
    }

    public AppResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String activeDeploymentName() {
        return this.activeDeploymentName;
    }

    public AppResourceProperties withActiveDeploymentName(String activeDeploymentName) {
        this.activeDeploymentName = activeDeploymentName;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public AppResourceProperties withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    public AppResourceProperties withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    public Boolean enableEndToEndTls() {
        return this.enableEndToEndTls;
    }

    public AppResourceProperties withEnableEndToEndTls(Boolean enableEndToEndTls) {
        this.enableEndToEndTls = enableEndToEndTls;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public TemporaryDisk temporaryDisk() {
        return this.temporaryDisk;
    }

    public AppResourceProperties withTemporaryDisk(TemporaryDisk temporaryDisk) {
        this.temporaryDisk = temporaryDisk;
        return this;
    }

    public PersistentDisk persistentDisk() {
        return this.persistentDisk;
    }

    public AppResourceProperties withPersistentDisk(PersistentDisk persistentDisk) {
        this.persistentDisk = persistentDisk;
        return this;
    }

    public void validate() {
        if (this.temporaryDisk() != null) {
            this.temporaryDisk().validate();
        }
        if (this.persistentDisk() != null) {
            this.persistentDisk().validate();
        }
    }
}

