/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appplatform.models.NetworkProfileOutboundIPs;
import com.azure.resourcemanager.appplatform.models.RequiredTraffic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NetworkProfile {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(NetworkProfile.class);
    @JsonProperty(value="serviceRuntimeSubnetId")
    private String serviceRuntimeSubnetId;
    @JsonProperty(value="appSubnetId")
    private String appSubnetId;
    @JsonProperty(value="serviceCidr")
    private String serviceCidr;
    @JsonProperty(value="serviceRuntimeNetworkResourceGroup")
    private String serviceRuntimeNetworkResourceGroup;
    @JsonProperty(value="appNetworkResourceGroup")
    private String appNetworkResourceGroup;
    @JsonProperty(value="outboundIPs", access=JsonProperty.Access.WRITE_ONLY)
    private NetworkProfileOutboundIPs outboundIPs;
    @JsonProperty(value="requiredTraffics", access=JsonProperty.Access.WRITE_ONLY)
    private List<RequiredTraffic> requiredTraffics;

    public String serviceRuntimeSubnetId() {
        return this.serviceRuntimeSubnetId;
    }

    public NetworkProfile withServiceRuntimeSubnetId(String serviceRuntimeSubnetId) {
        this.serviceRuntimeSubnetId = serviceRuntimeSubnetId;
        return this;
    }

    public String appSubnetId() {
        return this.appSubnetId;
    }

    public NetworkProfile withAppSubnetId(String appSubnetId) {
        this.appSubnetId = appSubnetId;
        return this;
    }

    public String serviceCidr() {
        return this.serviceCidr;
    }

    public NetworkProfile withServiceCidr(String serviceCidr) {
        this.serviceCidr = serviceCidr;
        return this;
    }

    public String serviceRuntimeNetworkResourceGroup() {
        return this.serviceRuntimeNetworkResourceGroup;
    }

    public NetworkProfile withServiceRuntimeNetworkResourceGroup(String serviceRuntimeNetworkResourceGroup) {
        this.serviceRuntimeNetworkResourceGroup = serviceRuntimeNetworkResourceGroup;
        return this;
    }

    public String appNetworkResourceGroup() {
        return this.appNetworkResourceGroup;
    }

    public NetworkProfile withAppNetworkResourceGroup(String appNetworkResourceGroup) {
        this.appNetworkResourceGroup = appNetworkResourceGroup;
        return this;
    }

    public NetworkProfileOutboundIPs outboundIPs() {
        return this.outboundIPs;
    }

    public List<RequiredTraffic> requiredTraffics() {
        return this.requiredTraffics;
    }

    public void validate() {
        if (this.outboundIPs() != null) {
            this.outboundIPs().validate();
        }
        if (this.requiredTraffics() != null) {
            this.requiredTraffics().forEach(e -> e.validate());
        }
    }
}

