/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.GroupsClient;
import com.azure.resourcemanager.authorization.fluent.models.ADGroupInner;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryGroupImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryGroup;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryGroups;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import reactor.core.publisher.Mono;

public class ActiveDirectoryGroupsImpl
extends CreatableWrappersImpl<ActiveDirectoryGroup, ActiveDirectoryGroupImpl, ADGroupInner>
implements ActiveDirectoryGroups {
    private final AuthorizationManager manager;

    public ActiveDirectoryGroupsImpl(AuthorizationManager manager) {
        this.manager = manager;
    }

    public PagedIterable<ActiveDirectoryGroup> list() {
        return this.wrapList(this.manager.serviceClient().getGroups().list());
    }

    protected ActiveDirectoryGroupImpl wrapModel(ADGroupInner groupInner) {
        if (groupInner == null) {
            return null;
        }
        return new ActiveDirectoryGroupImpl(groupInner, this.manager());
    }

    public ActiveDirectoryGroupImpl getById(String objectId) {
        return (ActiveDirectoryGroupImpl)this.getByIdAsync(objectId).block();
    }

    public Mono<ActiveDirectoryGroup> getByIdAsync(String id) {
        return this.manager.serviceClient().getGroups().getAsync(id).map(groupInner -> new ActiveDirectoryGroupImpl((ADGroupInner)groupInner, this.manager()));
    }

    public PagedFlux<ActiveDirectoryGroup> listAsync() {
        return this.wrapPageAsync(this.manager().serviceClient().getGroups().listAsync(null));
    }

    public Mono<ActiveDirectoryGroup> getByNameAsync(String name) {
        return this.manager().serviceClient().getGroups().listAsync(String.format("displayName eq '%s'", name)).singleOrEmpty().map(adGroupInner -> new ActiveDirectoryGroupImpl((ADGroupInner)adGroupInner, this.manager()));
    }

    public ActiveDirectoryGroup getByName(String name) {
        return (ActiveDirectoryGroup)this.getByNameAsync(name).block();
    }

    public ActiveDirectoryGroupImpl define(String name) {
        return this.wrapModel(name);
    }

    protected ActiveDirectoryGroupImpl wrapModel(String name) {
        return this.wrapModel(new ADGroupInner().withDisplayName(name));
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.manager().serviceClient().getGroups().deleteAsync(id);
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public GroupsClient inner() {
        return this.manager().serviceClient().getGroups();
    }

    public PagedIterable<ActiveDirectoryGroup> listByFilter(String filter) {
        return new PagedIterable(this.listByFilterAsync(filter));
    }

    public PagedFlux<ActiveDirectoryGroup> listByFilterAsync(String filter) {
        return this.inner().listAsync(filter).mapPage(this::wrapModel);
    }
}

