/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationInner;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalObjectResultInner;
import com.azure.resourcemanager.authorization.implementation.GraphRbacManagementClientImpl;
import com.azure.resourcemanager.authorization.models.AddOwnerParameters;
import com.azure.resourcemanager.authorization.models.ApplicationCreateParameters;
import com.azure.resourcemanager.authorization.models.ApplicationListResult;
import com.azure.resourcemanager.authorization.models.ApplicationUpdateParameters;
import com.azure.resourcemanager.authorization.models.DirectoryObjectListResult;
import com.azure.resourcemanager.authorization.models.GraphErrorException;
import com.azure.resourcemanager.authorization.models.KeyCredentialListResult;
import com.azure.resourcemanager.authorization.models.KeyCredentialsUpdateParameters;
import com.azure.resourcemanager.authorization.models.PasswordCredentialListResult;
import com.azure.resourcemanager.authorization.models.PasswordCredentialsUpdateParameters;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ApplicationsClientImpl
implements ApplicationsClient {
    private final ClientLogger logger = new ClientLogger(ApplicationsClientImpl.class);
    private final ApplicationsService service;
    private final GraphRbacManagementClientImpl client;

    ApplicationsClientImpl(GraphRbacManagementClientImpl client) {
        this.service = (ApplicationsService)RestProxy.create(ApplicationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ApplicationInner>> createWithResponseAsync(ApplicationCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ApplicationInner>> createWithResponseAsync(ApplicationCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<ApplicationInner> createAsync(ApplicationCreateParameters parameters) {
        return this.createWithResponseAsync(parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInner create(ApplicationCreateParameters parameters) {
        return (ApplicationInner)this.createAsync(parameters).block();
    }

    @Override
    public Response<ApplicationInner> createWithResponse(ApplicationCreateParameters parameters, Context context) {
        return (Response)this.createWithResponseAsync(parameters, context).block();
    }

    private Mono<PagedResponse<ApplicationInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationListResult)res.getValue()).value(), ((ApplicationListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ApplicationInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationListResult)res.getValue()).value(), ((ApplicationListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<ApplicationInner> listAsync(String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ApplicationInner> listAsync() {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ApplicationInner> listAsync(String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ApplicationInner> list(String filter, Context context) {
        return new PagedIterable(this.listAsync(filter, context));
    }

    @Override
    public PagedIterable<ApplicationInner> list() {
        String filter = null;
        return new PagedIterable(this.listAsync(filter));
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String applicationObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String applicationObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String applicationObjectId) {
        return this.deleteWithResponseAsync(applicationObjectId).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String applicationObjectId) {
        this.deleteAsync(applicationObjectId).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String applicationObjectId, Context context) {
        return (Response)this.deleteWithResponseAsync(applicationObjectId, context).block();
    }

    @Override
    public Mono<Response<ApplicationInner>> getWithResponseAsync(String applicationObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ApplicationInner>> getWithResponseAsync(String applicationObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<ApplicationInner> getAsync(String applicationObjectId) {
        return this.getWithResponseAsync(applicationObjectId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInner get(String applicationObjectId) {
        return (ApplicationInner)this.getAsync(applicationObjectId).block();
    }

    @Override
    public Response<ApplicationInner> getWithResponse(String applicationObjectId, Context context) {
        return (Response)this.getWithResponseAsync(applicationObjectId, context).block();
    }

    @Override
    public Mono<Response<Void>> patchWithResponseAsync(String applicationObjectId, ApplicationUpdateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.patch(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> patchWithResponseAsync(String applicationObjectId, ApplicationUpdateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.patch(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<Void> patchAsync(String applicationObjectId, ApplicationUpdateParameters parameters) {
        return this.patchWithResponseAsync(applicationObjectId, parameters).flatMap(res -> Mono.empty());
    }

    @Override
    public void patch(String applicationObjectId, ApplicationUpdateParameters parameters) {
        this.patchAsync(applicationObjectId, parameters).block();
    }

    @Override
    public Response<Void> patchWithResponse(String applicationObjectId, ApplicationUpdateParameters parameters, Context context) {
        return (Response)this.patchWithResponseAsync(applicationObjectId, parameters, context).block();
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersSinglePageAsync(String applicationObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwners(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersSinglePageAsync(String applicationObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwners(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<DirectoryObjectInner> listOwnersAsync(String applicationObjectId) {
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(applicationObjectId), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<DirectoryObjectInner> listOwnersAsync(String applicationObjectId, Context context) {
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(applicationObjectId, context), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> listOwners(String applicationObjectId) {
        return new PagedIterable(this.listOwnersAsync(applicationObjectId));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> listOwners(String applicationObjectId, Context context) {
        return new PagedIterable(this.listOwnersAsync(applicationObjectId, context));
    }

    @Override
    public Mono<Response<Void>> addOwnerWithResponseAsync(String applicationObjectId, String url) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (url == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter url is required and cannot be null."));
        }
        AddOwnerParameters parameters = new AddOwnerParameters();
        parameters.withUrl(url);
        return FluxUtil.withContext(context -> this.service.addOwner(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> addOwnerWithResponseAsync(String applicationObjectId, String url, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (url == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter url is required and cannot be null."));
        }
        AddOwnerParameters parameters = new AddOwnerParameters();
        parameters.withUrl(url);
        context = this.client.mergeContext(context);
        return this.service.addOwner(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<Void> addOwnerAsync(String applicationObjectId, String url) {
        return this.addOwnerWithResponseAsync(applicationObjectId, url).flatMap(res -> Mono.empty());
    }

    @Override
    public void addOwner(String applicationObjectId, String url) {
        this.addOwnerAsync(applicationObjectId, url).block();
    }

    @Override
    public Response<Void> addOwnerWithResponse(String applicationObjectId, String url, Context context) {
        return (Response)this.addOwnerWithResponseAsync(applicationObjectId, url, context).block();
    }

    @Override
    public Mono<Response<Void>> removeOwnerWithResponseAsync(String applicationObjectId, String ownerObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (ownerObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ownerObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.removeOwner(this.client.getEndpoint(), applicationObjectId, ownerObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> removeOwnerWithResponseAsync(String applicationObjectId, String ownerObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (ownerObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ownerObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.removeOwner(this.client.getEndpoint(), applicationObjectId, ownerObjectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<Void> removeOwnerAsync(String applicationObjectId, String ownerObjectId) {
        return this.removeOwnerWithResponseAsync(applicationObjectId, ownerObjectId).flatMap(res -> Mono.empty());
    }

    @Override
    public void removeOwner(String applicationObjectId, String ownerObjectId) {
        this.removeOwnerAsync(applicationObjectId, ownerObjectId).block();
    }

    @Override
    public Response<Void> removeOwnerWithResponse(String applicationObjectId, String ownerObjectId, Context context) {
        return (Response)this.removeOwnerWithResponseAsync(applicationObjectId, ownerObjectId, context).block();
    }

    private Mono<PagedResponse<KeyCredentialInner>> listKeyCredentialsSinglePageAsync(String applicationObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listKeyCredentials(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyCredentialListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<KeyCredentialInner>> listKeyCredentialsSinglePageAsync(String applicationObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listKeyCredentials(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyCredentialListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<KeyCredentialInner> listKeyCredentialsAsync(String applicationObjectId) {
        return new PagedFlux(() -> this.listKeyCredentialsSinglePageAsync(applicationObjectId));
    }

    private PagedFlux<KeyCredentialInner> listKeyCredentialsAsync(String applicationObjectId, Context context) {
        return new PagedFlux(() -> this.listKeyCredentialsSinglePageAsync(applicationObjectId, context));
    }

    @Override
    public PagedIterable<KeyCredentialInner> listKeyCredentials(String applicationObjectId) {
        return new PagedIterable(this.listKeyCredentialsAsync(applicationObjectId));
    }

    @Override
    public PagedIterable<KeyCredentialInner> listKeyCredentials(String applicationObjectId, Context context) {
        return new PagedIterable(this.listKeyCredentialsAsync(applicationObjectId, context));
    }

    @Override
    public Mono<Response<Void>> updateKeyCredentialsWithResponseAsync(String applicationObjectId, List<KeyCredentialInner> value) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter value is required and cannot be null."));
        }
        value.forEach(e -> e.validate());
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        return FluxUtil.withContext(context -> this.service.updateKeyCredentials(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateKeyCredentialsWithResponseAsync(String applicationObjectId, List<KeyCredentialInner> value, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter value is required and cannot be null."));
        }
        value.forEach(e -> e.validate());
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        context = this.client.mergeContext(context);
        return this.service.updateKeyCredentials(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<Void> updateKeyCredentialsAsync(String applicationObjectId, List<KeyCredentialInner> value) {
        return this.updateKeyCredentialsWithResponseAsync(applicationObjectId, value).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateKeyCredentials(String applicationObjectId, List<KeyCredentialInner> value) {
        this.updateKeyCredentialsAsync(applicationObjectId, value).block();
    }

    @Override
    public Response<Void> updateKeyCredentialsWithResponse(String applicationObjectId, List<KeyCredentialInner> value, Context context) {
        return (Response)this.updateKeyCredentialsWithResponseAsync(applicationObjectId, value, context).block();
    }

    private Mono<PagedResponse<PasswordCredentialInner>> listPasswordCredentialsSinglePageAsync(String applicationObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listPasswordCredentials(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PasswordCredentialListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PasswordCredentialInner>> listPasswordCredentialsSinglePageAsync(String applicationObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listPasswordCredentials(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PasswordCredentialListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<PasswordCredentialInner> listPasswordCredentialsAsync(String applicationObjectId) {
        return new PagedFlux(() -> this.listPasswordCredentialsSinglePageAsync(applicationObjectId));
    }

    private PagedFlux<PasswordCredentialInner> listPasswordCredentialsAsync(String applicationObjectId, Context context) {
        return new PagedFlux(() -> this.listPasswordCredentialsSinglePageAsync(applicationObjectId, context));
    }

    @Override
    public PagedIterable<PasswordCredentialInner> listPasswordCredentials(String applicationObjectId) {
        return new PagedIterable(this.listPasswordCredentialsAsync(applicationObjectId));
    }

    @Override
    public PagedIterable<PasswordCredentialInner> listPasswordCredentials(String applicationObjectId, Context context) {
        return new PagedIterable(this.listPasswordCredentialsAsync(applicationObjectId, context));
    }

    @Override
    public Mono<Response<Void>> updatePasswordCredentialsWithResponseAsync(String applicationObjectId, List<PasswordCredentialInner> value) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter value is required and cannot be null."));
        }
        value.forEach(e -> e.validate());
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        return FluxUtil.withContext(context -> this.service.updatePasswordCredentials(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updatePasswordCredentialsWithResponseAsync(String applicationObjectId, List<PasswordCredentialInner> value, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter value is required and cannot be null."));
        }
        value.forEach(e -> e.validate());
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        context = this.client.mergeContext(context);
        return this.service.updatePasswordCredentials(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<Void> updatePasswordCredentialsAsync(String applicationObjectId, List<PasswordCredentialInner> value) {
        return this.updatePasswordCredentialsWithResponseAsync(applicationObjectId, value).flatMap(res -> Mono.empty());
    }

    @Override
    public void updatePasswordCredentials(String applicationObjectId, List<PasswordCredentialInner> value) {
        this.updatePasswordCredentialsAsync(applicationObjectId, value).block();
    }

    @Override
    public Response<Void> updatePasswordCredentialsWithResponse(String applicationObjectId, List<PasswordCredentialInner> value, Context context) {
        return (Response)this.updatePasswordCredentialsWithResponseAsync(applicationObjectId, value, context).block();
    }

    @Override
    public Mono<Response<ServicePrincipalObjectResultInner>> getServicePrincipalsIdByAppIdWithResponseAsync(String applicationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getServicePrincipalsIdByAppId(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), applicationId, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ServicePrincipalObjectResultInner>> getServicePrincipalsIdByAppIdWithResponseAsync(String applicationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getServicePrincipalsIdByAppId(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), applicationId, context);
    }

    @Override
    public Mono<ServicePrincipalObjectResultInner> getServicePrincipalsIdByAppIdAsync(String applicationId) {
        return this.getServicePrincipalsIdByAppIdWithResponseAsync(applicationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ServicePrincipalObjectResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ServicePrincipalObjectResultInner getServicePrincipalsIdByAppId(String applicationId) {
        return (ServicePrincipalObjectResultInner)this.getServicePrincipalsIdByAppIdAsync(applicationId).block();
    }

    @Override
    public Response<ServicePrincipalObjectResultInner> getServicePrincipalsIdByAppIdWithResponse(String applicationId, Context context) {
        return (Response)this.getServicePrincipalsIdByAppIdWithResponseAsync(applicationId, context).block();
    }

    private Mono<PagedResponse<ApplicationInner>> listNextSinglePageAsync(String nextLink) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationListResult)res.getValue()).value(), ((ApplicationListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ApplicationInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationListResult)res.getValue()).value(), ((ApplicationListResult)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwnersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwnersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="GraphRbacManagementC")
    private static interface ApplicationsService {
        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/applications")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ApplicationInner>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="tenantID") String var3, @BodyParam(value="application/json") ApplicationCreateParameters var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/applications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ApplicationListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{tenantID}/applications/{applicationObjectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/applications/{applicationObjectId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ApplicationInner>> get(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch(value="/{tenantID}/applications/{applicationObjectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> patch(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") ApplicationUpdateParameters var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/applications/{applicationObjectId}/owners")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<DirectoryObjectListResult>> listOwners(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/{tenantID}/applications/{applicationObjectId}/$links/owners")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> addOwner(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") AddOwnerParameters var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{tenantID}/applications/{applicationObjectId}/$links/owners/{ownerObjectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> removeOwner(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @PathParam(value="ownerObjectId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="tenantID") String var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/applications/{applicationObjectId}/keyCredentials")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<KeyCredentialListResult>> listKeyCredentials(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch(value="/{tenantID}/applications/{applicationObjectId}/keyCredentials")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> updateKeyCredentials(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") KeyCredentialsUpdateParameters var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/applications/{applicationObjectId}/passwordCredentials")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<PasswordCredentialListResult>> listPasswordCredentials(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch(value="/{tenantID}/applications/{applicationObjectId}/passwordCredentials")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> updatePasswordCredentials(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") PasswordCredentialsUpdateParameters var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/servicePrincipalsByAppId/{applicationID}/objectId")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ServicePrincipalObjectResultInner>> getServicePrincipalsIdByAppId(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="tenantID") String var3, @PathParam(value="applicationID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ApplicationListResult>> listNext(@HostParam(value="$host") String var1, @PathParam(value="nextLink", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<DirectoryObjectListResult>> listOwnersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

