/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.GroupsClient;
import com.azure.resourcemanager.authorization.fluent.models.ADGroupInner;
import com.azure.resourcemanager.authorization.fluent.models.CheckGroupMembershipResultInner;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.implementation.GraphRbacManagementClientImpl;
import com.azure.resourcemanager.authorization.models.AddOwnerParameters;
import com.azure.resourcemanager.authorization.models.CheckGroupMembershipParameters;
import com.azure.resourcemanager.authorization.models.DirectoryObjectListResult;
import com.azure.resourcemanager.authorization.models.GraphErrorException;
import com.azure.resourcemanager.authorization.models.GroupAddMemberParameters;
import com.azure.resourcemanager.authorization.models.GroupCreateParameters;
import com.azure.resourcemanager.authorization.models.GroupGetMemberGroupsParameters;
import com.azure.resourcemanager.authorization.models.GroupGetMemberGroupsResult;
import com.azure.resourcemanager.authorization.models.GroupListResult;
import reactor.core.publisher.Mono;

public final class GroupsClientImpl
implements GroupsClient {
    private final ClientLogger logger = new ClientLogger(GroupsClientImpl.class);
    private final GroupsService service;
    private final GraphRbacManagementClientImpl client;

    GroupsClientImpl(GraphRbacManagementClientImpl client) {
        this.service = (GroupsService)RestProxy.create(GroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<CheckGroupMembershipResultInner>> isMemberOfWithResponseAsync(CheckGroupMembershipParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.isMemberOf(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<CheckGroupMembershipResultInner>> isMemberOfWithResponseAsync(CheckGroupMembershipParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.isMemberOf(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<CheckGroupMembershipResultInner> isMemberOfAsync(CheckGroupMembershipParameters parameters) {
        return this.isMemberOfWithResponseAsync(parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CheckGroupMembershipResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public CheckGroupMembershipResultInner isMemberOf(CheckGroupMembershipParameters parameters) {
        return (CheckGroupMembershipResultInner)this.isMemberOfAsync(parameters).block();
    }

    @Override
    public Response<CheckGroupMembershipResultInner> isMemberOfWithResponse(CheckGroupMembershipParameters parameters, Context context) {
        return (Response)this.isMemberOfWithResponseAsync(parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> removeMemberWithResponseAsync(String groupObjectId, String memberObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupObjectId is required and cannot be null."));
        }
        if (memberObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter memberObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.removeMember(this.client.getEndpoint(), groupObjectId, memberObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> removeMemberWithResponseAsync(String groupObjectId, String memberObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupObjectId is required and cannot be null."));
        }
        if (memberObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter memberObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.removeMember(this.client.getEndpoint(), groupObjectId, memberObjectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<Void> removeMemberAsync(String groupObjectId, String memberObjectId) {
        return this.removeMemberWithResponseAsync(groupObjectId, memberObjectId).flatMap(res -> Mono.empty());
    }

    @Override
    public void removeMember(String groupObjectId, String memberObjectId) {
        this.removeMemberAsync(groupObjectId, memberObjectId).block();
    }

    @Override
    public Response<Void> removeMemberWithResponse(String groupObjectId, String memberObjectId, Context context) {
        return (Response)this.removeMemberWithResponseAsync(groupObjectId, memberObjectId, context).block();
    }

    @Override
    public Mono<Response<Void>> addMemberWithResponseAsync(String groupObjectId, String url) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (url == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter url is required and cannot be null."));
        }
        GroupAddMemberParameters parameters = new GroupAddMemberParameters();
        parameters.withUrl(url);
        return FluxUtil.withContext(context -> this.service.addMember(this.client.getEndpoint(), groupObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> addMemberWithResponseAsync(String groupObjectId, String url, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (url == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter url is required and cannot be null."));
        }
        GroupAddMemberParameters parameters = new GroupAddMemberParameters();
        parameters.withUrl(url);
        context = this.client.mergeContext(context);
        return this.service.addMember(this.client.getEndpoint(), groupObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<Void> addMemberAsync(String groupObjectId, String url) {
        return this.addMemberWithResponseAsync(groupObjectId, url).flatMap(res -> Mono.empty());
    }

    @Override
    public void addMember(String groupObjectId, String url) {
        this.addMemberAsync(groupObjectId, url).block();
    }

    @Override
    public Response<Void> addMemberWithResponse(String groupObjectId, String url, Context context) {
        return (Response)this.addMemberWithResponseAsync(groupObjectId, url, context).block();
    }

    @Override
    public Mono<Response<ADGroupInner>> createWithResponseAsync(GroupCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ADGroupInner>> createWithResponseAsync(GroupCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<ADGroupInner> createAsync(GroupCreateParameters parameters) {
        return this.createWithResponseAsync(parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ADGroupInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ADGroupInner create(GroupCreateParameters parameters) {
        return (ADGroupInner)this.createAsync(parameters).block();
    }

    @Override
    public Response<ADGroupInner> createWithResponse(GroupCreateParameters parameters, Context context) {
        return (Response)this.createWithResponseAsync(parameters, context).block();
    }

    private Mono<PagedResponse<ADGroupInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GroupListResult)res.getValue()).value(), ((GroupListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ADGroupInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GroupListResult)res.getValue()).value(), ((GroupListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<ADGroupInner> listAsync(String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ADGroupInner> listAsync() {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ADGroupInner> listAsync(String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ADGroupInner> list(String filter, Context context) {
        return new PagedIterable(this.listAsync(filter, context));
    }

    @Override
    public PagedIterable<ADGroupInner> list() {
        String filter = null;
        return new PagedIterable(this.listAsync(filter));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> getGroupMembersSinglePageAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getGroupMembers(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> getGroupMembersSinglePageAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getGroupMembers(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<DirectoryObjectInner> getGroupMembersAsync(String objectId) {
        return new PagedFlux(() -> this.getGroupMembersSinglePageAsync(objectId), nextLink -> this.getGroupMembersNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<DirectoryObjectInner> getGroupMembersAsync(String objectId, Context context) {
        return new PagedFlux(() -> this.getGroupMembersSinglePageAsync(objectId, context), nextLink -> this.getGroupMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> getGroupMembers(String objectId) {
        return new PagedIterable(this.getGroupMembersAsync(objectId));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> getGroupMembers(String objectId, Context context) {
        return new PagedIterable(this.getGroupMembersAsync(objectId, context));
    }

    @Override
    public Mono<Response<ADGroupInner>> getWithResponseAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ADGroupInner>> getWithResponseAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<ADGroupInner> getAsync(String objectId) {
        return this.getWithResponseAsync(objectId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ADGroupInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ADGroupInner get(String objectId) {
        return (ADGroupInner)this.getAsync(objectId).block();
    }

    @Override
    public Response<ADGroupInner> getWithResponse(String objectId, Context context) {
        return (Response)this.getWithResponseAsync(objectId, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String objectId) {
        return this.deleteWithResponseAsync(objectId).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String objectId) {
        this.deleteAsync(objectId).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String objectId, Context context) {
        return (Response)this.deleteWithResponseAsync(objectId, context).block();
    }

    private Mono<PagedResponse<String>> getMemberGroupsSinglePageAsync(String objectId, boolean securityEnabledOnly) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        GroupGetMemberGroupsParameters parameters = new GroupGetMemberGroupsParameters();
        parameters.withSecurityEnabledOnly(securityEnabledOnly);
        return FluxUtil.withContext(context -> this.service.getMemberGroups(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GroupGetMemberGroupsResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> getMemberGroupsSinglePageAsync(String objectId, boolean securityEnabledOnly, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        GroupGetMemberGroupsParameters parameters = new GroupGetMemberGroupsParameters();
        parameters.withSecurityEnabledOnly(securityEnabledOnly);
        context = this.client.mergeContext(context);
        return this.service.getMemberGroups(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GroupGetMemberGroupsResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<String> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly) {
        return new PagedFlux(() -> this.getMemberGroupsSinglePageAsync(objectId, securityEnabledOnly));
    }

    private PagedFlux<String> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly, Context context) {
        return new PagedFlux(() -> this.getMemberGroupsSinglePageAsync(objectId, securityEnabledOnly, context));
    }

    @Override
    public PagedIterable<String> getMemberGroups(String objectId, boolean securityEnabledOnly) {
        return new PagedIterable(this.getMemberGroupsAsync(objectId, securityEnabledOnly));
    }

    @Override
    public PagedIterable<String> getMemberGroups(String objectId, boolean securityEnabledOnly, Context context) {
        return new PagedIterable(this.getMemberGroupsAsync(objectId, securityEnabledOnly, context));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersSinglePageAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwners(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersSinglePageAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwners(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<DirectoryObjectInner> listOwnersAsync(String objectId) {
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(objectId), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<DirectoryObjectInner> listOwnersAsync(String objectId, Context context) {
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(objectId, context), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> listOwners(String objectId) {
        return new PagedIterable(this.listOwnersAsync(objectId));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> listOwners(String objectId, Context context) {
        return new PagedIterable(this.listOwnersAsync(objectId, context));
    }

    @Override
    public Mono<Response<Void>> addOwnerWithResponseAsync(String objectId, String url) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (url == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter url is required and cannot be null."));
        }
        AddOwnerParameters parameters = new AddOwnerParameters();
        parameters.withUrl(url);
        return FluxUtil.withContext(context -> this.service.addOwner(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> addOwnerWithResponseAsync(String objectId, String url, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (url == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter url is required and cannot be null."));
        }
        AddOwnerParameters parameters = new AddOwnerParameters();
        parameters.withUrl(url);
        context = this.client.mergeContext(context);
        return this.service.addOwner(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<Void> addOwnerAsync(String objectId, String url) {
        return this.addOwnerWithResponseAsync(objectId, url).flatMap(res -> Mono.empty());
    }

    @Override
    public void addOwner(String objectId, String url) {
        this.addOwnerAsync(objectId, url).block();
    }

    @Override
    public Response<Void> addOwnerWithResponse(String objectId, String url, Context context) {
        return (Response)this.addOwnerWithResponseAsync(objectId, url, context).block();
    }

    @Override
    public Mono<Response<Void>> removeOwnerWithResponseAsync(String objectId, String ownerObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (ownerObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ownerObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.removeOwner(this.client.getEndpoint(), objectId, ownerObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> removeOwnerWithResponseAsync(String objectId, String ownerObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (ownerObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ownerObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.removeOwner(this.client.getEndpoint(), objectId, ownerObjectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<Void> removeOwnerAsync(String objectId, String ownerObjectId) {
        return this.removeOwnerWithResponseAsync(objectId, ownerObjectId).flatMap(res -> Mono.empty());
    }

    @Override
    public void removeOwner(String objectId, String ownerObjectId) {
        this.removeOwnerAsync(objectId, ownerObjectId).block();
    }

    @Override
    public Response<Void> removeOwnerWithResponse(String objectId, String ownerObjectId, Context context) {
        return (Response)this.removeOwnerWithResponseAsync(objectId, ownerObjectId, context).block();
    }

    private Mono<PagedResponse<ADGroupInner>> listNextSinglePageAsync(String nextLink) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GroupListResult)res.getValue()).value(), ((GroupListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ADGroupInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GroupListResult)res.getValue()).value(), ((GroupListResult)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> getGroupMembersNextSinglePageAsync(String nextLink) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getGroupMembersNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> getGroupMembersNextSinglePageAsync(String nextLink, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getGroupMembersNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwnersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwnersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="GraphRbacManagementC")
    private static interface GroupsService {
        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/isMemberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<CheckGroupMembershipResultInner>> isMemberOf(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="tenantID") String var3, @BodyParam(value="application/json") CheckGroupMembershipParameters var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{tenantID}/groups/{groupObjectId}/$links/members/{memberObjectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> removeMember(@HostParam(value="$host") String var1, @PathParam(value="groupObjectId") String var2, @PathParam(value="memberObjectId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="tenantID") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/{tenantID}/groups/{groupObjectId}/$links/members")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> addMember(@HostParam(value="$host") String var1, @PathParam(value="groupObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") GroupAddMemberParameters var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/groups")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ADGroupInner>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="tenantID") String var3, @BodyParam(value="application/json") GroupCreateParameters var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/groups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<GroupListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/groups/{objectId}/members")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<DirectoryObjectListResult>> getGroupMembers(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/groups/{objectId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ADGroupInner>> get(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{tenantID}/groups/{objectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/groups/{objectId}/getMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<GroupGetMemberGroupsResult>> getMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") GroupGetMemberGroupsParameters var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/groups/{objectId}/owners")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<DirectoryObjectListResult>> listOwners(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/{tenantID}/groups/{objectId}/$links/owners")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> addOwner(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") AddOwnerParameters var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{tenantID}/groups/{objectId}/$links/owners/{ownerObjectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> removeOwner(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @PathParam(value="ownerObjectId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="tenantID") String var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<GroupListResult>> listNext(@HostParam(value="$host") String var1, @PathParam(value="nextLink", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<DirectoryObjectListResult>> getGroupMembersNext(@HostParam(value="$host") String var1, @PathParam(value="nextLink", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<DirectoryObjectListResult>> listOwnersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

