// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryAdministrativeUnitsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryAdministrativeUnitsSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAdministrativeUnitInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScopedRoleMembershipInner;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DirectoryAdministrativeUnitsClient. */
public interface DirectoryAdministrativeUnitsClient {
    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<String> select,
        List<String> expand);

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String administrativeUnitId);

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String administrativeUnitId);

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphExtensionInner> listExtensions(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(
        String administrativeUnitId, MicrosoftGraphExtensionInner body);

    /**
     * Create new navigation property to extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(
        String administrativeUnitId, MicrosoftGraphExtensionInner body);

    /**
     * Create new navigation property to extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphExtensionInner createExtensions(String administrativeUnitId, MicrosoftGraphExtensionInner body);

    /**
     * Create new navigation property to extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(
        String administrativeUnitId, MicrosoftGraphExtensionInner body, Context context);

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(
        String administrativeUnitId, String extensionId, List<String> select, List<String> expand);

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(
        String administrativeUnitId, String extensionId, List<String> select, List<String> expand);

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String administrativeUnitId, String extensionId);

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphExtensionInner getExtensions(String administrativeUnitId, String extensionId);

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(
        String administrativeUnitId, String extensionId, List<String> select, List<String> expand, Context context);

    /**
     * Update the navigation property extensions in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateExtensionsWithResponseAsync(
        String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body);

    /**
     * Update the navigation property extensions in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateExtensionsAsync(
        String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body);

    /**
     * Update the navigation property extensions in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateExtensions(String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body);

    /**
     * Update the navigation property extensions in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateExtensionsWithResponse(
        String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body, Context context);

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteExtensionsWithResponseAsync(
        String administrativeUnitId, String extensionId, String ifMatch);

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteExtensionsAsync(String administrativeUnitId, String extensionId, String ifMatch);

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteExtensionsAsync(String administrativeUnitId, String extensionId);

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteExtensions(String administrativeUnitId, String extensionId);

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteExtensionsWithResponse(
        String administrativeUnitId, String extensionId, String ifMatch, Context context);

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand);

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String administrativeUnitId);

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String administrativeUnitId);

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefMembersAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby);

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefMembersAsync(String administrativeUnitId);

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefMembers(String administrativeUnitId);

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefMembers(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to members for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefMembersWithResponseAsync(
        String administrativeUnitId, Map<String, Object> body);

    /**
     * Create new navigation property ref to members for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefMembersAsync(String administrativeUnitId, Map<String, Object> body);

    /**
     * Create new navigation property ref to members for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefMembers(String administrativeUnitId, Map<String, Object> body);

    /**
     * Create new navigation property ref to members for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefMembersWithResponse(
        String administrativeUnitId, Map<String, Object> body, Context context);

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembersAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand);

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembersAsync(String administrativeUnitId);

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembers(String administrativeUnitId);

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembers(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedRoleMembersWithResponseAsync(
        String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Create new navigation property to scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphScopedRoleMembershipInner> createScopedRoleMembersAsync(
        String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Create new navigation property to scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphScopedRoleMembershipInner createScopedRoleMembers(
        String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Create new navigation property to scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphScopedRoleMembershipInner> createScopedRoleMembersWithResponse(
        String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body, Context context);

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedRoleMembersWithResponseAsync(
        String administrativeUnitId,
        String scopedRoleMembershipId,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand);

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMembersAsync(
        String administrativeUnitId,
        String scopedRoleMembershipId,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand);

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMembersAsync(
        String administrativeUnitId, String scopedRoleMembershipId);

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphScopedRoleMembershipInner getScopedRoleMembers(
        String administrativeUnitId, String scopedRoleMembershipId);

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMembersWithResponse(
        String administrativeUnitId,
        String scopedRoleMembershipId,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Update the navigation property scopedRoleMembers in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateScopedRoleMembersWithResponseAsync(
        String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Update the navigation property scopedRoleMembers in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateScopedRoleMembersAsync(
        String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Update the navigation property scopedRoleMembers in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateScopedRoleMembers(
        String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Update the navigation property scopedRoleMembers in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateScopedRoleMembersWithResponse(
        String administrativeUnitId,
        String scopedRoleMembershipId,
        MicrosoftGraphScopedRoleMembershipInner body,
        Context context);

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteScopedRoleMembersWithResponseAsync(
        String administrativeUnitId, String scopedRoleMembershipId, String ifMatch);

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteScopedRoleMembersAsync(String administrativeUnitId, String scopedRoleMembershipId, String ifMatch);

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteScopedRoleMembersAsync(String administrativeUnitId, String scopedRoleMembershipId);

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteScopedRoleMembers(String administrativeUnitId, String scopedRoleMembershipId);

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteScopedRoleMembersWithResponse(
        String administrativeUnitId, String scopedRoleMembershipId, String ifMatch, Context context);

    /**
     * Invoke function delta.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<MicrosoftGraphAdministrativeUnitInner>>> deltaWithResponseAsync();

    /**
     * Invoke function delta.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<MicrosoftGraphAdministrativeUnitInner>> deltaAsync();

    /**
     * Invoke function delta.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<MicrosoftGraphAdministrativeUnitInner> delta();

    /**
     * Invoke function delta.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<MicrosoftGraphAdministrativeUnitInner>> deltaWithResponse(Context context);
}
