// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesDirectoryRoleTemplateOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesDirectoryRoleTemplateSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryRoleTemplateInner;
import java.util.List;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * DirectoryRoleTemplatesDirectoryRoleTemplatesClient.
 */
public interface DirectoryRoleTemplatesDirectoryRoleTemplatesClient {
    /**
     * Get entities from directoryRoleTemplates.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplateAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand);

    /**
     * Get entities from directoryRoleTemplates.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplateAsync();

    /**
     * Get entities from directoryRoleTemplates.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplate();

    /**
     * Get entities from directoryRoleTemplates.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplate(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand,
        Context context);

    /**
     * Add new entity to directoryRoleTemplates.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> createDirectoryRoleTemplateWithResponseAsync(
        MicrosoftGraphDirectoryRoleTemplateInner body);

    /**
     * Add new entity to directoryRoleTemplates.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDirectoryRoleTemplateInner> createDirectoryRoleTemplateAsync(
        MicrosoftGraphDirectoryRoleTemplateInner body);

    /**
     * Add new entity to directoryRoleTemplates.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDirectoryRoleTemplateInner createDirectoryRoleTemplate(MicrosoftGraphDirectoryRoleTemplateInner body);

    /**
     * Add new entity to directoryRoleTemplates.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDirectoryRoleTemplateInner> createDirectoryRoleTemplateWithResponse(
        MicrosoftGraphDirectoryRoleTemplateInner body, Context context);

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> getDirectoryRoleTemplateWithResponseAsync(
        String directoryRoleTemplateId,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand);

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDirectoryRoleTemplateInner> getDirectoryRoleTemplateAsync(
        String directoryRoleTemplateId,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand);

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDirectoryRoleTemplateInner> getDirectoryRoleTemplateAsync(String directoryRoleTemplateId);

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDirectoryRoleTemplateInner getDirectoryRoleTemplate(String directoryRoleTemplateId);

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDirectoryRoleTemplateInner> getDirectoryRoleTemplateWithResponse(
        String directoryRoleTemplateId,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand,
        Context context);

    /**
     * Update entity in directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateDirectoryRoleTemplateWithResponseAsync(
        String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body);

    /**
     * Update entity in directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateDirectoryRoleTemplateAsync(
        String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body);

    /**
     * Update entity in directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateDirectoryRoleTemplate(String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body);

    /**
     * Update entity in directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateDirectoryRoleTemplateWithResponse(
        String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body, Context context);

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteDirectoryRoleTemplateWithResponseAsync(String directoryRoleTemplateId, String ifMatch);

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteDirectoryRoleTemplateAsync(String directoryRoleTemplateId, String ifMatch);

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteDirectoryRoleTemplateAsync(String directoryRoleTemplateId);

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteDirectoryRoleTemplate(String directoryRoleTemplateId);

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteDirectoryRoleTemplateWithResponse(
        String directoryRoleTemplateId, String ifMatch, Context context);
}
