// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.DomainsForceDeleteRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DomainsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DomainsSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDomainDnsRecordInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDomainInner;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DomainsClient. */
public interface DomainsClient {
    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listDomainNameReferencesAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand);

    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listDomainNameReferencesAsync(String domainId);

    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listDomainNameReferences(String domainId);

    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listDomainNameReferences(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefDomainNameReferencesAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby);

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefDomainNameReferencesAsync(String domainId);

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefDomainNameReferences(String domainId);

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefDomainNameReferences(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to domainNameReferences for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefDomainNameReferencesWithResponseAsync(
        String domainId, Map<String, Object> body);

    /**
     * Create new navigation property ref to domainNameReferences for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefDomainNameReferencesAsync(String domainId, Map<String, Object> body);

    /**
     * Create new navigation property ref to domainNameReferences for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefDomainNameReferences(String domainId, Map<String, Object> body);

    /**
     * Create new navigation property ref to domainNameReferences for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefDomainNameReferencesWithResponse(
        String domainId, Map<String, Object> body, Context context);

    /**
     * Invoke action forceDelete.
     *
     * @param domainId key: id of domain.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> forceDeleteWithResponseAsync(String domainId, DomainsForceDeleteRequestBody body);

    /**
     * Invoke action forceDelete.
     *
     * @param domainId key: id of domain.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> forceDeleteAsync(String domainId, DomainsForceDeleteRequestBody body);

    /**
     * Invoke action forceDelete.
     *
     * @param domainId key: id of domain.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void forceDelete(String domainId, DomainsForceDeleteRequestBody body);

    /**
     * Invoke action forceDelete.
     *
     * @param domainId key: id of domain.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> forceDeleteWithResponse(String domainId, DomainsForceDeleteRequestBody body, Context context);

    /**
     * Invoke action verify.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domain.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDomainInner>> verifyWithResponseAsync(String domainId);

    /**
     * Invoke action verify.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domain.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDomainInner> verifyAsync(String domainId);

    /**
     * Invoke action verify.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domain.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDomainInner verify(String domainId);

    /**
     * Invoke action verify.
     *
     * @param domainId key: id of domain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domain.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDomainInner> verifyWithResponse(String domainId, Context context);

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecordsAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand);

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecordsAsync(String domainId);

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecords(String domainId);

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecords(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createServiceConfigurationRecordsWithResponseAsync(
        String domainId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Create new navigation property to serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDomainDnsRecordInner> createServiceConfigurationRecordsAsync(
        String domainId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Create new navigation property to serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDomainDnsRecordInner createServiceConfigurationRecords(
        String domainId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Create new navigation property to serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDomainDnsRecordInner> createServiceConfigurationRecordsWithResponse(
        String domainId, MicrosoftGraphDomainDnsRecordInner body, Context context);

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getServiceConfigurationRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand);

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDomainDnsRecordInner> getServiceConfigurationRecordsAsync(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand);

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDomainDnsRecordInner> getServiceConfigurationRecordsAsync(
        String domainId, String domainDnsRecordId);

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDomainDnsRecordInner getServiceConfigurationRecords(String domainId, String domainDnsRecordId);

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDomainDnsRecordInner> getServiceConfigurationRecordsWithResponse(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand, Context context);

    /**
     * Update the navigation property serviceConfigurationRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateServiceConfigurationRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Update the navigation property serviceConfigurationRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateServiceConfigurationRecordsAsync(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Update the navigation property serviceConfigurationRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateServiceConfigurationRecords(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Update the navigation property serviceConfigurationRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateServiceConfigurationRecordsWithResponse(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body, Context context);

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteServiceConfigurationRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, String ifMatch);

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteServiceConfigurationRecordsAsync(String domainId, String domainDnsRecordId, String ifMatch);

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteServiceConfigurationRecordsAsync(String domainId, String domainDnsRecordId);

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteServiceConfigurationRecords(String domainId, String domainDnsRecordId);

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteServiceConfigurationRecordsWithResponse(
        String domainId, String domainDnsRecordId, String ifMatch, Context context);

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecordsAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand);

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecordsAsync(String domainId);

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecords(String domainId);

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecords(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createVerificationDnsRecordsWithResponseAsync(
        String domainId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Create new navigation property to verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDomainDnsRecordInner> createVerificationDnsRecordsAsync(
        String domainId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Create new navigation property to verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDomainDnsRecordInner createVerificationDnsRecords(
        String domainId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Create new navigation property to verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDomainDnsRecordInner> createVerificationDnsRecordsWithResponse(
        String domainId, MicrosoftGraphDomainDnsRecordInner body, Context context);

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getVerificationDnsRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand);

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDomainDnsRecordInner> getVerificationDnsRecordsAsync(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand);

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDomainDnsRecordInner> getVerificationDnsRecordsAsync(String domainId, String domainDnsRecordId);

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDomainDnsRecordInner getVerificationDnsRecords(String domainId, String domainDnsRecordId);

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDomainDnsRecordInner> getVerificationDnsRecordsWithResponse(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand, Context context);

    /**
     * Update the navigation property verificationDnsRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateVerificationDnsRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Update the navigation property verificationDnsRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateVerificationDnsRecordsAsync(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Update the navigation property verificationDnsRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateVerificationDnsRecords(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body);

    /**
     * Update the navigation property verificationDnsRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateVerificationDnsRecordsWithResponse(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body, Context context);

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteVerificationDnsRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, String ifMatch);

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteVerificationDnsRecordsAsync(String domainId, String domainDnsRecordId, String ifMatch);

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteVerificationDnsRecordsAsync(String domainId, String domainDnsRecordId);

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteVerificationDnsRecords(String domainId, String domainDnsRecordId);

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteVerificationDnsRecordsWithResponse(
        String domainId, String domainDnsRecordId, String ifMatch, Context context);
}
