// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSubscribedSkuInner;
import com.azure.resourcemanager.authorization.fluent.models.SubscribedSkusSubscribedSkuOrderby;
import com.azure.resourcemanager.authorization.fluent.models.SubscribedSkusSubscribedSkuSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in SubscribedSkusSubscribedSkusClient. */
public interface SubscribedSkusSubscribedSkusClient {
    /**
     * Get entities from subscribedSkus.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphSubscribedSkuInner> listSubscribedSkuAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<SubscribedSkusSubscribedSkuOrderby> orderby,
        List<SubscribedSkusSubscribedSkuSelect> select,
        List<String> expand);

    /**
     * Get entities from subscribedSkus.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphSubscribedSkuInner> listSubscribedSkuAsync();

    /**
     * Get entities from subscribedSkus.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphSubscribedSkuInner> listSubscribedSku();

    /**
     * Get entities from subscribedSkus.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphSubscribedSkuInner> listSubscribedSku(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<SubscribedSkusSubscribedSkuOrderby> orderby,
        List<SubscribedSkusSubscribedSkuSelect> select,
        List<String> expand,
        Context context);

    /**
     * Add new entity to subscribedSkus.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphSubscribedSkuInner>> createSubscribedSkuWithResponseAsync(
        MicrosoftGraphSubscribedSkuInner body);

    /**
     * Add new entity to subscribedSkus.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphSubscribedSkuInner> createSubscribedSkuAsync(MicrosoftGraphSubscribedSkuInner body);

    /**
     * Add new entity to subscribedSkus.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphSubscribedSkuInner createSubscribedSku(MicrosoftGraphSubscribedSkuInner body);

    /**
     * Add new entity to subscribedSkus.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphSubscribedSkuInner> createSubscribedSkuWithResponse(
        MicrosoftGraphSubscribedSkuInner body, Context context);

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphSubscribedSkuInner>> getSubscribedSkuWithResponseAsync(
        String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand);

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphSubscribedSkuInner> getSubscribedSkuAsync(
        String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand);

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphSubscribedSkuInner> getSubscribedSkuAsync(String subscribedSkuId);

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphSubscribedSkuInner getSubscribedSku(String subscribedSkuId);

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphSubscribedSkuInner> getSubscribedSkuWithResponse(
        String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand, Context context);

    /**
     * Update entity in subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateSubscribedSkuWithResponseAsync(
        String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body);

    /**
     * Update entity in subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateSubscribedSkuAsync(String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body);

    /**
     * Update entity in subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateSubscribedSku(String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body);

    /**
     * Update entity in subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateSubscribedSkuWithResponse(
        String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body, Context context);

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteSubscribedSkuWithResponseAsync(String subscribedSkuId, String ifMatch);

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSubscribedSkuAsync(String subscribedSkuId, String ifMatch);

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSubscribedSkuAsync(String subscribedSkuId);

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSubscribedSku(String subscribedSkuId);

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteSubscribedSkuWithResponse(String subscribedSkuId, String ifMatch, Context context);
}
