// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphShiftPreferencesInner;
import com.azure.resourcemanager.authorization.fluent.models.UsersSettingsSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in UsersSettingsClient. */
public interface UsersSettingsClient {
    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphShiftPreferencesInner>> getShiftPreferencesWithResponseAsync(
        String userId, List<UsersSettingsSelect> select, List<String> expand);

    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphShiftPreferencesInner> getShiftPreferencesAsync(
        String userId, List<UsersSettingsSelect> select, List<String> expand);

    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphShiftPreferencesInner> getShiftPreferencesAsync(String userId);

    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphShiftPreferencesInner getShiftPreferences(String userId);

    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphShiftPreferencesInner> getShiftPreferencesWithResponse(
        String userId, List<UsersSettingsSelect> select, List<String> expand, Context context);

    /**
     * Update the navigation property shiftPreferences in users.
     *
     * @param userId key: id of user.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateShiftPreferencesWithResponseAsync(
        String userId, MicrosoftGraphShiftPreferencesInner body);

    /**
     * Update the navigation property shiftPreferences in users.
     *
     * @param userId key: id of user.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateShiftPreferencesAsync(String userId, MicrosoftGraphShiftPreferencesInner body);

    /**
     * Update the navigation property shiftPreferences in users.
     *
     * @param userId key: id of user.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateShiftPreferences(String userId, MicrosoftGraphShiftPreferencesInner body);

    /**
     * Update the navigation property shiftPreferences in users.
     *
     * @param userId key: id of user.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateShiftPreferencesWithResponse(
        String userId, MicrosoftGraphShiftPreferencesInner body, Context context);

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteShiftPreferencesWithResponseAsync(String userId, String ifMatch);

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteShiftPreferencesAsync(String userId, String ifMatch);

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteShiftPreferencesAsync(String userId);

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteShiftPreferences(String userId);

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteShiftPreferencesWithResponse(String userId, String ifMatch, Context context);
}
