// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTodoTaskListInner;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoExpand;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in UsersTodosClient. */
public interface UsersTodosClient {
    /**
     * Get lists from users.
     *
     * @param userId key: id of user.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lists from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphTodoTaskListInner> listListsAsync(
        String userId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoOrderby> orderby,
        List<UsersTodoSelect> select,
        List<UsersTodoExpand> expand);

    /**
     * Get lists from users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lists from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphTodoTaskListInner> listListsAsync(String userId);

    /**
     * Get lists from users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lists from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphTodoTaskListInner> listLists(String userId);

    /**
     * Get lists from users.
     *
     * @param userId key: id of user.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lists from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphTodoTaskListInner> listLists(
        String userId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoOrderby> orderby,
        List<UsersTodoSelect> select,
        List<UsersTodoExpand> expand,
        Context context);

    /**
     * Create new navigation property to lists for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return todoTaskList.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphTodoTaskListInner>> createListsWithResponseAsync(
        String userId, MicrosoftGraphTodoTaskListInner body);

    /**
     * Create new navigation property to lists for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return todoTaskList.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphTodoTaskListInner> createListsAsync(String userId, MicrosoftGraphTodoTaskListInner body);

    /**
     * Create new navigation property to lists for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return todoTaskList.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphTodoTaskListInner createLists(String userId, MicrosoftGraphTodoTaskListInner body);

    /**
     * Create new navigation property to lists for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return todoTaskList.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphTodoTaskListInner> createListsWithResponse(
        String userId, MicrosoftGraphTodoTaskListInner body, Context context);

    /**
     * Get lists from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lists from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphTodoTaskListInner>> getListsWithResponseAsync(
        String userId, String todoTaskListId, List<UsersTodoSelect> select, List<UsersTodoExpand> expand);

    /**
     * Get lists from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lists from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphTodoTaskListInner> getListsAsync(
        String userId, String todoTaskListId, List<UsersTodoSelect> select, List<UsersTodoExpand> expand);

    /**
     * Get lists from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lists from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphTodoTaskListInner> getListsAsync(String userId, String todoTaskListId);

    /**
     * Get lists from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lists from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphTodoTaskListInner getLists(String userId, String todoTaskListId);

    /**
     * Get lists from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lists from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphTodoTaskListInner> getListsWithResponse(
        String userId,
        String todoTaskListId,
        List<UsersTodoSelect> select,
        List<UsersTodoExpand> expand,
        Context context);

    /**
     * Update the navigation property lists in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateListsWithResponseAsync(
        String userId, String todoTaskListId, MicrosoftGraphTodoTaskListInner body);

    /**
     * Update the navigation property lists in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateListsAsync(String userId, String todoTaskListId, MicrosoftGraphTodoTaskListInner body);

    /**
     * Update the navigation property lists in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateLists(String userId, String todoTaskListId, MicrosoftGraphTodoTaskListInner body);

    /**
     * Update the navigation property lists in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateListsWithResponse(
        String userId, String todoTaskListId, MicrosoftGraphTodoTaskListInner body, Context context);

    /**
     * Delete navigation property lists for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteListsWithResponseAsync(String userId, String todoTaskListId, String ifMatch);

    /**
     * Delete navigation property lists for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteListsAsync(String userId, String todoTaskListId, String ifMatch);

    /**
     * Delete navigation property lists for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteListsAsync(String userId, String todoTaskListId);

    /**
     * Delete navigation property lists for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteLists(String userId, String todoTaskListId);

    /**
     * Delete navigation property lists for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteListsWithResponse(String userId, String todoTaskListId, String ifMatch, Context context);
}
