// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for GroupsSelect. */
public final class GroupsSelect extends ExpandableStringEnum<GroupsSelect> {
    /** Static value id for GroupsSelect. */
    public static final GroupsSelect ID = fromString("id");

    /** Static value deletedDateTime for GroupsSelect. */
    public static final GroupsSelect DELETED_DATE_TIME = fromString("deletedDateTime");

    /** Static value appRoleId for GroupsSelect. */
    public static final GroupsSelect APP_ROLE_ID = fromString("appRoleId");

    /** Static value createdDateTime for GroupsSelect. */
    public static final GroupsSelect CREATED_DATE_TIME = fromString("createdDateTime");

    /** Static value principalDisplayName for GroupsSelect. */
    public static final GroupsSelect PRINCIPAL_DISPLAY_NAME = fromString("principalDisplayName");

    /** Static value principalId for GroupsSelect. */
    public static final GroupsSelect PRINCIPAL_ID = fromString("principalId");

    /** Static value principalType for GroupsSelect. */
    public static final GroupsSelect PRINCIPAL_TYPE = fromString("principalType");

    /** Static value resourceDisplayName for GroupsSelect. */
    public static final GroupsSelect RESOURCE_DISPLAY_NAME = fromString("resourceDisplayName");

    /** Static value resourceId for GroupsSelect. */
    public static final GroupsSelect RESOURCE_ID = fromString("resourceId");

    /**
     * Creates or finds a GroupsSelect from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding GroupsSelect.
     */
    @JsonCreator
    public static GroupsSelect fromString(String name) {
        return fromString(name, GroupsSelect.class);
    }

    /** @return known GroupsSelect values. */
    public static Collection<GroupsSelect> values() {
        return values(GroupsSelect.class);
    }
}
