// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** calendarPermission. */
@Fluent
public final class MicrosoftGraphCalendarPermission extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphCalendarPermission.class);

    /*
     * List of allowed sharing or delegating permission levels for the
     * calendar. Possible values are: none, freeBusyRead, limitedRead, read,
     * write, delegateWithoutPrivateEventAccess,
     * delegateWithPrivateEventAccess, custom.
     */
    @JsonProperty(value = "allowedRoles")
    private List<MicrosoftGraphCalendarRoleType> allowedRoles;

    /*
     * emailAddress
     */
    @JsonProperty(value = "emailAddress")
    private MicrosoftGraphEmailAddress emailAddress;

    /*
     * True if the user in context (sharee or delegate) is inside the same
     * organization as the calendar owner.
     */
    @JsonProperty(value = "isInsideOrganization")
    private Boolean isInsideOrganization;

    /*
     * True if the user can be removed from the list of sharees or delegates
     * for the specified calendar, false otherwise. The 'My organization' user
     * determines the permissions other people within your organization have to
     * the given calendar. You cannot remove 'My organization' as a sharee to a
     * calendar.
     */
    @JsonProperty(value = "isRemovable")
    private Boolean isRemovable;

    /*
     * The role property.
     */
    @JsonProperty(value = "role")
    private MicrosoftGraphCalendarRoleType role;

    /*
     * calendarPermission
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the allowedRoles property: List of allowed sharing or delegating permission levels for the calendar. Possible
     * values are: none, freeBusyRead, limitedRead, read, write, delegateWithoutPrivateEventAccess,
     * delegateWithPrivateEventAccess, custom.
     *
     * @return the allowedRoles value.
     */
    public List<MicrosoftGraphCalendarRoleType> allowedRoles() {
        return this.allowedRoles;
    }

    /**
     * Set the allowedRoles property: List of allowed sharing or delegating permission levels for the calendar. Possible
     * values are: none, freeBusyRead, limitedRead, read, write, delegateWithoutPrivateEventAccess,
     * delegateWithPrivateEventAccess, custom.
     *
     * @param allowedRoles the allowedRoles value to set.
     * @return the MicrosoftGraphCalendarPermission object itself.
     */
    public MicrosoftGraphCalendarPermission withAllowedRoles(List<MicrosoftGraphCalendarRoleType> allowedRoles) {
        this.allowedRoles = allowedRoles;
        return this;
    }

    /**
     * Get the emailAddress property: emailAddress.
     *
     * @return the emailAddress value.
     */
    public MicrosoftGraphEmailAddress emailAddress() {
        return this.emailAddress;
    }

    /**
     * Set the emailAddress property: emailAddress.
     *
     * @param emailAddress the emailAddress value to set.
     * @return the MicrosoftGraphCalendarPermission object itself.
     */
    public MicrosoftGraphCalendarPermission withEmailAddress(MicrosoftGraphEmailAddress emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    /**
     * Get the isInsideOrganization property: True if the user in context (sharee or delegate) is inside the same
     * organization as the calendar owner.
     *
     * @return the isInsideOrganization value.
     */
    public Boolean isInsideOrganization() {
        return this.isInsideOrganization;
    }

    /**
     * Set the isInsideOrganization property: True if the user in context (sharee or delegate) is inside the same
     * organization as the calendar owner.
     *
     * @param isInsideOrganization the isInsideOrganization value to set.
     * @return the MicrosoftGraphCalendarPermission object itself.
     */
    public MicrosoftGraphCalendarPermission withIsInsideOrganization(Boolean isInsideOrganization) {
        this.isInsideOrganization = isInsideOrganization;
        return this;
    }

    /**
     * Get the isRemovable property: True if the user can be removed from the list of sharees or delegates for the
     * specified calendar, false otherwise. The 'My organization' user determines the permissions other people within
     * your organization have to the given calendar. You cannot remove 'My organization' as a sharee to a calendar.
     *
     * @return the isRemovable value.
     */
    public Boolean isRemovable() {
        return this.isRemovable;
    }

    /**
     * Set the isRemovable property: True if the user can be removed from the list of sharees or delegates for the
     * specified calendar, false otherwise. The 'My organization' user determines the permissions other people within
     * your organization have to the given calendar. You cannot remove 'My organization' as a sharee to a calendar.
     *
     * @param isRemovable the isRemovable value to set.
     * @return the MicrosoftGraphCalendarPermission object itself.
     */
    public MicrosoftGraphCalendarPermission withIsRemovable(Boolean isRemovable) {
        this.isRemovable = isRemovable;
        return this;
    }

    /**
     * Get the role property: The role property.
     *
     * @return the role value.
     */
    public MicrosoftGraphCalendarRoleType role() {
        return this.role;
    }

    /**
     * Set the role property: The role property.
     *
     * @param role the role value to set.
     * @return the MicrosoftGraphCalendarPermission object itself.
     */
    public MicrosoftGraphCalendarPermission withRole(MicrosoftGraphCalendarRoleType role) {
        this.role = role;
        return this;
    }

    /**
     * Get the additionalProperties property: calendarPermission.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: calendarPermission.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphCalendarPermission object itself.
     */
    public MicrosoftGraphCalendarPermission withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphCalendarPermission withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (emailAddress() != null) {
            emailAddress().validate();
        }
    }
}
