// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/**
 * Device categories provides a way to organize your devices. Using device categories, company administrators can define
 * their own categories that make sense to their company. These categories can then be applied to a device in the Intune
 * Azure console or selected by a user during device enrollment. You can filter reports and create dynamic Azure Active
 * Directory device groups based on device categories.
 */
@Fluent
public final class MicrosoftGraphDeviceCategory extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphDeviceCategory.class);

    /*
     * Optional description for the device category.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Display name for the device category.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Device categories provides a way to organize your devices. Using device
     * categories, company administrators can define their own categories that
     * make sense to their company. These categories can then be applied to a
     * device in the Intune Azure console or selected by a user during device
     * enrollment. You can filter reports and create dynamic Azure Active
     * Directory device groups based on device categories.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the description property: Optional description for the device category.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Optional description for the device category.
     *
     * @param description the description value to set.
     * @return the MicrosoftGraphDeviceCategory object itself.
     */
    public MicrosoftGraphDeviceCategory withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: Display name for the device category.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display name for the device category.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphDeviceCategory object itself.
     */
    public MicrosoftGraphDeviceCategory withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the additionalProperties property: Device categories provides a way to organize your devices. Using device
     * categories, company administrators can define their own categories that make sense to their company. These
     * categories can then be applied to a device in the Intune Azure console or selected by a user during device
     * enrollment. You can filter reports and create dynamic Azure Active Directory device groups based on device
     * categories.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Device categories provides a way to organize your devices. Using device
     * categories, company administrators can define their own categories that make sense to their company. These
     * categories can then be applied to a device in the Intune Azure console or selected by a user during device
     * enrollment. You can filter reports and create dynamic Azure Active Directory device groups based on device
     * categories.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDeviceCategory object itself.
     */
    public MicrosoftGraphDeviceCategory withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphDeviceCategory withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
