// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** inferenceClassificationOverride. */
@Fluent
public final class MicrosoftGraphInferenceClassificationOverride extends MicrosoftGraphEntity {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(MicrosoftGraphInferenceClassificationOverride.class);

    /*
     * The classifyAs property.
     */
    @JsonProperty(value = "classifyAs")
    private MicrosoftGraphInferenceClassificationType classifyAs;

    /*
     * emailAddress
     */
    @JsonProperty(value = "senderEmailAddress")
    private MicrosoftGraphEmailAddress senderEmailAddress;

    /*
     * inferenceClassificationOverride
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the classifyAs property: The classifyAs property.
     *
     * @return the classifyAs value.
     */
    public MicrosoftGraphInferenceClassificationType classifyAs() {
        return this.classifyAs;
    }

    /**
     * Set the classifyAs property: The classifyAs property.
     *
     * @param classifyAs the classifyAs value to set.
     * @return the MicrosoftGraphInferenceClassificationOverride object itself.
     */
    public MicrosoftGraphInferenceClassificationOverride withClassifyAs(
        MicrosoftGraphInferenceClassificationType classifyAs) {
        this.classifyAs = classifyAs;
        return this;
    }

    /**
     * Get the senderEmailAddress property: emailAddress.
     *
     * @return the senderEmailAddress value.
     */
    public MicrosoftGraphEmailAddress senderEmailAddress() {
        return this.senderEmailAddress;
    }

    /**
     * Set the senderEmailAddress property: emailAddress.
     *
     * @param senderEmailAddress the senderEmailAddress value to set.
     * @return the MicrosoftGraphInferenceClassificationOverride object itself.
     */
    public MicrosoftGraphInferenceClassificationOverride withSenderEmailAddress(
        MicrosoftGraphEmailAddress senderEmailAddress) {
        this.senderEmailAddress = senderEmailAddress;
        return this;
    }

    /**
     * Get the additionalProperties property: inferenceClassificationOverride.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: inferenceClassificationOverride.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphInferenceClassificationOverride object itself.
     */
    public MicrosoftGraphInferenceClassificationOverride withAdditionalProperties(
        Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphInferenceClassificationOverride withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (senderEmailAddress() != null) {
            senderEmailAddress().validate();
        }
    }
}
