// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** outlookUser. */
@Fluent
public final class MicrosoftGraphOutlookUserInner extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphOutlookUserInner.class);

    /*
     * A list of categories defined for the user.
     */
    @JsonProperty(value = "masterCategories")
    private List<MicrosoftGraphOutlookCategoryInner> masterCategories;

    /*
     * outlookUser
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the masterCategories property: A list of categories defined for the user.
     *
     * @return the masterCategories value.
     */
    public List<MicrosoftGraphOutlookCategoryInner> masterCategories() {
        return this.masterCategories;
    }

    /**
     * Set the masterCategories property: A list of categories defined for the user.
     *
     * @param masterCategories the masterCategories value to set.
     * @return the MicrosoftGraphOutlookUserInner object itself.
     */
    public MicrosoftGraphOutlookUserInner withMasterCategories(
        List<MicrosoftGraphOutlookCategoryInner> masterCategories) {
        this.masterCategories = masterCategories;
        return this;
    }

    /**
     * Get the additionalProperties property: outlookUser.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: outlookUser.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOutlookUserInner object itself.
     */
    public MicrosoftGraphOutlookUserInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOutlookUserInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (masterCategories() != null) {
            masterCategories().forEach(e -> e.validate());
        }
    }
}
