// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for MicrosoftGraphPermissionClassificationType. */
public final class MicrosoftGraphPermissionClassificationType
    extends ExpandableStringEnum<MicrosoftGraphPermissionClassificationType> {
    /** Static value low for MicrosoftGraphPermissionClassificationType. */
    public static final MicrosoftGraphPermissionClassificationType LOW = fromString("low");

    /** Static value medium for MicrosoftGraphPermissionClassificationType. */
    public static final MicrosoftGraphPermissionClassificationType MEDIUM = fromString("medium");

    /** Static value high for MicrosoftGraphPermissionClassificationType. */
    public static final MicrosoftGraphPermissionClassificationType HIGH = fromString("high");

    /** Static value unknownFutureValue for MicrosoftGraphPermissionClassificationType. */
    public static final MicrosoftGraphPermissionClassificationType UNKNOWN_FUTURE_VALUE =
        fromString("unknownFutureValue");

    /**
     * Creates or finds a MicrosoftGraphPermissionClassificationType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MicrosoftGraphPermissionClassificationType.
     */
    @JsonCreator
    public static MicrosoftGraphPermissionClassificationType fromString(String name) {
        return fromString(name, MicrosoftGraphPermissionClassificationType.class);
    }

    /** @return known MicrosoftGraphPermissionClassificationType values. */
    public static Collection<MicrosoftGraphPermissionClassificationType> values() {
        return values(MicrosoftGraphPermissionClassificationType.class);
    }
}
