// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** phone. */
@Fluent
public final class MicrosoftGraphPhone {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphPhone.class);

    /*
     * The language property.
     */
    @JsonProperty(value = "language")
    private String language;

    /*
     * The phone number.
     */
    @JsonProperty(value = "number")
    private String number;

    /*
     * The region property.
     */
    @JsonProperty(value = "region")
    private String region;

    /*
     * The type property.
     */
    @JsonProperty(value = "type")
    private MicrosoftGraphPhoneType type;

    /*
     * phone
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the language property: The language property.
     *
     * @return the language value.
     */
    public String language() {
        return this.language;
    }

    /**
     * Set the language property: The language property.
     *
     * @param language the language value to set.
     * @return the MicrosoftGraphPhone object itself.
     */
    public MicrosoftGraphPhone withLanguage(String language) {
        this.language = language;
        return this;
    }

    /**
     * Get the number property: The phone number.
     *
     * @return the number value.
     */
    public String number() {
        return this.number;
    }

    /**
     * Set the number property: The phone number.
     *
     * @param number the number value to set.
     * @return the MicrosoftGraphPhone object itself.
     */
    public MicrosoftGraphPhone withNumber(String number) {
        this.number = number;
        return this;
    }

    /**
     * Get the region property: The region property.
     *
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Set the region property: The region property.
     *
     * @param region the region value to set.
     * @return the MicrosoftGraphPhone object itself.
     */
    public MicrosoftGraphPhone withRegion(String region) {
        this.region = region;
        return this;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    public MicrosoftGraphPhoneType type() {
        return this.type;
    }

    /**
     * Set the type property: The type property.
     *
     * @param type the type value to set.
     * @return the MicrosoftGraphPhone object itself.
     */
    public MicrosoftGraphPhone withType(MicrosoftGraphPhoneType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: phone.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: phone.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPhone object itself.
     */
    public MicrosoftGraphPhone withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
