// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** privacyProfile. */
@Fluent
public final class MicrosoftGraphPrivacyProfile {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphPrivacyProfile.class);

    /*
     * A valid smtp email address for the privacy statement contact. Not
     * required.
     */
    @JsonProperty(value = "contactEmail")
    private String contactEmail;

    /*
     * A valid URL format that begins with http:// or https://. Maximum length
     * is 255 characters. The URL that directs to the company's privacy
     * statement. Not required.
     */
    @JsonProperty(value = "statementUrl")
    private String statementUrl;

    /*
     * privacyProfile
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the contactEmail property: A valid smtp email address for the privacy statement contact. Not required.
     *
     * @return the contactEmail value.
     */
    public String contactEmail() {
        return this.contactEmail;
    }

    /**
     * Set the contactEmail property: A valid smtp email address for the privacy statement contact. Not required.
     *
     * @param contactEmail the contactEmail value to set.
     * @return the MicrosoftGraphPrivacyProfile object itself.
     */
    public MicrosoftGraphPrivacyProfile withContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
        return this;
    }

    /**
     * Get the statementUrl property: A valid URL format that begins with http:// or https://. Maximum length is 255
     * characters. The URL that directs to the company's privacy statement. Not required.
     *
     * @return the statementUrl value.
     */
    public String statementUrl() {
        return this.statementUrl;
    }

    /**
     * Set the statementUrl property: A valid URL format that begins with http:// or https://. Maximum length is 255
     * characters. The URL that directs to the company's privacy statement. Not required.
     *
     * @param statementUrl the statementUrl value to set.
     * @return the MicrosoftGraphPrivacyProfile object itself.
     */
    public MicrosoftGraphPrivacyProfile withStatementUrl(String statementUrl) {
        this.statementUrl = statementUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: privacyProfile.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: privacyProfile.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPrivacyProfile object itself.
     */
    public MicrosoftGraphPrivacyProfile withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
