// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** remoteItem. */
@Fluent
public final class MicrosoftGraphRemoteItem {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphRemoteItem.class);

    /*
     * identitySet
     */
    @JsonProperty(value = "createdBy")
    private MicrosoftGraphIdentitySet createdBy;

    /*
     * Date and time of item creation. Read-only.
     */
    @JsonProperty(value = "createdDateTime")
    private OffsetDateTime createdDateTime;

    /*
     * file
     */
    @JsonProperty(value = "file")
    private MicrosoftGraphFile file;

    /*
     * fileSystemInfo
     */
    @JsonProperty(value = "fileSystemInfo")
    private MicrosoftGraphFileSystemInfo fileSystemInfo;

    /*
     * folder
     */
    @JsonProperty(value = "folder")
    private MicrosoftGraphFolder folder;

    /*
     * Unique identifier for the remote item in its drive. Read-only.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * image
     */
    @JsonProperty(value = "image")
    private MicrosoftGraphImage image;

    /*
     * identitySet
     */
    @JsonProperty(value = "lastModifiedBy")
    private MicrosoftGraphIdentitySet lastModifiedBy;

    /*
     * Date and time the item was last modified. Read-only.
     */
    @JsonProperty(value = "lastModifiedDateTime")
    private OffsetDateTime lastModifiedDateTime;

    /*
     * Optional. Filename of the remote item. Read-only.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * package
     */
    @JsonProperty(value = "package")
    private MicrosoftGraphPackage packageProperty;

    /*
     * itemReference
     */
    @JsonProperty(value = "parentReference")
    private MicrosoftGraphItemReference parentReference;

    /*
     * shared
     */
    @JsonProperty(value = "shared")
    private MicrosoftGraphShared shared;

    /*
     * sharepointIds
     */
    @JsonProperty(value = "sharepointIds")
    private MicrosoftGraphSharepointIds sharepointIds;

    /*
     * Size of the remote item. Read-only.
     */
    @JsonProperty(value = "size")
    private Long size;

    /*
     * specialFolder
     */
    @JsonProperty(value = "specialFolder")
    private MicrosoftGraphSpecialFolder specialFolder;

    /*
     * video
     */
    @JsonProperty(value = "video")
    private MicrosoftGraphVideo video;

    /*
     * DAV compatible URL for the item.
     */
    @JsonProperty(value = "webDavUrl")
    private String webDavUrl;

    /*
     * URL that displays the resource in the browser. Read-only.
     */
    @JsonProperty(value = "webUrl")
    private String webUrl;

    /*
     * remoteItem
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the createdBy property: identitySet.
     *
     * @return the createdBy value.
     */
    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    /**
     * Set the createdBy property: identitySet.
     *
     * @param createdBy the createdBy value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the createdDateTime property: Date and time of item creation. Read-only.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Date and time of item creation. Read-only.
     *
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the file property: file.
     *
     * @return the file value.
     */
    public MicrosoftGraphFile file() {
        return this.file;
    }

    /**
     * Set the file property: file.
     *
     * @param file the file value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withFile(MicrosoftGraphFile file) {
        this.file = file;
        return this;
    }

    /**
     * Get the fileSystemInfo property: fileSystemInfo.
     *
     * @return the fileSystemInfo value.
     */
    public MicrosoftGraphFileSystemInfo fileSystemInfo() {
        return this.fileSystemInfo;
    }

    /**
     * Set the fileSystemInfo property: fileSystemInfo.
     *
     * @param fileSystemInfo the fileSystemInfo value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withFileSystemInfo(MicrosoftGraphFileSystemInfo fileSystemInfo) {
        this.fileSystemInfo = fileSystemInfo;
        return this;
    }

    /**
     * Get the folder property: folder.
     *
     * @return the folder value.
     */
    public MicrosoftGraphFolder folder() {
        return this.folder;
    }

    /**
     * Set the folder property: folder.
     *
     * @param folder the folder value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withFolder(MicrosoftGraphFolder folder) {
        this.folder = folder;
        return this;
    }

    /**
     * Get the id property: Unique identifier for the remote item in its drive. Read-only.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Unique identifier for the remote item in its drive. Read-only.
     *
     * @param id the id value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the image property: image.
     *
     * @return the image value.
     */
    public MicrosoftGraphImage image() {
        return this.image;
    }

    /**
     * Set the image property: image.
     *
     * @param image the image value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withImage(MicrosoftGraphImage image) {
        this.image = image;
        return this;
    }

    /**
     * Get the lastModifiedBy property: identitySet.
     *
     * @return the lastModifiedBy value.
     */
    public MicrosoftGraphIdentitySet lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Set the lastModifiedBy property: identitySet.
     *
     * @param lastModifiedBy the lastModifiedBy value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    /**
     * Get the lastModifiedDateTime property: Date and time the item was last modified. Read-only.
     *
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: Date and time the item was last modified. Read-only.
     *
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the name property: Optional. Filename of the remote item. Read-only.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Optional. Filename of the remote item. Read-only.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the packageProperty property: package.
     *
     * @return the packageProperty value.
     */
    public MicrosoftGraphPackage packageProperty() {
        return this.packageProperty;
    }

    /**
     * Set the packageProperty property: package.
     *
     * @param packageProperty the packageProperty value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withPackageProperty(MicrosoftGraphPackage packageProperty) {
        this.packageProperty = packageProperty;
        return this;
    }

    /**
     * Get the parentReference property: itemReference.
     *
     * @return the parentReference value.
     */
    public MicrosoftGraphItemReference parentReference() {
        return this.parentReference;
    }

    /**
     * Set the parentReference property: itemReference.
     *
     * @param parentReference the parentReference value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withParentReference(MicrosoftGraphItemReference parentReference) {
        this.parentReference = parentReference;
        return this;
    }

    /**
     * Get the shared property: shared.
     *
     * @return the shared value.
     */
    public MicrosoftGraphShared shared() {
        return this.shared;
    }

    /**
     * Set the shared property: shared.
     *
     * @param shared the shared value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withShared(MicrosoftGraphShared shared) {
        this.shared = shared;
        return this;
    }

    /**
     * Get the sharepointIds property: sharepointIds.
     *
     * @return the sharepointIds value.
     */
    public MicrosoftGraphSharepointIds sharepointIds() {
        return this.sharepointIds;
    }

    /**
     * Set the sharepointIds property: sharepointIds.
     *
     * @param sharepointIds the sharepointIds value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withSharepointIds(MicrosoftGraphSharepointIds sharepointIds) {
        this.sharepointIds = sharepointIds;
        return this;
    }

    /**
     * Get the size property: Size of the remote item. Read-only.
     *
     * @return the size value.
     */
    public Long size() {
        return this.size;
    }

    /**
     * Set the size property: Size of the remote item. Read-only.
     *
     * @param size the size value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withSize(Long size) {
        this.size = size;
        return this;
    }

    /**
     * Get the specialFolder property: specialFolder.
     *
     * @return the specialFolder value.
     */
    public MicrosoftGraphSpecialFolder specialFolder() {
        return this.specialFolder;
    }

    /**
     * Set the specialFolder property: specialFolder.
     *
     * @param specialFolder the specialFolder value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withSpecialFolder(MicrosoftGraphSpecialFolder specialFolder) {
        this.specialFolder = specialFolder;
        return this;
    }

    /**
     * Get the video property: video.
     *
     * @return the video value.
     */
    public MicrosoftGraphVideo video() {
        return this.video;
    }

    /**
     * Set the video property: video.
     *
     * @param video the video value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withVideo(MicrosoftGraphVideo video) {
        this.video = video;
        return this;
    }

    /**
     * Get the webDavUrl property: DAV compatible URL for the item.
     *
     * @return the webDavUrl value.
     */
    public String webDavUrl() {
        return this.webDavUrl;
    }

    /**
     * Set the webDavUrl property: DAV compatible URL for the item.
     *
     * @param webDavUrl the webDavUrl value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withWebDavUrl(String webDavUrl) {
        this.webDavUrl = webDavUrl;
        return this;
    }

    /**
     * Get the webUrl property: URL that displays the resource in the browser. Read-only.
     *
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: URL that displays the resource in the browser. Read-only.
     *
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: remoteItem.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: remoteItem.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (createdBy() != null) {
            createdBy().validate();
        }
        if (file() != null) {
            file().validate();
        }
        if (fileSystemInfo() != null) {
            fileSystemInfo().validate();
        }
        if (folder() != null) {
            folder().validate();
        }
        if (image() != null) {
            image().validate();
        }
        if (lastModifiedBy() != null) {
            lastModifiedBy().validate();
        }
        if (packageProperty() != null) {
            packageProperty().validate();
        }
        if (parentReference() != null) {
            parentReference().validate();
        }
        if (shared() != null) {
            shared().validate();
        }
        if (sharepointIds() != null) {
            sharepointIds().validate();
        }
        if (specialFolder() != null) {
            specialFolder().validate();
        }
        if (video() != null) {
            video().validate();
        }
    }
}
