// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** resourceReference. */
@Fluent
public final class MicrosoftGraphResourceReference {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphResourceReference.class);

    /*
     * The item's unique identifier.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * A string value that can be used to classify the item, such as
     * 'microsoft.graph.driveItem'
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * A URL leading to the referenced item.
     */
    @JsonProperty(value = "webUrl")
    private String webUrl;

    /*
     * resourceReference
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the id property: The item's unique identifier.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The item's unique identifier.
     *
     * @param id the id value to set.
     * @return the MicrosoftGraphResourceReference object itself.
     */
    public MicrosoftGraphResourceReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: A string value that can be used to classify the item, such as 'microsoft.graph.driveItem'.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: A string value that can be used to classify the item, such as 'microsoft.graph.driveItem'.
     *
     * @param type the type value to set.
     * @return the MicrosoftGraphResourceReference object itself.
     */
    public MicrosoftGraphResourceReference withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the webUrl property: A URL leading to the referenced item.
     *
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: A URL leading to the referenced item.
     *
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphResourceReference object itself.
     */
    public MicrosoftGraphResourceReference withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: resourceReference.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: resourceReference.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphResourceReference object itself.
     */
    public MicrosoftGraphResourceReference withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
