// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookNamedItem. */
@Fluent
public final class MicrosoftGraphWorkbookNamedItem extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphWorkbookNamedItem.class);

    /*
     * Represents the comment associated with this name.
     */
    @JsonProperty(value = "comment")
    private String comment;

    /*
     * The name of the object. Read-only.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Indicates whether the name is scoped to the workbook or to a specific
     * worksheet. Read-only.
     */
    @JsonProperty(value = "scope")
    private String scope;

    /*
     * Indicates what type of reference is associated with the name. The
     * possible values are: String, Integer, Double, Boolean, Range. Read-only.
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * Json
     */
    @JsonProperty(value = "value")
    private Map<String, Object> value;

    /*
     * Specifies whether the object is visible or not.
     */
    @JsonProperty(value = "visible")
    private Boolean visible;

    /*
     * workbookWorksheet
     */
    @JsonProperty(value = "worksheet")
    private MicrosoftGraphWorkbookWorksheet worksheet;

    /*
     * workbookNamedItem
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the comment property: Represents the comment associated with this name.
     *
     * @return the comment value.
     */
    public String comment() {
        return this.comment;
    }

    /**
     * Set the comment property: Represents the comment associated with this name.
     *
     * @param comment the comment value to set.
     * @return the MicrosoftGraphWorkbookNamedItem object itself.
     */
    public MicrosoftGraphWorkbookNamedItem withComment(String comment) {
        this.comment = comment;
        return this;
    }

    /**
     * Get the name property: The name of the object. Read-only.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the object. Read-only.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookNamedItem object itself.
     */
    public MicrosoftGraphWorkbookNamedItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the scope property: Indicates whether the name is scoped to the workbook or to a specific worksheet.
     * Read-only.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: Indicates whether the name is scoped to the workbook or to a specific worksheet.
     * Read-only.
     *
     * @param scope the scope value to set.
     * @return the MicrosoftGraphWorkbookNamedItem object itself.
     */
    public MicrosoftGraphWorkbookNamedItem withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the type property: Indicates what type of reference is associated with the name. The possible values are:
     * String, Integer, Double, Boolean, Range. Read-only.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Indicates what type of reference is associated with the name. The possible values are:
     * String, Integer, Double, Boolean, Range. Read-only.
     *
     * @param type the type value to set.
     * @return the MicrosoftGraphWorkbookNamedItem object itself.
     */
    public MicrosoftGraphWorkbookNamedItem withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the value property: Json.
     *
     * @return the value value.
     */
    public Map<String, Object> value() {
        return this.value;
    }

    /**
     * Set the value property: Json.
     *
     * @param value the value value to set.
     * @return the MicrosoftGraphWorkbookNamedItem object itself.
     */
    public MicrosoftGraphWorkbookNamedItem withValue(Map<String, Object> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the visible property: Specifies whether the object is visible or not.
     *
     * @return the visible value.
     */
    public Boolean visible() {
        return this.visible;
    }

    /**
     * Set the visible property: Specifies whether the object is visible or not.
     *
     * @param visible the visible value to set.
     * @return the MicrosoftGraphWorkbookNamedItem object itself.
     */
    public MicrosoftGraphWorkbookNamedItem withVisible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    /**
     * Get the worksheet property: workbookWorksheet.
     *
     * @return the worksheet value.
     */
    public MicrosoftGraphWorkbookWorksheet worksheet() {
        return this.worksheet;
    }

    /**
     * Set the worksheet property: workbookWorksheet.
     *
     * @param worksheet the worksheet value to set.
     * @return the MicrosoftGraphWorkbookNamedItem object itself.
     */
    public MicrosoftGraphWorkbookNamedItem withWorksheet(MicrosoftGraphWorkbookWorksheet worksheet) {
        this.worksheet = worksheet;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookNamedItem.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookNamedItem.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookNamedItem object itself.
     */
    public MicrosoftGraphWorkbookNamedItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookNamedItem withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (worksheet() != null) {
            worksheet().validate();
        }
    }
}
