// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookWorksheetProtection. */
@Fluent
public final class MicrosoftGraphWorkbookWorksheetProtection extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphWorkbookWorksheetProtection.class);

    /*
     * workbookWorksheetProtectionOptions
     */
    @JsonProperty(value = "options")
    private MicrosoftGraphWorkbookWorksheetProtectionOptions options;

    /*
     * Indicates if the worksheet is protected.  Read-only.
     */
    @JsonProperty(value = "protected")
    private Boolean protectedProperty;

    /*
     * workbookWorksheetProtection
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the options property: workbookWorksheetProtectionOptions.
     *
     * @return the options value.
     */
    public MicrosoftGraphWorkbookWorksheetProtectionOptions options() {
        return this.options;
    }

    /**
     * Set the options property: workbookWorksheetProtectionOptions.
     *
     * @param options the options value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtection object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtection withOptions(
        MicrosoftGraphWorkbookWorksheetProtectionOptions options) {
        this.options = options;
        return this;
    }

    /**
     * Get the protectedProperty property: Indicates if the worksheet is protected. Read-only.
     *
     * @return the protectedProperty value.
     */
    public Boolean protectedProperty() {
        return this.protectedProperty;
    }

    /**
     * Set the protectedProperty property: Indicates if the worksheet is protected. Read-only.
     *
     * @param protectedProperty the protectedProperty value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtection object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtection withProtectedProperty(Boolean protectedProperty) {
        this.protectedProperty = protectedProperty;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookWorksheetProtection.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookWorksheetProtection.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookWorksheetProtection object itself.
     */
    public MicrosoftGraphWorkbookWorksheetProtection withAdditionalProperties(
        Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookWorksheetProtection withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (options() != null) {
            options().validate();
        }
    }
}
