// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for UsersTodoExpand. */
public final class UsersTodoExpand extends ExpandableStringEnum<UsersTodoExpand> {
    /** Static value * for UsersTodoExpand. */
    public static final UsersTodoExpand ASTERISK = fromString("*");

    /** Static value extensions for UsersTodoExpand. */
    public static final UsersTodoExpand EXTENSIONS = fromString("extensions");

    /** Static value tasks for UsersTodoExpand. */
    public static final UsersTodoExpand TASKS = fromString("tasks");

    /**
     * Creates or finds a UsersTodoExpand from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding UsersTodoExpand.
     */
    @JsonCreator
    public static UsersTodoExpand fromString(String name) {
        return fromString(name, UsersTodoExpand.class);
    }

    /** @return known UsersTodoExpand values. */
    public static Collection<UsersTodoExpand> values() {
        return values(UsersTodoExpand.class);
    }
}
