// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.ContactsOrgContactsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfOrgContact;
import com.azure.resourcemanager.authorization.fluent.models.Get2ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get3ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get6ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get7ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get8ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOrgContactInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ContactsOrgContactsClient. */
public final class ContactsOrgContactsClientImpl implements ContactsOrgContactsClient {
    private final ClientLogger logger = new ClientLogger(ContactsOrgContactsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final ContactsOrgContactsService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of ContactsOrgContactsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ContactsOrgContactsClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy.create(ContactsOrgContactsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientContactsOrgContacts to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface ContactsOrgContactsService {
        @Headers({"Content-Type: application/json"})
        @Get("/contacts")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfOrgContact>> listOrgContact(
            @HostParam("$host") String endpoint,
            @HeaderParam("ConsistencyLevel") String consistencyLevel,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphOrgContactInner>> createOrgContact(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") MicrosoftGraphOrgContactInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/contacts/{orgContact-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphOrgContactInner>> getOrgContact(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @HeaderParam("ConsistencyLevel") String consistencyLevel,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/contacts/{orgContact-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateOrgContact(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @BodyParam("application/json") MicrosoftGraphOrgContactInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/contacts/{orgContact-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteOrgContact(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfOrgContact>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get entities from contacts.
     *
     * @param consistencyLevel Indicates the requested consistency level.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrgContactInner>> listOrgContactSinglePageAsync(
        String consistencyLevel,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<Get6ItemsItem> orderby,
        List<Get7ItemsItem> select,
        List<Get8ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listOrgContact(
                            this.client.getEndpoint(),
                            consistencyLevel,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphOrgContactInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entities from contacts.
     *
     * @param consistencyLevel Indicates the requested consistency level.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrgContactInner>> listOrgContactSinglePageAsync(
        String consistencyLevel,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<Get6ItemsItem> orderby,
        List<Get7ItemsItem> select,
        List<Get8ItemsItem> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listOrgContact(
                this.client.getEndpoint(),
                consistencyLevel,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get entities from contacts.
     *
     * @param consistencyLevel Indicates the requested consistency level.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOrgContactInner> listOrgContactAsync(
        String consistencyLevel,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<Get6ItemsItem> orderby,
        List<Get7ItemsItem> select,
        List<Get8ItemsItem> expand) {
        return new PagedFlux<>(
            () ->
                listOrgContactSinglePageAsync(
                    consistencyLevel, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from contacts.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOrgContactInner> listOrgContactAsync() {
        final String consistencyLevel = null;
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<Get6ItemsItem> orderby = null;
        final List<Get7ItemsItem> select = null;
        final List<Get8ItemsItem> expand = null;
        return new PagedFlux<>(
            () ->
                listOrgContactSinglePageAsync(
                    consistencyLevel, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from contacts.
     *
     * @param consistencyLevel Indicates the requested consistency level.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphOrgContactInner> listOrgContactAsync(
        String consistencyLevel,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<Get6ItemsItem> orderby,
        List<Get7ItemsItem> select,
        List<Get8ItemsItem> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listOrgContactSinglePageAsync(
                    consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get entities from contacts.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOrgContactInner> listOrgContact() {
        final String consistencyLevel = null;
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<Get6ItemsItem> orderby = null;
        final List<Get7ItemsItem> select = null;
        final List<Get8ItemsItem> expand = null;
        return new PagedIterable<>(
            listOrgContactAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get entities from contacts.
     *
     * @param consistencyLevel Indicates the requested consistency level.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOrgContactInner> listOrgContact(
        String consistencyLevel,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<Get6ItemsItem> orderby,
        List<Get7ItemsItem> select,
        List<Get8ItemsItem> expand,
        Context context) {
        return new PagedIterable<>(
            listOrgContactAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Add new entity to contacts.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOrgContactInner>> createOrgContactWithResponseAsync(
        MicrosoftGraphOrgContactInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrgContact(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Add new entity to contacts.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOrgContactInner>> createOrgContactWithResponseAsync(
        MicrosoftGraphOrgContactInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrgContact(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Add new entity to contacts.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrgContactInner> createOrgContactAsync(MicrosoftGraphOrgContactInner body) {
        return createOrgContactWithResponseAsync(body)
            .flatMap(
                (Response<MicrosoftGraphOrgContactInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Add new entity to contacts.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphOrgContactInner createOrgContact(MicrosoftGraphOrgContactInner body) {
        return createOrgContactAsync(body).block();
    }

    /**
     * Add new entity to contacts.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphOrgContactInner> createOrgContactWithResponse(
        MicrosoftGraphOrgContactInner body, Context context) {
        return createOrgContactWithResponseAsync(body, context).block();
    }

    /**
     * Get entity from contacts by key.
     *
     * @param orgContactId key: id of orgContact.
     * @param consistencyLevel Indicates the requested consistency level.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from contacts by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOrgContactInner>> getOrgContactWithResponseAsync(
        String orgContactId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getOrgContact(
                            this.client.getEndpoint(),
                            orgContactId,
                            consistencyLevel,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entity from contacts by key.
     *
     * @param orgContactId key: id of orgContact.
     * @param consistencyLevel Indicates the requested consistency level.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from contacts by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOrgContactInner>> getOrgContactWithResponseAsync(
        String orgContactId,
        String consistencyLevel,
        List<Get2ItemsItem> select,
        List<Get3ItemsItem> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getOrgContact(
                this.client.getEndpoint(),
                orgContactId,
                consistencyLevel,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get entity from contacts by key.
     *
     * @param orgContactId key: id of orgContact.
     * @param consistencyLevel Indicates the requested consistency level.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from contacts by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrgContactInner> getOrgContactAsync(
        String orgContactId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand) {
        return getOrgContactWithResponseAsync(orgContactId, consistencyLevel, select, expand)
            .flatMap(
                (Response<MicrosoftGraphOrgContactInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from contacts by key.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from contacts by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrgContactInner> getOrgContactAsync(String orgContactId) {
        final String consistencyLevel = null;
        final List<Get2ItemsItem> select = null;
        final List<Get3ItemsItem> expand = null;
        return getOrgContactWithResponseAsync(orgContactId, consistencyLevel, select, expand)
            .flatMap(
                (Response<MicrosoftGraphOrgContactInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from contacts by key.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from contacts by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphOrgContactInner getOrgContact(String orgContactId) {
        final String consistencyLevel = null;
        final List<Get2ItemsItem> select = null;
        final List<Get3ItemsItem> expand = null;
        return getOrgContactAsync(orgContactId, consistencyLevel, select, expand).block();
    }

    /**
     * Get entity from contacts by key.
     *
     * @param orgContactId key: id of orgContact.
     * @param consistencyLevel Indicates the requested consistency level.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from contacts by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphOrgContactInner> getOrgContactWithResponse(
        String orgContactId,
        String consistencyLevel,
        List<Get2ItemsItem> select,
        List<Get3ItemsItem> expand,
        Context context) {
        return getOrgContactWithResponseAsync(orgContactId, consistencyLevel, select, expand, context).block();
    }

    /**
     * Update entity in contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateOrgContactWithResponseAsync(
        String orgContactId, MicrosoftGraphOrgContactInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.updateOrgContact(this.client.getEndpoint(), orgContactId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update entity in contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateOrgContactWithResponseAsync(
        String orgContactId, MicrosoftGraphOrgContactInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateOrgContact(this.client.getEndpoint(), orgContactId, body, accept, context);
    }

    /**
     * Update entity in contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateOrgContactAsync(String orgContactId, MicrosoftGraphOrgContactInner body) {
        return updateOrgContactWithResponseAsync(orgContactId, body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update entity in contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateOrgContact(String orgContactId, MicrosoftGraphOrgContactInner body) {
        updateOrgContactAsync(orgContactId, body).block();
    }

    /**
     * Update entity in contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateOrgContactWithResponse(
        String orgContactId, MicrosoftGraphOrgContactInner body, Context context) {
        return updateOrgContactWithResponseAsync(orgContactId, body, context).block();
    }

    /**
     * Delete entity from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteOrgContactWithResponseAsync(String orgContactId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.deleteOrgContact(this.client.getEndpoint(), orgContactId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete entity from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteOrgContactWithResponseAsync(
        String orgContactId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteOrgContact(this.client.getEndpoint(), orgContactId, ifMatch, accept, context);
    }

    /**
     * Delete entity from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteOrgContactAsync(String orgContactId, String ifMatch) {
        return deleteOrgContactWithResponseAsync(orgContactId, ifMatch).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteOrgContactAsync(String orgContactId) {
        final String ifMatch = null;
        return deleteOrgContactWithResponseAsync(orgContactId, ifMatch).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteOrgContact(String orgContactId) {
        final String ifMatch = null;
        deleteOrgContactAsync(orgContactId, ifMatch).block();
    }

    /**
     * Delete entity from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteOrgContactWithResponse(String orgContactId, String ifMatch, Context context) {
        return deleteOrgContactWithResponseAsync(orgContactId, ifMatch, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of orgContact.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrgContactInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphOrgContactInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of orgContact.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrgContactInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
