// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.DirectoryAdministrativeUnitsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject6;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtension0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject6;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfScopedRoleMembership;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryAdministrativeUnitsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryAdministrativeUnitsSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAdministrativeUnitInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScopedRoleMembershipInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DirectoryAdministrativeUnitsClient. */
public final class DirectoryAdministrativeUnitsClientImpl implements DirectoryAdministrativeUnitsClient {
    private final ClientLogger logger = new ClientLogger(DirectoryAdministrativeUnitsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final DirectoryAdministrativeUnitsService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of DirectoryAdministrativeUnitsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DirectoryAdministrativeUnitsClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy
                .create(
                    DirectoryAdministrativeUnitsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientDirectoryAdministrativeUnits to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface DirectoryAdministrativeUnitsService {
        @Headers({"Content-Type: application/json"})
        @Get("/directory/administrativeUnits/{administrativeUnit-id}/extensions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfExtension0>> listExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/directory/administrativeUnits/{administrativeUnit-id}/extensions")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphExtensionInner>> createExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @BodyParam("application/json") MicrosoftGraphExtensionInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/directory/administrativeUnits/{administrativeUnit-id}/extensions/{extension-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphExtensionInner>> getExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @PathParam("extension-id") String extensionId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/directory/administrativeUnits/{administrativeUnit-id}/extensions/{extension-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @PathParam("extension-id") String extensionId,
            @BodyParam("application/json") MicrosoftGraphExtensionInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/directory/administrativeUnits/{administrativeUnit-id}/extensions/{extension-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @PathParam("extension-id") String extensionId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/directory/administrativeUnits/{administrativeUnit-id}/members")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject6>> listMembers(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/directory/administrativeUnits/{administrativeUnit-id}/members/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject6>> listRefMembers(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/directory/administrativeUnits/{administrativeUnit-id}/members/$ref")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefMembers(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/directory/administrativeUnits/{administrativeUnit-id}/scopedRoleMembers")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfScopedRoleMembership>> listScopedRoleMembers(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/directory/administrativeUnits/{administrativeUnit-id}/scopedRoleMembers")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedRoleMembers(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @BodyParam("application/json") MicrosoftGraphScopedRoleMembershipInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/directory/administrativeUnits/{administrativeUnit-id}/scopedRoleMembers/{scopedRoleMembership-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedRoleMembers(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @PathParam("scopedRoleMembership-id") String scopedRoleMembershipId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/directory/administrativeUnits/{administrativeUnit-id}/scopedRoleMembers/{scopedRoleMembership-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateScopedRoleMembers(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @PathParam("scopedRoleMembership-id") String scopedRoleMembershipId,
            @BodyParam("application/json") MicrosoftGraphScopedRoleMembershipInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/directory/administrativeUnits/{administrativeUnit-id}/scopedRoleMembers/{scopedRoleMembership-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteScopedRoleMembers(
            @HostParam("$host") String endpoint,
            @PathParam("administrativeUnit-id") String administrativeUnitId,
            @PathParam("scopedRoleMembership-id") String scopedRoleMembershipId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/directory/administrativeUnits/microsoft.graph.delta()")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<MicrosoftGraphAdministrativeUnitInner>>> delta(
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfExtension0>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject6>> listMembersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject6>> listRefMembersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfScopedRoleMembership>> listScopedRoleMembersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<String> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listExtensions(
                            this.client.getEndpoint(),
                            administrativeUnitId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphExtensionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listExtensions(
                this.client.getEndpoint(),
                administrativeUnitId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<String> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listExtensionsSinglePageAsync(
                    administrativeUnitId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String administrativeUnitId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        final List<String> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listExtensionsSinglePageAsync(
                    administrativeUnitId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listExtensionsSinglePageAsync(
                    administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String administrativeUnitId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        final List<String> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listExtensionsAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listExtensionsAsync(
                administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(
        String administrativeUnitId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.createExtensions(this.client.getEndpoint(), administrativeUnitId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(
        String administrativeUnitId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createExtensions(this.client.getEndpoint(), administrativeUnitId, body, accept, context);
    }

    /**
     * Create new navigation property to extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(
        String administrativeUnitId, MicrosoftGraphExtensionInner body) {
        return createExtensionsWithResponseAsync(administrativeUnitId, body)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner createExtensions(
        String administrativeUnitId, MicrosoftGraphExtensionInner body) {
        return createExtensionsAsync(administrativeUnitId, body).block();
    }

    /**
     * Create new navigation property to extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(
        String administrativeUnitId, MicrosoftGraphExtensionInner body, Context context) {
        return createExtensionsWithResponseAsync(administrativeUnitId, body, context).block();
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(
        String administrativeUnitId, String extensionId, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getExtensions(
                            this.client.getEndpoint(),
                            administrativeUnitId,
                            extensionId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(
        String administrativeUnitId, String extensionId, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getExtensions(
                this.client.getEndpoint(),
                administrativeUnitId,
                extensionId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(
        String administrativeUnitId, String extensionId, List<String> select, List<String> expand) {
        return getExtensionsWithResponseAsync(administrativeUnitId, extensionId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String administrativeUnitId, String extensionId) {
        final List<String> select = null;
        final List<String> expand = null;
        return getExtensionsWithResponseAsync(administrativeUnitId, extensionId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner getExtensions(String administrativeUnitId, String extensionId) {
        final List<String> select = null;
        final List<String> expand = null;
        return getExtensionsAsync(administrativeUnitId, extensionId, select, expand).block();
    }

    /**
     * Get extensions from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(
        String administrativeUnitId, String extensionId, List<String> select, List<String> expand, Context context) {
        return getExtensionsWithResponseAsync(administrativeUnitId, extensionId, select, expand, context).block();
    }

    /**
     * Update the navigation property extensions in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateExtensionsWithResponseAsync(
        String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateExtensions(
                            this.client.getEndpoint(), administrativeUnitId, extensionId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property extensions in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateExtensionsWithResponseAsync(
        String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateExtensions(this.client.getEndpoint(), administrativeUnitId, extensionId, body, accept, context);
    }

    /**
     * Update the navigation property extensions in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateExtensionsAsync(
        String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body) {
        return updateExtensionsWithResponseAsync(administrativeUnitId, extensionId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property extensions in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateExtensions(String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body) {
        updateExtensionsAsync(administrativeUnitId, extensionId, body).block();
    }

    /**
     * Update the navigation property extensions in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateExtensionsWithResponse(
        String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        return updateExtensionsWithResponseAsync(administrativeUnitId, extensionId, body, context).block();
    }

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteExtensionsWithResponseAsync(
        String administrativeUnitId, String extensionId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteExtensions(
                            this.client.getEndpoint(), administrativeUnitId, extensionId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteExtensionsWithResponseAsync(
        String administrativeUnitId, String extensionId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteExtensions(this.client.getEndpoint(), administrativeUnitId, extensionId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(String administrativeUnitId, String extensionId, String ifMatch) {
        return deleteExtensionsWithResponseAsync(administrativeUnitId, extensionId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(String administrativeUnitId, String extensionId) {
        final String ifMatch = null;
        return deleteExtensionsWithResponseAsync(administrativeUnitId, extensionId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteExtensions(String administrativeUnitId, String extensionId) {
        final String ifMatch = null;
        deleteExtensionsAsync(administrativeUnitId, extensionId, ifMatch).block();
    }

    /**
     * Delete navigation property extensions for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteExtensionsWithResponse(
        String administrativeUnitId, String extensionId, String ifMatch, Context context) {
        return deleteExtensionsWithResponseAsync(administrativeUnitId, extensionId, ifMatch, context).block();
    }

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listMembers(
                            this.client.getEndpoint(),
                            administrativeUnitId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listMembers(
                this.client.getEndpoint(),
                administrativeUnitId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listMembersSinglePageAsync(
                    administrativeUnitId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String administrativeUnitId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        final List<DirectoryAdministrativeUnitsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listMembersSinglePageAsync(
                    administrativeUnitId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listMembersSinglePageAsync(
                    administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMembersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String administrativeUnitId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        final List<DirectoryAdministrativeUnitsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listMembersAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listMembersAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefMembers(
                            this.client.getEndpoint(),
                            administrativeUnitId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefMembers(
                this.client.getEndpoint(),
                administrativeUnitId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby),
            nextLink -> listRefMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersAsync(String administrativeUnitId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby),
            nextLink -> listRefMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefMembersAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () ->
                listRefMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefMembersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembers(String administrativeUnitId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        return new PagedIterable<>(
            listRefMembersAsync(administrativeUnitId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of members from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembers(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(
            listRefMembersAsync(administrativeUnitId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to members for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefMembersWithResponseAsync(
        String administrativeUnitId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.createRefMembers(this.client.getEndpoint(), administrativeUnitId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to members for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefMembersWithResponseAsync(
        String administrativeUnitId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefMembers(this.client.getEndpoint(), administrativeUnitId, body, accept, context);
    }

    /**
     * Create new navigation property ref to members for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefMembersAsync(String administrativeUnitId, Map<String, Object> body) {
        return createRefMembersWithResponseAsync(administrativeUnitId, body)
            .flatMap(
                (Response<Map<String, Object>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property ref to members for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefMembers(String administrativeUnitId, Map<String, Object> body) {
        return createRefMembersAsync(administrativeUnitId, body).block();
    }

    /**
     * Create new navigation property ref to members for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefMembersWithResponse(
        String administrativeUnitId, Map<String, Object> body, Context context) {
        return createRefMembersWithResponseAsync(administrativeUnitId, body, context).block();
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMembersSinglePageAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listScopedRoleMembers(
                            this.client.getEndpoint(),
                            administrativeUnitId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMembersSinglePageAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listScopedRoleMembers(
                this.client.getEndpoint(),
                administrativeUnitId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembersAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listScopedRoleMembersSinglePageAsync(
                    administrativeUnitId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listScopedRoleMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembersAsync(String administrativeUnitId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        final List<DirectoryAdministrativeUnitsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listScopedRoleMembersSinglePageAsync(
                    administrativeUnitId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listScopedRoleMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembersAsync(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listScopedRoleMembersSinglePageAsync(
                    administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listScopedRoleMembersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembers(String administrativeUnitId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        final List<DirectoryAdministrativeUnitsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listScopedRoleMembersAsync(
                administrativeUnitId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembers(
        String administrativeUnitId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryAdministrativeUnitsOrderby> orderby,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listScopedRoleMembersAsync(
                administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedRoleMembersWithResponseAsync(
        String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createScopedRoleMembers(
                            this.client.getEndpoint(), administrativeUnitId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedRoleMembersWithResponseAsync(
        String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, body, accept, context);
    }

    /**
     * Create new navigation property to scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphScopedRoleMembershipInner> createScopedRoleMembersAsync(
        String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body) {
        return createScopedRoleMembersWithResponseAsync(administrativeUnitId, body)
            .flatMap(
                (Response<MicrosoftGraphScopedRoleMembershipInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphScopedRoleMembershipInner createScopedRoleMembers(
        String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body) {
        return createScopedRoleMembersAsync(administrativeUnitId, body).block();
    }

    /**
     * Create new navigation property to scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphScopedRoleMembershipInner> createScopedRoleMembersWithResponse(
        String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        return createScopedRoleMembersWithResponseAsync(administrativeUnitId, body, context).block();
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedRoleMembersWithResponseAsync(
        String administrativeUnitId,
        String scopedRoleMembershipId,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getScopedRoleMembers(
                            this.client.getEndpoint(),
                            administrativeUnitId,
                            scopedRoleMembershipId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedRoleMembersWithResponseAsync(
        String administrativeUnitId,
        String scopedRoleMembershipId,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getScopedRoleMembers(
                this.client.getEndpoint(),
                administrativeUnitId,
                scopedRoleMembershipId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMembersAsync(
        String administrativeUnitId,
        String scopedRoleMembershipId,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand) {
        return getScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphScopedRoleMembershipInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMembersAsync(
        String administrativeUnitId, String scopedRoleMembershipId) {
        final List<DirectoryAdministrativeUnitsSelect> select = null;
        final List<String> expand = null;
        return getScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphScopedRoleMembershipInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphScopedRoleMembershipInner getScopedRoleMembers(
        String administrativeUnitId, String scopedRoleMembershipId) {
        final List<DirectoryAdministrativeUnitsSelect> select = null;
        final List<String> expand = null;
        return getScopedRoleMembersAsync(administrativeUnitId, scopedRoleMembershipId, select, expand).block();
    }

    /**
     * Get scopedRoleMembers from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembers from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMembersWithResponse(
        String administrativeUnitId,
        String scopedRoleMembershipId,
        List<DirectoryAdministrativeUnitsSelect> select,
        List<String> expand,
        Context context) {
        return getScopedRoleMembersWithResponseAsync(
                administrativeUnitId, scopedRoleMembershipId, select, expand, context)
            .block();
    }

    /**
     * Update the navigation property scopedRoleMembers in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateScopedRoleMembersWithResponseAsync(
        String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateScopedRoleMembers(
                            this.client.getEndpoint(),
                            administrativeUnitId,
                            scopedRoleMembershipId,
                            body,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property scopedRoleMembers in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateScopedRoleMembersWithResponseAsync(
        String administrativeUnitId,
        String scopedRoleMembershipId,
        MicrosoftGraphScopedRoleMembershipInner body,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateScopedRoleMembers(
                this.client.getEndpoint(), administrativeUnitId, scopedRoleMembershipId, body, accept, context);
    }

    /**
     * Update the navigation property scopedRoleMembers in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateScopedRoleMembersAsync(
        String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        return updateScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property scopedRoleMembers in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateScopedRoleMembers(
        String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        updateScopedRoleMembersAsync(administrativeUnitId, scopedRoleMembershipId, body).block();
    }

    /**
     * Update the navigation property scopedRoleMembers in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateScopedRoleMembersWithResponse(
        String administrativeUnitId,
        String scopedRoleMembershipId,
        MicrosoftGraphScopedRoleMembershipInner body,
        Context context) {
        return updateScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, body, context)
            .block();
    }

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteScopedRoleMembersWithResponseAsync(
        String administrativeUnitId, String scopedRoleMembershipId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteScopedRoleMembers(
                            this.client.getEndpoint(),
                            administrativeUnitId,
                            scopedRoleMembershipId,
                            ifMatch,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteScopedRoleMembersWithResponseAsync(
        String administrativeUnitId, String scopedRoleMembershipId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteScopedRoleMembers(
                this.client.getEndpoint(), administrativeUnitId, scopedRoleMembershipId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteScopedRoleMembersAsync(
        String administrativeUnitId, String scopedRoleMembershipId, String ifMatch) {
        return deleteScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteScopedRoleMembersAsync(String administrativeUnitId, String scopedRoleMembershipId) {
        final String ifMatch = null;
        return deleteScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteScopedRoleMembers(String administrativeUnitId, String scopedRoleMembershipId) {
        final String ifMatch = null;
        deleteScopedRoleMembersAsync(administrativeUnitId, scopedRoleMembershipId, ifMatch).block();
    }

    /**
     * Delete navigation property scopedRoleMembers for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteScopedRoleMembersWithResponse(
        String administrativeUnitId, String scopedRoleMembershipId, String ifMatch, Context context) {
        return deleteScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, ifMatch, context)
            .block();
    }

    /**
     * Invoke function delta.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphAdministrativeUnitInner>>> deltaWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delta(this.client.getEndpoint(), accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke function delta.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphAdministrativeUnitInner>>> deltaWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delta(this.client.getEndpoint(), accept, context);
    }

    /**
     * Invoke function delta.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphAdministrativeUnitInner>> deltaAsync() {
        return deltaWithResponseAsync()
            .flatMap(
                (Response<List<MicrosoftGraphAdministrativeUnitInner>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke function delta.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<MicrosoftGraphAdministrativeUnitInner> delta() {
        return deltaAsync().block();
    }

    /**
     * Invoke function delta.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<MicrosoftGraphAdministrativeUnitInner>> deltaWithResponse(Context context) {
        return deltaWithResponseAsync(context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphExtensionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMembersNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMembersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefMembersNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefMembersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMembersNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listScopedRoleMembersNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMembersNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listScopedRoleMembersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
