// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.DirectoryRoleTemplatesDirectoryRoleTemplatesClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryRoleTemplate;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesDirectoryRoleTemplateOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesDirectoryRoleTemplateSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryRoleTemplateInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import java.util.List;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * DirectoryRoleTemplatesDirectoryRoleTemplatesClient.
 */
public final class DirectoryRoleTemplatesDirectoryRoleTemplatesClientImpl
    implements DirectoryRoleTemplatesDirectoryRoleTemplatesClient {
    private final ClientLogger logger = new ClientLogger(DirectoryRoleTemplatesDirectoryRoleTemplatesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final DirectoryRoleTemplatesDirectoryRoleTemplatesService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of DirectoryRoleTemplatesDirectoryRoleTemplatesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DirectoryRoleTemplatesDirectoryRoleTemplatesClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy
                .create(
                    DirectoryRoleTemplatesDirectoryRoleTemplatesService.class,
                    client.getHttpPipeline(),
                    client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientDirectoryRoleTemplatesDirectoryRoleTemplates to
     * be used by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface DirectoryRoleTemplatesDirectoryRoleTemplatesService {
        @Headers({"Content-Type: application/json"})
        @Get("/directoryRoleTemplates")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryRoleTemplate>> listDirectoryRoleTemplate(
            @HostParam("$host") String endpoint,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/directoryRoleTemplates")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> createDirectoryRoleTemplate(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") MicrosoftGraphDirectoryRoleTemplateInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/directoryRoleTemplates/{directoryRoleTemplate-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> getDirectoryRoleTemplate(
            @HostParam("$host") String endpoint,
            @PathParam("directoryRoleTemplate-id") String directoryRoleTemplateId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/directoryRoleTemplates/{directoryRoleTemplate-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateDirectoryRoleTemplate(
            @HostParam("$host") String endpoint,
            @PathParam("directoryRoleTemplate-id") String directoryRoleTemplateId,
            @BodyParam("application/json") MicrosoftGraphDirectoryRoleTemplateInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/directoryRoleTemplates/{directoryRoleTemplate-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteDirectoryRoleTemplate(
            @HostParam("$host") String endpoint,
            @PathParam("directoryRoleTemplate-id") String directoryRoleTemplateId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryRoleTemplate>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get entities from directoryRoleTemplates.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleTemplateInner>> listDirectoryRoleTemplateSinglePageAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listDirectoryRoleTemplate(
                            this.client.getEndpoint(),
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryRoleTemplateInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entities from directoryRoleTemplates.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleTemplateInner>> listDirectoryRoleTemplateSinglePageAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listDirectoryRoleTemplate(
                this.client.getEndpoint(),
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get entities from directoryRoleTemplates.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplateAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () -> listDirectoryRoleTemplateSinglePageAsync(top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from directoryRoleTemplates.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplateAsync() {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby = null;
        final List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () -> listDirectoryRoleTemplateSinglePageAsync(top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from directoryRoleTemplates.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplateAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listDirectoryRoleTemplateSinglePageAsync(
                    top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get entities from directoryRoleTemplates.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplate() {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby = null;
        final List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listDirectoryRoleTemplateAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get entities from directoryRoleTemplates.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoleTemplates.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplate(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listDirectoryRoleTemplateAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Add new entity to directoryRoleTemplates.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> createDirectoryRoleTemplateWithResponseAsync(
        MicrosoftGraphDirectoryRoleTemplateInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createDirectoryRoleTemplate(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Add new entity to directoryRoleTemplates.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> createDirectoryRoleTemplateWithResponseAsync(
        MicrosoftGraphDirectoryRoleTemplateInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createDirectoryRoleTemplate(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Add new entity to directoryRoleTemplates.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryRoleTemplateInner> createDirectoryRoleTemplateAsync(
        MicrosoftGraphDirectoryRoleTemplateInner body) {
        return createDirectoryRoleTemplateWithResponseAsync(body)
            .flatMap(
                (Response<MicrosoftGraphDirectoryRoleTemplateInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Add new entity to directoryRoleTemplates.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryRoleTemplateInner createDirectoryRoleTemplate(
        MicrosoftGraphDirectoryRoleTemplateInner body) {
        return createDirectoryRoleTemplateAsync(body).block();
    }

    /**
     * Add new entity to directoryRoleTemplates.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryRoleTemplateInner> createDirectoryRoleTemplateWithResponse(
        MicrosoftGraphDirectoryRoleTemplateInner body, Context context) {
        return createDirectoryRoleTemplateWithResponseAsync(body, context).block();
    }

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> getDirectoryRoleTemplateWithResponseAsync(
        String directoryRoleTemplateId,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getDirectoryRoleTemplate(
                            this.client.getEndpoint(),
                            directoryRoleTemplateId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> getDirectoryRoleTemplateWithResponseAsync(
        String directoryRoleTemplateId,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getDirectoryRoleTemplate(
                this.client.getEndpoint(), directoryRoleTemplateId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryRoleTemplateInner> getDirectoryRoleTemplateAsync(
        String directoryRoleTemplateId,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand) {
        return getDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryRoleTemplateInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryRoleTemplateInner> getDirectoryRoleTemplateAsync(
        String directoryRoleTemplateId) {
        final List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select = null;
        final List<String> expand = null;
        return getDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryRoleTemplateInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryRoleTemplateInner getDirectoryRoleTemplate(String directoryRoleTemplateId) {
        final List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select = null;
        final List<String> expand = null;
        return getDirectoryRoleTemplateAsync(directoryRoleTemplateId, select, expand).block();
    }

    /**
     * Get entity from directoryRoleTemplates by key.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoleTemplates by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryRoleTemplateInner> getDirectoryRoleTemplateWithResponse(
        String directoryRoleTemplateId,
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select,
        List<String> expand,
        Context context) {
        return getDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, select, expand, context).block();
    }

    /**
     * Update entity in directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateDirectoryRoleTemplateWithResponseAsync(
        String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateDirectoryRoleTemplate(
                            this.client.getEndpoint(), directoryRoleTemplateId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update entity in directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateDirectoryRoleTemplateWithResponseAsync(
        String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateDirectoryRoleTemplate(this.client.getEndpoint(), directoryRoleTemplateId, body, accept, context);
    }

    /**
     * Update entity in directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateDirectoryRoleTemplateAsync(
        String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body) {
        return updateDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update entity in directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateDirectoryRoleTemplate(
        String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body) {
        updateDirectoryRoleTemplateAsync(directoryRoleTemplateId, body).block();
    }

    /**
     * Update entity in directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateDirectoryRoleTemplateWithResponse(
        String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body, Context context) {
        return updateDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, body, context).block();
    }

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDirectoryRoleTemplateWithResponseAsync(
        String directoryRoleTemplateId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteDirectoryRoleTemplate(
                            this.client.getEndpoint(), directoryRoleTemplateId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDirectoryRoleTemplateWithResponseAsync(
        String directoryRoleTemplateId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteDirectoryRoleTemplate(this.client.getEndpoint(), directoryRoleTemplateId, ifMatch, accept, context);
    }

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDirectoryRoleTemplateAsync(String directoryRoleTemplateId, String ifMatch) {
        return deleteDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDirectoryRoleTemplateAsync(String directoryRoleTemplateId) {
        final String ifMatch = null;
        return deleteDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteDirectoryRoleTemplate(String directoryRoleTemplateId) {
        final String ifMatch = null;
        deleteDirectoryRoleTemplateAsync(directoryRoleTemplateId, ifMatch).block();
    }

    /**
     * Delete entity from directoryRoleTemplates.
     *
     * @param directoryRoleTemplateId key: id of directoryRoleTemplate.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDirectoryRoleTemplateWithResponse(
        String directoryRoleTemplateId, String ifMatch, Context context) {
        return deleteDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, ifMatch, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryRoleTemplate.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleTemplateInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryRoleTemplateInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryRoleTemplate.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleTemplateInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
