// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.GroupsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfAppRoleAssignment;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject1;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject3;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject4;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject5;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject6;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtension;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject1;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject3;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject4;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfProfilePhoto;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfResourceSpecificPermissionGrant;
import com.azure.resourcemanager.authorization.fluent.models.GroupsAssignLicenseRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.GroupsSelect;
import com.azure.resourcemanager.authorization.fluent.models.GroupsValidatePropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAppRoleAssignmentInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphGroupInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphProfilePhotoInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResourceSpecificPermissionGrantInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in GroupsClient. */
public final class GroupsClientImpl implements GroupsClient {
    private final ClientLogger logger = new ClientLogger(GroupsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final GroupsService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of GroupsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    GroupsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = RestProxy.create(GroupsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientGroups to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface GroupsService {
        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/appRoleAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfAppRoleAssignment>> listAppRoleAssignments(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/appRoleAssignments")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignments(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") MicrosoftGraphAppRoleAssignmentInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignments(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("appRoleAssignment-id") String appRoleAssignmentId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/groups/{group-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateAppRoleAssignments(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("appRoleAssignment-id") String appRoleAssignmentId,
            @BodyParam("application/json") MicrosoftGraphAppRoleAssignmentInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/groups/{group-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteAppRoleAssignments(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("appRoleAssignment-id") String appRoleAssignmentId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/acceptedSenders")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject>> listAcceptedSenders(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/acceptedSenders")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryObjectInner>> createAcceptedSenders(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") MicrosoftGraphDirectoryObjectInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/acceptedSenders/{directoryObject-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryObjectInner>> getAcceptedSenders(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("directoryObject-id") String directoryObjectId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/groups/{group-id}/acceptedSenders/{directoryObject-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateAcceptedSenders(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("directoryObject-id") String directoryObjectId,
            @BodyParam("application/json") MicrosoftGraphDirectoryObjectInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/groups/{group-id}/acceptedSenders/{directoryObject-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteAcceptedSenders(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("directoryObject-id") String directoryObjectId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/createdOnBehalfOf")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOf(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<String>> getRefCreatedOnBehalfOf(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put("/groups/{group-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> setRefCreatedOnBehalfOf(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/groups/{group-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteRefCreatedOnBehalfOf(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/extensions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfExtension>> listExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/extensions")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphExtensionInner>> createExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") MicrosoftGraphExtensionInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/extensions/{extension-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphExtensionInner>> getExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("extension-id") String extensionId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/groups/{group-id}/extensions/{extension-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("extension-id") String extensionId,
            @BodyParam("application/json") MicrosoftGraphExtensionInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/groups/{group-id}/extensions/{extension-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("extension-id") String extensionId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/memberOf")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject0>> listMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/memberOf/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject>> listRefMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/memberOf/$ref")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/members")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject1>> listMembers(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/members/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject0>> listRefMembers(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/members/$ref")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> createRefMembers(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/groups/{group-id}/members/{directoryObject-id}/$ref")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteRefMember(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("directoryObject-id") String directoryObjectId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/membersWithLicenseErrors")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject2>> listMembersWithLicenseErrors(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/membersWithLicenseErrors/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject1>> listRefMembersWithLicenseErrors(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/membersWithLicenseErrors/$ref")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefMembersWithLicenseErrors(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.addFavorite")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> addFavorite(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.assignLicense")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphGroupInner>> assignLicense(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") GroupsAssignLicenseRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.checkGrantedPermissionsForApp")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<MicrosoftGraphResourceSpecificPermissionGrantInner>>> checkGrantedPermissionsForApp(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> checkMemberGroups(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") GroupsCheckMemberGroupsRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> checkMemberObjects(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") GroupsCheckMemberObjectsRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> getMemberGroups(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") GroupsGetMemberGroupsRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> getMemberObjects(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") GroupsGetMemberObjectsRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.removeFavorite")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> removeFavorite(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.renew")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> renew(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.resetUnseenCount")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> resetUnseenCount(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.restore")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.subscribeByMail")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> subscribeByMail(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.unsubscribeByMail")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> unsubscribeByMail(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/microsoft.graph.validateProperties")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> validateProperties(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") GroupsValidatePropertiesRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/owners")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject3>> listOwners(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/owners/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject2>> listRefOwners(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/owners/$ref")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefOwners(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/permissionGrants")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfResourceSpecificPermissionGrant>> listPermissionGrants(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/permissionGrants")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> createPermissionGrants(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") MicrosoftGraphResourceSpecificPermissionGrantInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/permissionGrants/{resourceSpecificPermissionGrant-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> getPermissionGrants(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("resourceSpecificPermissionGrant-id") String resourceSpecificPermissionGrantId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/groups/{group-id}/permissionGrants/{resourceSpecificPermissionGrant-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updatePermissionGrants(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("resourceSpecificPermissionGrant-id") String resourceSpecificPermissionGrantId,
            @BodyParam("application/json") MicrosoftGraphResourceSpecificPermissionGrantInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/groups/{group-id}/permissionGrants/{resourceSpecificPermissionGrant-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deletePermissionGrants(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("resourceSpecificPermissionGrant-id") String resourceSpecificPermissionGrantId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/photo")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhoto(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/groups/{group-id}/photo")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updatePhoto(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") MicrosoftGraphProfilePhotoInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/groups/{group-id}/photo")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deletePhoto(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/photo/$value")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<StreamResponse> getPhotoContent(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/octet-stream"})
        @Put("/groups/{group-id}/photo/$value")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> setPhotoContent(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> data,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/photos")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfProfilePhoto>> listPhotos(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/photos")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphProfilePhotoInner>> createPhotos(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") MicrosoftGraphProfilePhotoInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/photos/{profilePhoto-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotos(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("profilePhoto-id") String profilePhotoId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/groups/{group-id}/photos/{profilePhoto-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updatePhotos(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("profilePhoto-id") String profilePhotoId,
            @BodyParam("application/json") MicrosoftGraphProfilePhotoInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/groups/{group-id}/photos/{profilePhoto-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deletePhotos(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("profilePhoto-id") String profilePhotoId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/photos/{profilePhoto-id}/$value")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<StreamResponse> getPhotosContent(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("profilePhoto-id") String profilePhotoId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/octet-stream"})
        @Put("/groups/{group-id}/photos/{profilePhoto-id}/$value")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> setPhotosContent(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("profilePhoto-id") String profilePhotoId,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> data,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/rejectedSenders")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject4>> listRejectedSenders(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/rejectedSenders")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryObjectInner>> createRejectedSenders(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") MicrosoftGraphDirectoryObjectInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/rejectedSenders/{directoryObject-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryObjectInner>> getRejectedSenders(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("directoryObject-id") String directoryObjectId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/groups/{group-id}/rejectedSenders/{directoryObject-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateRejectedSenders(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("directoryObject-id") String directoryObjectId,
            @BodyParam("application/json") MicrosoftGraphDirectoryObjectInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/groups/{group-id}/rejectedSenders/{directoryObject-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteRejectedSenders(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @PathParam("directoryObject-id") String directoryObjectId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/transitiveMemberOf")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject5>> listTransitiveMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/transitiveMemberOf/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject3>> listRefTransitiveMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/transitiveMemberOf/$ref")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefTransitiveMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/transitiveMembers")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject6>> listTransitiveMembers(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/{group-id}/transitiveMembers/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject4>> listRefTransitiveMembers(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/{group-id}/transitiveMembers/$ref")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefTransitiveMembers(
            @HostParam("$host") String endpoint,
            @PathParam("group-id") String groupId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groups/microsoft.graph.delta()")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<MicrosoftGraphGroupInner>>> delta(
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/microsoft.graph.getAvailableExtensionProperties")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionProperties(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") GroupsGetAvailableExtensionPropertiesRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/microsoft.graph.getByIds")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIds(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") GroupsGetByIdsRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groups/microsoft.graph.validateProperties")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> validateProperties(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") GroupsValidatePropertiesRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfAppRoleAssignment>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject>> listAcceptedSendersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfExtension>> listExtensionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject0>> listMemberOfNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject>> listRefMemberOfNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject1>> listMembersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject0>> listRefMembersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject2>> listMembersWithLicenseErrorsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject1>> listRefMembersWithLicenseErrorsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject3>> listOwnersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject2>> listRefOwnersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfResourceSpecificPermissionGrant>> listPermissionGrantsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfProfilePhoto>> listPhotosNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject4>> listRejectedSendersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject5>> listTransitiveMemberOfNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject3>> listRefTransitiveMemberOfNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject6>> listTransitiveMembersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject4>> listRefTransitiveMembersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignmentsSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listAppRoleAssignments(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignmentsSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listAppRoleAssignments(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listAppRoleAssignmentsSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listAppRoleAssignmentsSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listAppRoleAssignmentsSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignments(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listAppRoleAssignmentsAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignments(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listAppRoleAssignmentsAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignmentsWithResponseAsync(
        String groupId, MicrosoftGraphAppRoleAssignmentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createAppRoleAssignments(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignmentsWithResponseAsync(
        String groupId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createAppRoleAssignments(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property to appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignmentsAsync(
        String groupId, MicrosoftGraphAppRoleAssignmentInner body) {
        return createAppRoleAssignmentsWithResponseAsync(groupId, body)
            .flatMap(
                (Response<MicrosoftGraphAppRoleAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphAppRoleAssignmentInner createAppRoleAssignments(
        String groupId, MicrosoftGraphAppRoleAssignmentInner body) {
        return createAppRoleAssignmentsAsync(groupId, body).block();
    }

    /**
     * Create new navigation property to appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignmentsWithResponse(
        String groupId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        return createAppRoleAssignmentsWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignmentsWithResponseAsync(
        String groupId, String appRoleAssignmentId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getAppRoleAssignments(
                            this.client.getEndpoint(),
                            groupId,
                            appRoleAssignmentId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignmentsWithResponseAsync(
        String groupId, String appRoleAssignmentId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getAppRoleAssignments(
                this.client.getEndpoint(),
                groupId,
                appRoleAssignmentId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsAsync(
        String groupId, String appRoleAssignmentId, List<GroupsSelect> select, List<String> expand) {
        return getAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphAppRoleAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsAsync(
        String groupId, String appRoleAssignmentId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphAppRoleAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphAppRoleAssignmentInner getAppRoleAssignments(String groupId, String appRoleAssignmentId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getAppRoleAssignmentsAsync(groupId, appRoleAssignmentId, select, expand).block();
    }

    /**
     * Get appRoleAssignments from groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsWithResponse(
        String groupId, String appRoleAssignmentId, List<GroupsSelect> select, List<String> expand, Context context) {
        return getAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, select, expand, context).block();
    }

    /**
     * Update the navigation property appRoleAssignments in groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateAppRoleAssignmentsWithResponseAsync(
        String groupId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateAppRoleAssignments(
                            this.client.getEndpoint(), groupId, appRoleAssignmentId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property appRoleAssignments in groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateAppRoleAssignmentsWithResponseAsync(
        String groupId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateAppRoleAssignments(this.client.getEndpoint(), groupId, appRoleAssignmentId, body, accept, context);
    }

    /**
     * Update the navigation property appRoleAssignments in groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateAppRoleAssignmentsAsync(
        String groupId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        return updateAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property appRoleAssignments in groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateAppRoleAssignments(
        String groupId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        updateAppRoleAssignmentsAsync(groupId, appRoleAssignmentId, body).block();
    }

    /**
     * Update the navigation property appRoleAssignments in groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateAppRoleAssignmentsWithResponse(
        String groupId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        return updateAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, body, context).block();
    }

    /**
     * Delete navigation property appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAppRoleAssignmentsWithResponseAsync(
        String groupId, String appRoleAssignmentId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteAppRoleAssignments(
                            this.client.getEndpoint(), groupId, appRoleAssignmentId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAppRoleAssignmentsWithResponseAsync(
        String groupId, String appRoleAssignmentId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteAppRoleAssignments(
                this.client.getEndpoint(), groupId, appRoleAssignmentId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAppRoleAssignmentsAsync(String groupId, String appRoleAssignmentId, String ifMatch) {
        return deleteAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAppRoleAssignmentsAsync(String groupId, String appRoleAssignmentId) {
        final String ifMatch = null;
        return deleteAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAppRoleAssignments(String groupId, String appRoleAssignmentId) {
        final String ifMatch = null;
        deleteAppRoleAssignmentsAsync(groupId, appRoleAssignmentId, ifMatch).block();
    }

    /**
     * Delete navigation property appRoleAssignments for groups.
     *
     * @param groupId key: id of group.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteAppRoleAssignmentsWithResponse(
        String groupId, String appRoleAssignmentId, String ifMatch, Context context) {
        return deleteAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, ifMatch, context).block();
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listAcceptedSendersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listAcceptedSenders(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listAcceptedSendersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listAcceptedSenders(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listAcceptedSendersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listAcceptedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listAcceptedSendersNextSinglePageAsync(nextLink));
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listAcceptedSendersAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listAcceptedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listAcceptedSendersNextSinglePageAsync(nextLink));
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listAcceptedSendersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listAcceptedSendersSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listAcceptedSendersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listAcceptedSenders(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listAcceptedSendersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listAcceptedSenders(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listAcceptedSendersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> createAcceptedSendersWithResponseAsync(
        String groupId, MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createAcceptedSenders(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> createAcceptedSendersWithResponseAsync(
        String groupId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createAcceptedSenders(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property to acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> createAcceptedSendersAsync(
        String groupId, MicrosoftGraphDirectoryObjectInner body) {
        return createAcceptedSendersWithResponseAsync(groupId, body)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner createAcceptedSenders(
        String groupId, MicrosoftGraphDirectoryObjectInner body) {
        return createAcceptedSendersAsync(groupId, body).block();
    }

    /**
     * Create new navigation property to acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> createAcceptedSendersWithResponse(
        String groupId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        return createAcceptedSendersWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getAcceptedSendersWithResponseAsync(
        String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getAcceptedSenders(
                            this.client.getEndpoint(),
                            groupId,
                            directoryObjectId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getAcceptedSendersWithResponseAsync(
        String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getAcceptedSenders(
                this.client.getEndpoint(),
                groupId,
                directoryObjectId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getAcceptedSendersAsync(
        String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand) {
        return getAcceptedSendersWithResponseAsync(groupId, directoryObjectId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getAcceptedSendersAsync(String groupId, String directoryObjectId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getAcceptedSendersWithResponseAsync(groupId, directoryObjectId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner getAcceptedSenders(String groupId, String directoryObjectId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getAcceptedSendersAsync(groupId, directoryObjectId, select, expand).block();
    }

    /**
     * Get acceptedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return acceptedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> getAcceptedSendersWithResponse(
        String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand, Context context) {
        return getAcceptedSendersWithResponseAsync(groupId, directoryObjectId, select, expand, context).block();
    }

    /**
     * Update the navigation property acceptedSenders in groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateAcceptedSendersWithResponseAsync(
        String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateAcceptedSenders(
                            this.client.getEndpoint(), groupId, directoryObjectId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property acceptedSenders in groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateAcceptedSendersWithResponseAsync(
        String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateAcceptedSenders(this.client.getEndpoint(), groupId, directoryObjectId, body, accept, context);
    }

    /**
     * Update the navigation property acceptedSenders in groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateAcceptedSendersAsync(
        String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        return updateAcceptedSendersWithResponseAsync(groupId, directoryObjectId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property acceptedSenders in groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateAcceptedSenders(
        String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        updateAcceptedSendersAsync(groupId, directoryObjectId, body).block();
    }

    /**
     * Update the navigation property acceptedSenders in groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateAcceptedSendersWithResponse(
        String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        return updateAcceptedSendersWithResponseAsync(groupId, directoryObjectId, body, context).block();
    }

    /**
     * Delete navigation property acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAcceptedSendersWithResponseAsync(
        String groupId, String directoryObjectId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteAcceptedSenders(
                            this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAcceptedSendersWithResponseAsync(
        String groupId, String directoryObjectId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteAcceptedSenders(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAcceptedSendersAsync(String groupId, String directoryObjectId, String ifMatch) {
        return deleteAcceptedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAcceptedSendersAsync(String groupId, String directoryObjectId) {
        final String ifMatch = null;
        return deleteAcceptedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAcceptedSenders(String groupId, String directoryObjectId) {
        final String ifMatch = null;
        deleteAcceptedSendersAsync(groupId, directoryObjectId, ifMatch).block();
    }

    /**
     * Delete navigation property acceptedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteAcceptedSendersWithResponse(
        String groupId, String directoryObjectId, String ifMatch, Context context) {
        return deleteAcceptedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch, context).block();
    }

    /**
     * Get createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOfWithResponseAsync(
        String groupId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getCreatedOnBehalfOf(
                            this.client.getEndpoint(), groupId, selectConverted, expandConverted, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOfWithResponseAsync(
        String groupId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getCreatedOnBehalfOf(
                this.client.getEndpoint(), groupId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getCreatedOnBehalfOfAsync(
        String groupId, List<GroupsSelect> select, List<String> expand) {
        return getCreatedOnBehalfOfWithResponseAsync(groupId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getCreatedOnBehalfOfAsync(String groupId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getCreatedOnBehalfOfWithResponseAsync(groupId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner getCreatedOnBehalfOf(String groupId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getCreatedOnBehalfOfAsync(groupId, select, expand).block();
    }

    /**
     * Get createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> getCreatedOnBehalfOfWithResponse(
        String groupId, List<GroupsSelect> select, List<String> expand, Context context) {
        return getCreatedOnBehalfOfWithResponseAsync(groupId, select, expand, context).block();
    }

    /**
     * Get ref of createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<String>> getRefCreatedOnBehalfOfWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<String>> getRefCreatedOnBehalfOfWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, accept, context);
    }

    /**
     * Get ref of createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<String> getRefCreatedOnBehalfOfAsync(String groupId) {
        return getRefCreatedOnBehalfOfWithResponseAsync(groupId)
            .flatMap(
                (Response<String> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get ref of createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getRefCreatedOnBehalfOf(String groupId) {
        return getRefCreatedOnBehalfOfAsync(groupId).block();
    }

    /**
     * Get ref of createdOnBehalfOf from groups.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdOnBehalfOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<String> getRefCreatedOnBehalfOfWithResponse(String groupId, Context context) {
        return getRefCreatedOnBehalfOfWithResponseAsync(groupId, context).block();
    }

    /**
     * Update the ref of navigation property createdOnBehalfOf in groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setRefCreatedOnBehalfOfWithResponseAsync(String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.setRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the ref of navigation property createdOnBehalfOf in groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> setRefCreatedOnBehalfOfWithResponseAsync(
        String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.setRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Update the ref of navigation property createdOnBehalfOf in groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setRefCreatedOnBehalfOfAsync(String groupId, Map<String, Object> body) {
        return setRefCreatedOnBehalfOfWithResponseAsync(groupId, body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the ref of navigation property createdOnBehalfOf in groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setRefCreatedOnBehalfOf(String groupId, Map<String, Object> body) {
        setRefCreatedOnBehalfOfAsync(groupId, body).block();
    }

    /**
     * Update the ref of navigation property createdOnBehalfOf in groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setRefCreatedOnBehalfOfWithResponse(
        String groupId, Map<String, Object> body, Context context) {
        return setRefCreatedOnBehalfOfWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for groups.
     *
     * @param groupId key: id of group.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRefCreatedOnBehalfOfWithResponseAsync(String groupId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.deleteRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for groups.
     *
     * @param groupId key: id of group.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRefCreatedOnBehalfOfWithResponseAsync(
        String groupId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, ifMatch, accept, context);
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for groups.
     *
     * @param groupId key: id of group.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteRefCreatedOnBehalfOfAsync(String groupId, String ifMatch) {
        return deleteRefCreatedOnBehalfOfWithResponseAsync(groupId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteRefCreatedOnBehalfOfAsync(String groupId) {
        final String ifMatch = null;
        return deleteRefCreatedOnBehalfOfWithResponseAsync(groupId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteRefCreatedOnBehalfOf(String groupId) {
        final String ifMatch = null;
        deleteRefCreatedOnBehalfOfAsync(groupId, ifMatch).block();
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for groups.
     *
     * @param groupId key: id of group.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteRefCreatedOnBehalfOfWithResponse(String groupId, String ifMatch, Context context) {
        return deleteRefCreatedOnBehalfOfWithResponseAsync(groupId, ifMatch, context).block();
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<String> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listExtensions(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphExtensionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listExtensions(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<String> select,
        List<String> expand) {
        return new PagedFlux<>(
            () -> listExtensionsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listExtensionsNextSinglePageAsync(nextLink));
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<String> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () -> listExtensionsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listExtensionsNextSinglePageAsync(nextLink));
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listExtensionsSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listExtensionsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<String> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listExtensionsAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listExtensionsAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to extensions for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(
        String groupId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createExtensions(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to extensions for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(
        String groupId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createExtensions(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property to extensions for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(String groupId, MicrosoftGraphExtensionInner body) {
        return createExtensionsWithResponseAsync(groupId, body)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to extensions for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner createExtensions(String groupId, MicrosoftGraphExtensionInner body) {
        return createExtensionsAsync(groupId, body).block();
    }

    /**
     * Create new navigation property to extensions for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(
        String groupId, MicrosoftGraphExtensionInner body, Context context) {
        return createExtensionsWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(
        String groupId, String extensionId, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getExtensions(
                            this.client.getEndpoint(),
                            groupId,
                            extensionId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(
        String groupId, String extensionId, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getExtensions(
                this.client.getEndpoint(), groupId, extensionId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(
        String groupId, String extensionId, List<String> select, List<String> expand) {
        return getExtensionsWithResponseAsync(groupId, extensionId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String groupId, String extensionId) {
        final List<String> select = null;
        final List<String> expand = null;
        return getExtensionsWithResponseAsync(groupId, extensionId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner getExtensions(String groupId, String extensionId) {
        final List<String> select = null;
        final List<String> expand = null;
        return getExtensionsAsync(groupId, extensionId, select, expand).block();
    }

    /**
     * Get extensions from groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(
        String groupId, String extensionId, List<String> select, List<String> expand, Context context) {
        return getExtensionsWithResponseAsync(groupId, extensionId, select, expand, context).block();
    }

    /**
     * Update the navigation property extensions in groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateExtensionsWithResponseAsync(
        String groupId, String extensionId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.updateExtensions(this.client.getEndpoint(), groupId, extensionId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property extensions in groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateExtensionsWithResponseAsync(
        String groupId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateExtensions(this.client.getEndpoint(), groupId, extensionId, body, accept, context);
    }

    /**
     * Update the navigation property extensions in groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateExtensionsAsync(String groupId, String extensionId, MicrosoftGraphExtensionInner body) {
        return updateExtensionsWithResponseAsync(groupId, extensionId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property extensions in groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateExtensions(String groupId, String extensionId, MicrosoftGraphExtensionInner body) {
        updateExtensionsAsync(groupId, extensionId, body).block();
    }

    /**
     * Update the navigation property extensions in groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateExtensionsWithResponse(
        String groupId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        return updateExtensionsWithResponseAsync(groupId, extensionId, body, context).block();
    }

    /**
     * Delete navigation property extensions for groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteExtensionsWithResponseAsync(String groupId, String extensionId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.deleteExtensions(this.client.getEndpoint(), groupId, extensionId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property extensions for groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteExtensionsWithResponseAsync(
        String groupId, String extensionId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteExtensions(this.client.getEndpoint(), groupId, extensionId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property extensions for groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(String groupId, String extensionId, String ifMatch) {
        return deleteExtensionsWithResponseAsync(groupId, extensionId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property extensions for groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(String groupId, String extensionId) {
        final String ifMatch = null;
        return deleteExtensionsWithResponseAsync(groupId, extensionId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property extensions for groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteExtensions(String groupId, String extensionId) {
        final String ifMatch = null;
        deleteExtensionsAsync(groupId, extensionId, ifMatch).block();
    }

    /**
     * Delete navigation property extensions for groups.
     *
     * @param groupId key: id of group.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteExtensionsWithResponse(
        String groupId, String extensionId, String ifMatch, Context context) {
        return deleteExtensionsWithResponseAsync(groupId, extensionId, ifMatch, context).block();
    }

    /**
     * Get memberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listMemberOf(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get memberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listMemberOf(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get memberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () -> listMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get memberOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () -> listMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get memberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listMemberOfSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMemberOfNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get memberOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listMemberOfAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get memberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listMemberOfAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of memberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefMemberOf(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of memberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefMemberOf(
                this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of memberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefMemberOfAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of memberOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefMemberOfAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of memberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefMemberOfAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () -> listRefMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefMemberOfNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of memberOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefMemberOf(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedIterable<>(listRefMemberOfAsync(groupId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of memberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefMemberOf(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(listRefMemberOfAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to memberOf for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(
        String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createRefMemberOf(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to memberOf for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(
        String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefMemberOf(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property ref to memberOf for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefMemberOfAsync(String groupId, Map<String, Object> body) {
        return createRefMemberOfWithResponseAsync(groupId, body)
            .flatMap(
                (Response<Map<String, Object>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property ref to memberOf for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefMemberOf(String groupId, Map<String, Object> body) {
        return createRefMemberOfAsync(groupId, body).block();
    }

    /**
     * Create new navigation property ref to memberOf for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefMemberOfWithResponse(
        String groupId, Map<String, Object> body, Context context) {
        return createRefMemberOfWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Get members from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listMembers(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get members from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listMembers(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get members from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () -> listMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get members from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () -> listMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get members from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMembersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get members from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listMembersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get members from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listMembersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of members from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefMembers(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of members from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefMembers(
                this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of members from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of members from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of members from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefMembersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () -> listRefMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefMembersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of members from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembers(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedIterable<>(listRefMembersAsync(groupId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of members from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembers(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(listRefMembersAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to members for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createRefMembersWithResponseAsync(String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createRefMembers(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to members for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> createRefMembersWithResponseAsync(
        String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefMembers(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property ref to members for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createRefMembersAsync(String groupId, Map<String, Object> body) {
        return createRefMembersWithResponseAsync(groupId, body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Create new navigation property ref to members for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createRefMembers(String groupId, Map<String, Object> body) {
        createRefMembersAsync(groupId, body).block();
    }

    /**
     * Create new navigation property ref to members for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createRefMembersWithResponse(String groupId, Map<String, Object> body, Context context) {
        return createRefMembersWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Delete ref of member from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: directoryObject-id.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRefMemberWithResponseAsync(
        String groupId, String directoryObjectId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteRefMember(
                            this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete ref of member from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: directoryObject-id.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRefMemberWithResponseAsync(
        String groupId, String directoryObjectId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteRefMember(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, accept, context);
    }

    /**
     * Delete ref of member from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: directoryObject-id.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteRefMemberAsync(String groupId, String directoryObjectId, String ifMatch) {
        return deleteRefMemberWithResponseAsync(groupId, directoryObjectId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete ref of member from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: directoryObject-id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteRefMemberAsync(String groupId, String directoryObjectId) {
        final String ifMatch = null;
        return deleteRefMemberWithResponseAsync(groupId, directoryObjectId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete ref of member from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: directoryObject-id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteRefMember(String groupId, String directoryObjectId) {
        final String ifMatch = null;
        deleteRefMemberAsync(groupId, directoryObjectId, ifMatch).block();
    }

    /**
     * Delete ref of member from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: directoryObject-id.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteRefMemberWithResponse(
        String groupId, String directoryObjectId, String ifMatch, Context context) {
        return deleteRefMemberWithResponseAsync(groupId, directoryObjectId, ifMatch, context).block();
    }

    /**
     * Get membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersWithLicenseErrorsSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listMembersWithLicenseErrors(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersWithLicenseErrorsSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listMembersWithLicenseErrors(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersWithLicenseErrorsAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listMembersWithLicenseErrorsSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMembersWithLicenseErrorsNextSinglePageAsync(nextLink));
    }

    /**
     * Get membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersWithLicenseErrorsAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listMembersWithLicenseErrorsSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMembersWithLicenseErrorsNextSinglePageAsync(nextLink));
    }

    /**
     * Get membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersWithLicenseErrorsAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listMembersWithLicenseErrorsSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMembersWithLicenseErrorsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembersWithLicenseErrors(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listMembersWithLicenseErrorsAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembersWithLicenseErrors(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listMembersWithLicenseErrorsAsync(
                groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersWithLicenseErrorsSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefMembersWithLicenseErrors(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersWithLicenseErrorsSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefMembersWithLicenseErrors(
                this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersWithLicenseErrorsAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefMembersWithLicenseErrorsSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefMembersWithLicenseErrorsNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersWithLicenseErrorsAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefMembersWithLicenseErrorsSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefMembersWithLicenseErrorsNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefMembersWithLicenseErrorsAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () ->
                listRefMembersWithLicenseErrorsSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefMembersWithLicenseErrorsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembersWithLicenseErrors(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedIterable<>(
            listRefMembersWithLicenseErrorsAsync(groupId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of membersWithLicenseErrors from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of membersWithLicenseErrors from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembersWithLicenseErrors(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(
            listRefMembersWithLicenseErrorsAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to membersWithLicenseErrors for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefMembersWithLicenseErrorsWithResponseAsync(
        String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createRefMembersWithLicenseErrors(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to membersWithLicenseErrors for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefMembersWithLicenseErrorsWithResponseAsync(
        String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefMembersWithLicenseErrors(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property ref to membersWithLicenseErrors for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefMembersWithLicenseErrorsAsync(String groupId, Map<String, Object> body) {
        return createRefMembersWithLicenseErrorsWithResponseAsync(groupId, body)
            .flatMap(
                (Response<Map<String, Object>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property ref to membersWithLicenseErrors for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefMembersWithLicenseErrors(String groupId, Map<String, Object> body) {
        return createRefMembersWithLicenseErrorsAsync(groupId, body).block();
    }

    /**
     * Create new navigation property ref to membersWithLicenseErrors for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefMembersWithLicenseErrorsWithResponse(
        String groupId, Map<String, Object> body, Context context) {
        return createRefMembersWithLicenseErrorsWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Invoke action addFavorite.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> addFavoriteWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.addFavorite(this.client.getEndpoint(), groupId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action addFavorite.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> addFavoriteWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.addFavorite(this.client.getEndpoint(), groupId, accept, context);
    }

    /**
     * Invoke action addFavorite.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> addFavoriteAsync(String groupId) {
        return addFavoriteWithResponseAsync(groupId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Invoke action addFavorite.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void addFavorite(String groupId) {
        addFavoriteAsync(groupId).block();
    }

    /**
     * Invoke action addFavorite.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> addFavoriteWithResponse(String groupId, Context context) {
        return addFavoriteWithResponseAsync(groupId, context).block();
    }

    /**
     * Invoke action assignLicense.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphGroupInner>> assignLicenseWithResponseAsync(
        String groupId, GroupsAssignLicenseRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.assignLicense(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action assignLicense.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphGroupInner>> assignLicenseWithResponseAsync(
        String groupId, GroupsAssignLicenseRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.assignLicense(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Invoke action assignLicense.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphGroupInner> assignLicenseAsync(String groupId, GroupsAssignLicenseRequestBody body) {
        return assignLicenseWithResponseAsync(groupId, body)
            .flatMap(
                (Response<MicrosoftGraphGroupInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action assignLicense.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphGroupInner assignLicense(String groupId, GroupsAssignLicenseRequestBody body) {
        return assignLicenseAsync(groupId, body).block();
    }

    /**
     * Invoke action assignLicense.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphGroupInner> assignLicenseWithResponse(
        String groupId, GroupsAssignLicenseRequestBody body, Context context) {
        return assignLicenseWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Invoke action checkGrantedPermissionsForApp.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphResourceSpecificPermissionGrantInner>>>
        checkGrantedPermissionsForAppWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.checkGrantedPermissionsForApp(this.client.getEndpoint(), groupId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action checkGrantedPermissionsForApp.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphResourceSpecificPermissionGrantInner>>>
        checkGrantedPermissionsForAppWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkGrantedPermissionsForApp(this.client.getEndpoint(), groupId, accept, context);
    }

    /**
     * Invoke action checkGrantedPermissionsForApp.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphResourceSpecificPermissionGrantInner>> checkGrantedPermissionsForAppAsync(
        String groupId) {
        return checkGrantedPermissionsForAppWithResponseAsync(groupId)
            .flatMap(
                (Response<List<MicrosoftGraphResourceSpecificPermissionGrantInner>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action checkGrantedPermissionsForApp.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<MicrosoftGraphResourceSpecificPermissionGrantInner> checkGrantedPermissionsForApp(String groupId) {
        return checkGrantedPermissionsForAppAsync(groupId).block();
    }

    /**
     * Invoke action checkGrantedPermissionsForApp.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<MicrosoftGraphResourceSpecificPermissionGrantInner>> checkGrantedPermissionsForAppWithResponse(
        String groupId, Context context) {
        return checkGrantedPermissionsForAppWithResponseAsync(groupId, context).block();
    }

    /**
     * Invoke action checkMemberGroups.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(
        String groupId, GroupsCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.checkMemberGroups(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action checkMemberGroups.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(
        String groupId, GroupsCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkMemberGroups(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Invoke action checkMemberGroups.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> checkMemberGroupsAsync(String groupId, GroupsCheckMemberGroupsRequestBody body) {
        return checkMemberGroupsWithResponseAsync(groupId, body)
            .flatMap(
                (Response<List<String>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action checkMemberGroups.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> checkMemberGroups(String groupId, GroupsCheckMemberGroupsRequestBody body) {
        return checkMemberGroupsAsync(groupId, body).block();
    }

    /**
     * Invoke action checkMemberGroups.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> checkMemberGroupsWithResponse(
        String groupId, GroupsCheckMemberGroupsRequestBody body, Context context) {
        return checkMemberGroupsWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Invoke action checkMemberObjects.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(
        String groupId, GroupsCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.checkMemberObjects(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action checkMemberObjects.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(
        String groupId, GroupsCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkMemberObjects(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Invoke action checkMemberObjects.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> checkMemberObjectsAsync(String groupId, GroupsCheckMemberObjectsRequestBody body) {
        return checkMemberObjectsWithResponseAsync(groupId, body)
            .flatMap(
                (Response<List<String>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action checkMemberObjects.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> checkMemberObjects(String groupId, GroupsCheckMemberObjectsRequestBody body) {
        return checkMemberObjectsAsync(groupId, body).block();
    }

    /**
     * Invoke action checkMemberObjects.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> checkMemberObjectsWithResponse(
        String groupId, GroupsCheckMemberObjectsRequestBody body, Context context) {
        return checkMemberObjectsWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Invoke action getMemberGroups.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(
        String groupId, GroupsGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getMemberGroups(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action getMemberGroups.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(
        String groupId, GroupsGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getMemberGroups(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Invoke action getMemberGroups.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> getMemberGroupsAsync(String groupId, GroupsGetMemberGroupsRequestBody body) {
        return getMemberGroupsWithResponseAsync(groupId, body)
            .flatMap(
                (Response<List<String>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action getMemberGroups.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> getMemberGroups(String groupId, GroupsGetMemberGroupsRequestBody body) {
        return getMemberGroupsAsync(groupId, body).block();
    }

    /**
     * Invoke action getMemberGroups.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> getMemberGroupsWithResponse(
        String groupId, GroupsGetMemberGroupsRequestBody body, Context context) {
        return getMemberGroupsWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Invoke action getMemberObjects.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(
        String groupId, GroupsGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getMemberObjects(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action getMemberObjects.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(
        String groupId, GroupsGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getMemberObjects(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Invoke action getMemberObjects.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> getMemberObjectsAsync(String groupId, GroupsGetMemberObjectsRequestBody body) {
        return getMemberObjectsWithResponseAsync(groupId, body)
            .flatMap(
                (Response<List<String>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action getMemberObjects.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> getMemberObjects(String groupId, GroupsGetMemberObjectsRequestBody body) {
        return getMemberObjectsAsync(groupId, body).block();
    }

    /**
     * Invoke action getMemberObjects.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> getMemberObjectsWithResponse(
        String groupId, GroupsGetMemberObjectsRequestBody body, Context context) {
        return getMemberObjectsWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Invoke action removeFavorite.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> removeFavoriteWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.removeFavorite(this.client.getEndpoint(), groupId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action removeFavorite.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> removeFavoriteWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.removeFavorite(this.client.getEndpoint(), groupId, accept, context);
    }

    /**
     * Invoke action removeFavorite.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> removeFavoriteAsync(String groupId) {
        return removeFavoriteWithResponseAsync(groupId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Invoke action removeFavorite.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void removeFavorite(String groupId) {
        removeFavoriteAsync(groupId).block();
    }

    /**
     * Invoke action removeFavorite.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> removeFavoriteWithResponse(String groupId, Context context) {
        return removeFavoriteWithResponseAsync(groupId, context).block();
    }

    /**
     * Invoke action renew.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> renewWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.renew(this.client.getEndpoint(), groupId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action renew.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> renewWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.renew(this.client.getEndpoint(), groupId, accept, context);
    }

    /**
     * Invoke action renew.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> renewAsync(String groupId) {
        return renewWithResponseAsync(groupId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Invoke action renew.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void renew(String groupId) {
        renewAsync(groupId).block();
    }

    /**
     * Invoke action renew.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> renewWithResponse(String groupId, Context context) {
        return renewWithResponseAsync(groupId, context).block();
    }

    /**
     * Invoke action resetUnseenCount.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetUnseenCountWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.resetUnseenCount(this.client.getEndpoint(), groupId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action resetUnseenCount.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> resetUnseenCountWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.resetUnseenCount(this.client.getEndpoint(), groupId, accept, context);
    }

    /**
     * Invoke action resetUnseenCount.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetUnseenCountAsync(String groupId) {
        return resetUnseenCountWithResponseAsync(groupId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Invoke action resetUnseenCount.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void resetUnseenCount(String groupId) {
        resetUnseenCountAsync(groupId).block();
    }

    /**
     * Invoke action resetUnseenCount.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resetUnseenCountWithResponse(String groupId, Context context) {
        return resetUnseenCountWithResponseAsync(groupId, context).block();
    }

    /**
     * Invoke action restore.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.restore(this.client.getEndpoint(), groupId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action restore.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(
        String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.restore(this.client.getEndpoint(), groupId, accept, context);
    }

    /**
     * Invoke action restore.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String groupId) {
        return restoreWithResponseAsync(groupId)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action restore.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner restore(String groupId) {
        return restoreAsync(groupId).block();
    }

    /**
     * Invoke action restore.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String groupId, Context context) {
        return restoreWithResponseAsync(groupId, context).block();
    }

    /**
     * Invoke action subscribeByMail.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> subscribeByMailWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.subscribeByMail(this.client.getEndpoint(), groupId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action subscribeByMail.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> subscribeByMailWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.subscribeByMail(this.client.getEndpoint(), groupId, accept, context);
    }

    /**
     * Invoke action subscribeByMail.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> subscribeByMailAsync(String groupId) {
        return subscribeByMailWithResponseAsync(groupId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Invoke action subscribeByMail.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void subscribeByMail(String groupId) {
        subscribeByMailAsync(groupId).block();
    }

    /**
     * Invoke action subscribeByMail.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> subscribeByMailWithResponse(String groupId, Context context) {
        return subscribeByMailWithResponseAsync(groupId, context).block();
    }

    /**
     * Invoke action unsubscribeByMail.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> unsubscribeByMailWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.unsubscribeByMail(this.client.getEndpoint(), groupId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action unsubscribeByMail.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> unsubscribeByMailWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.unsubscribeByMail(this.client.getEndpoint(), groupId, accept, context);
    }

    /**
     * Invoke action unsubscribeByMail.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> unsubscribeByMailAsync(String groupId) {
        return unsubscribeByMailWithResponseAsync(groupId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Invoke action unsubscribeByMail.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void unsubscribeByMail(String groupId) {
        unsubscribeByMailAsync(groupId).block();
    }

    /**
     * Invoke action unsubscribeByMail.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> unsubscribeByMailWithResponse(String groupId, Context context) {
        return unsubscribeByMailWithResponseAsync(groupId, context).block();
    }

    /**
     * Invoke action validateProperties.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(
        String groupId, GroupsValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.validateProperties(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action validateProperties.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> validatePropertiesWithResponseAsync(
        String groupId, GroupsValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateProperties(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Invoke action validateProperties.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> validatePropertiesAsync(String groupId, GroupsValidatePropertiesRequestBody body) {
        return validatePropertiesWithResponseAsync(groupId, body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Invoke action validateProperties.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateProperties(String groupId, GroupsValidatePropertiesRequestBody body) {
        validatePropertiesAsync(groupId, body).block();
    }

    /**
     * Invoke action validateProperties.
     *
     * @param groupId key: id of group.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> validatePropertiesWithResponse(
        String groupId, GroupsValidatePropertiesRequestBody body, Context context) {
        return validatePropertiesWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Get owners from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listOwners(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get owners from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listOwners(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get owners from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () -> listOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listOwnersNextSinglePageAsync(nextLink));
    }

    /**
     * Get owners from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () -> listOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listOwnersNextSinglePageAsync(nextLink));
    }

    /**
     * Get owners from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listOwnersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get owners from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwners(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(listOwnersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get owners from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwners(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listOwnersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of owners from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefOwners(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of owners from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefOwners(
                this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of owners from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefOwnersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefOwnersNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of owners from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefOwnersAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefOwnersNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of owners from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefOwnersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () -> listRefOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefOwnersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of owners from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefOwners(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedIterable<>(listRefOwnersAsync(groupId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of owners from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefOwners(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(listRefOwnersAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to owners for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefOwnersWithResponseAsync(
        String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createRefOwners(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to owners for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefOwnersWithResponseAsync(
        String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefOwners(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property ref to owners for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefOwnersAsync(String groupId, Map<String, Object> body) {
        return createRefOwnersWithResponseAsync(groupId, body)
            .flatMap(
                (Response<Map<String, Object>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property ref to owners for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefOwners(String groupId, Map<String, Object> body) {
        return createRefOwnersAsync(groupId, body).block();
    }

    /**
     * Create new navigation property ref to owners for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefOwnersWithResponse(
        String groupId, Map<String, Object> body, Context context) {
        return createRefOwnersWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphResourceSpecificPermissionGrantInner>> listPermissionGrantsSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listPermissionGrants(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphResourceSpecificPermissionGrantInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphResourceSpecificPermissionGrantInner>> listPermissionGrantsSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listPermissionGrants(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphResourceSpecificPermissionGrantInner> listPermissionGrantsAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listPermissionGrantsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listPermissionGrantsNextSinglePageAsync(nextLink));
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphResourceSpecificPermissionGrantInner> listPermissionGrantsAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listPermissionGrantsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listPermissionGrantsNextSinglePageAsync(nextLink));
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphResourceSpecificPermissionGrantInner> listPermissionGrantsAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listPermissionGrantsSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listPermissionGrantsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphResourceSpecificPermissionGrantInner> listPermissionGrants(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listPermissionGrantsAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphResourceSpecificPermissionGrantInner> listPermissionGrants(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listPermissionGrantsAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> createPermissionGrantsWithResponseAsync(
        String groupId, MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createPermissionGrants(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> createPermissionGrantsWithResponseAsync(
        String groupId, MicrosoftGraphResourceSpecificPermissionGrantInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createPermissionGrants(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property to permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphResourceSpecificPermissionGrantInner> createPermissionGrantsAsync(
        String groupId, MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        return createPermissionGrantsWithResponseAsync(groupId, body)
            .flatMap(
                (Response<MicrosoftGraphResourceSpecificPermissionGrantInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphResourceSpecificPermissionGrantInner createPermissionGrants(
        String groupId, MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        return createPermissionGrantsAsync(groupId, body).block();
    }

    /**
     * Create new navigation property to permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphResourceSpecificPermissionGrantInner> createPermissionGrantsWithResponse(
        String groupId, MicrosoftGraphResourceSpecificPermissionGrantInner body, Context context) {
        return createPermissionGrantsWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> getPermissionGrantsWithResponseAsync(
        String groupId, String resourceSpecificPermissionGrantId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getPermissionGrants(
                            this.client.getEndpoint(),
                            groupId,
                            resourceSpecificPermissionGrantId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> getPermissionGrantsWithResponseAsync(
        String groupId,
        String resourceSpecificPermissionGrantId,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getPermissionGrants(
                this.client.getEndpoint(),
                groupId,
                resourceSpecificPermissionGrantId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphResourceSpecificPermissionGrantInner> getPermissionGrantsAsync(
        String groupId, String resourceSpecificPermissionGrantId, List<GroupsSelect> select, List<String> expand) {
        return getPermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphResourceSpecificPermissionGrantInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphResourceSpecificPermissionGrantInner> getPermissionGrantsAsync(
        String groupId, String resourceSpecificPermissionGrantId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getPermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphResourceSpecificPermissionGrantInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphResourceSpecificPermissionGrantInner getPermissionGrants(
        String groupId, String resourceSpecificPermissionGrantId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getPermissionGrantsAsync(groupId, resourceSpecificPermissionGrantId, select, expand).block();
    }

    /**
     * Get permissionGrants from groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return permissionGrants from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphResourceSpecificPermissionGrantInner> getPermissionGrantsWithResponse(
        String groupId,
        String resourceSpecificPermissionGrantId,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return getPermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, select, expand, context)
            .block();
    }

    /**
     * Update the navigation property permissionGrants in groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updatePermissionGrantsWithResponseAsync(
        String groupId,
        String resourceSpecificPermissionGrantId,
        MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updatePermissionGrants(
                            this.client.getEndpoint(),
                            groupId,
                            resourceSpecificPermissionGrantId,
                            body,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property permissionGrants in groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updatePermissionGrantsWithResponseAsync(
        String groupId,
        String resourceSpecificPermissionGrantId,
        MicrosoftGraphResourceSpecificPermissionGrantInner body,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updatePermissionGrants(
                this.client.getEndpoint(), groupId, resourceSpecificPermissionGrantId, body, accept, context);
    }

    /**
     * Update the navigation property permissionGrants in groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updatePermissionGrantsAsync(
        String groupId,
        String resourceSpecificPermissionGrantId,
        MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        return updatePermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property permissionGrants in groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updatePermissionGrants(
        String groupId,
        String resourceSpecificPermissionGrantId,
        MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        updatePermissionGrantsAsync(groupId, resourceSpecificPermissionGrantId, body).block();
    }

    /**
     * Update the navigation property permissionGrants in groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updatePermissionGrantsWithResponse(
        String groupId,
        String resourceSpecificPermissionGrantId,
        MicrosoftGraphResourceSpecificPermissionGrantInner body,
        Context context) {
        return updatePermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, body, context)
            .block();
    }

    /**
     * Delete navigation property permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deletePermissionGrantsWithResponseAsync(
        String groupId, String resourceSpecificPermissionGrantId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deletePermissionGrants(
                            this.client.getEndpoint(),
                            groupId,
                            resourceSpecificPermissionGrantId,
                            ifMatch,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deletePermissionGrantsWithResponseAsync(
        String groupId, String resourceSpecificPermissionGrantId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deletePermissionGrants(
                this.client.getEndpoint(), groupId, resourceSpecificPermissionGrantId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deletePermissionGrantsAsync(
        String groupId, String resourceSpecificPermissionGrantId, String ifMatch) {
        return deletePermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deletePermissionGrantsAsync(String groupId, String resourceSpecificPermissionGrantId) {
        final String ifMatch = null;
        return deletePermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deletePermissionGrants(String groupId, String resourceSpecificPermissionGrantId) {
        final String ifMatch = null;
        deletePermissionGrantsAsync(groupId, resourceSpecificPermissionGrantId, ifMatch).block();
    }

    /**
     * Delete navigation property permissionGrants for groups.
     *
     * @param groupId key: id of group.
     * @param resourceSpecificPermissionGrantId key: id of resourceSpecificPermissionGrant.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deletePermissionGrantsWithResponse(
        String groupId, String resourceSpecificPermissionGrantId, String ifMatch, Context context) {
        return deletePermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, ifMatch, context)
            .block();
    }

    /**
     * Get photo from groups.
     *
     * @param groupId key: id of group.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotoWithResponseAsync(
        String groupId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getPhoto(
                            this.client.getEndpoint(), groupId, selectConverted, expandConverted, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get photo from groups.
     *
     * @param groupId key: id of group.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotoWithResponseAsync(
        String groupId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service.getPhoto(this.client.getEndpoint(), groupId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get photo from groups.
     *
     * @param groupId key: id of group.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotoAsync(
        String groupId, List<GroupsSelect> select, List<String> expand) {
        return getPhotoWithResponseAsync(groupId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphProfilePhotoInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get photo from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotoAsync(String groupId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getPhotoWithResponseAsync(groupId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphProfilePhotoInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get photo from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphProfilePhotoInner getPhoto(String groupId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getPhotoAsync(groupId, select, expand).block();
    }

    /**
     * Get photo from groups.
     *
     * @param groupId key: id of group.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphProfilePhotoInner> getPhotoWithResponse(
        String groupId, List<GroupsSelect> select, List<String> expand, Context context) {
        return getPhotoWithResponseAsync(groupId, select, expand, context).block();
    }

    /**
     * Update the navigation property photo in groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updatePhotoWithResponseAsync(String groupId, MicrosoftGraphProfilePhotoInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updatePhoto(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property photo in groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updatePhotoWithResponseAsync(
        String groupId, MicrosoftGraphProfilePhotoInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updatePhoto(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Update the navigation property photo in groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updatePhotoAsync(String groupId, MicrosoftGraphProfilePhotoInner body) {
        return updatePhotoWithResponseAsync(groupId, body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property photo in groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updatePhoto(String groupId, MicrosoftGraphProfilePhotoInner body) {
        updatePhotoAsync(groupId, body).block();
    }

    /**
     * Update the navigation property photo in groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updatePhotoWithResponse(
        String groupId, MicrosoftGraphProfilePhotoInner body, Context context) {
        return updatePhotoWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Delete navigation property photo for groups.
     *
     * @param groupId key: id of group.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deletePhotoWithResponseAsync(String groupId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deletePhoto(this.client.getEndpoint(), groupId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property photo for groups.
     *
     * @param groupId key: id of group.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deletePhotoWithResponseAsync(String groupId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deletePhoto(this.client.getEndpoint(), groupId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property photo for groups.
     *
     * @param groupId key: id of group.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deletePhotoAsync(String groupId, String ifMatch) {
        return deletePhotoWithResponseAsync(groupId, ifMatch).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property photo for groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deletePhotoAsync(String groupId) {
        final String ifMatch = null;
        return deletePhotoWithResponseAsync(groupId, ifMatch).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property photo for groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deletePhoto(String groupId) {
        final String ifMatch = null;
        deletePhotoAsync(groupId, ifMatch).block();
    }

    /**
     * Delete navigation property photo for groups.
     *
     * @param groupId key: id of group.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deletePhotoWithResponse(String groupId, String ifMatch, Context context) {
        return deletePhotoWithResponseAsync(groupId, ifMatch, context).block();
    }

    /**
     * Get media content for the navigation property photo from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return media content for the navigation property photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StreamResponse> getPhotoContentWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/octet-stream, application/json";
        return FluxUtil
            .withContext(context -> service.getPhotoContent(this.client.getEndpoint(), groupId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get media content for the navigation property photo from groups.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return media content for the navigation property photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StreamResponse> getPhotoContentWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/octet-stream, application/json";
        context = this.client.mergeContext(context);
        return service.getPhotoContent(this.client.getEndpoint(), groupId, accept, context);
    }

    /**
     * Get media content for the navigation property photo from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return media content for the navigation property photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Flux<ByteBuffer> getPhotoContentAsync(String groupId) {
        return getPhotoContentWithResponseAsync(groupId).flatMapMany(StreamResponse::getValue);
    }

    /**
     * Get media content for the navigation property photo from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return media content for the navigation property photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public InputStream getPhotoContent(String groupId) {
        Iterator<ByteBufferBackedInputStream> iterator =
            getPhotoContentAsync(groupId).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration =
            new Enumeration<InputStream>() {
                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public InputStream nextElement() {
                    return iterator.next();
                }
            };
        return new SequenceInputStream(enumeration);
    }

    /**
     * Get media content for the navigation property photo from groups.
     *
     * @param groupId key: id of group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return media content for the navigation property photo from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StreamResponse getPhotoContentWithResponse(String groupId, Context context) {
        return getPhotoContentWithResponseAsync(groupId, context).block();
    }

    /**
     * Update media content for the navigation property photo in groups.
     *
     * @param groupId key: id of group.
     * @param data New media content.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setPhotoContentWithResponseAsync(
        String groupId, Flux<ByteBuffer> data, long contentLength) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error(new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.setPhotoContent(this.client.getEndpoint(), groupId, data, contentLength, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update media content for the navigation property photo in groups.
     *
     * @param groupId key: id of group.
     * @param data New media content.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> setPhotoContentWithResponseAsync(
        String groupId, Flux<ByteBuffer> data, long contentLength, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error(new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.setPhotoContent(this.client.getEndpoint(), groupId, data, contentLength, accept, context);
    }

    /**
     * Update media content for the navigation property photo in groups.
     *
     * @param groupId key: id of group.
     * @param data New media content.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setPhotoContentAsync(String groupId, Flux<ByteBuffer> data, long contentLength) {
        return setPhotoContentWithResponseAsync(groupId, data, contentLength)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update media content for the navigation property photo in groups.
     *
     * @param groupId key: id of group.
     * @param data New media content.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setPhotoContent(String groupId, Flux<ByteBuffer> data, long contentLength) {
        setPhotoContentAsync(groupId, data, contentLength).block();
    }

    /**
     * Update media content for the navigation property photo in groups.
     *
     * @param groupId key: id of group.
     * @param data New media content.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setPhotoContentWithResponse(
        String groupId, Flux<ByteBuffer> data, long contentLength, Context context) {
        return setPhotoContentWithResponseAsync(groupId, data, contentLength, context).block();
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listPhotos(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphProfilePhotoInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listPhotos(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphProfilePhotoInner> listPhotosAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () -> listPhotosSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listPhotosNextSinglePageAsync(nextLink));
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphProfilePhotoInner> listPhotosAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () -> listPhotosSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listPhotosNextSinglePageAsync(nextLink));
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphProfilePhotoInner> listPhotosAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listPhotosSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listPhotosNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphProfilePhotoInner> listPhotos(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(listPhotosAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphProfilePhotoInner> listPhotos(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listPhotosAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to photos for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return profilePhoto.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphProfilePhotoInner>> createPhotosWithResponseAsync(
        String groupId, MicrosoftGraphProfilePhotoInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createPhotos(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to photos for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return profilePhoto.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphProfilePhotoInner>> createPhotosWithResponseAsync(
        String groupId, MicrosoftGraphProfilePhotoInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createPhotos(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property to photos for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return profilePhoto.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphProfilePhotoInner> createPhotosAsync(
        String groupId, MicrosoftGraphProfilePhotoInner body) {
        return createPhotosWithResponseAsync(groupId, body)
            .flatMap(
                (Response<MicrosoftGraphProfilePhotoInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to photos for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return profilePhoto.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphProfilePhotoInner createPhotos(String groupId, MicrosoftGraphProfilePhotoInner body) {
        return createPhotosAsync(groupId, body).block();
    }

    /**
     * Create new navigation property to photos for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return profilePhoto.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphProfilePhotoInner> createPhotosWithResponse(
        String groupId, MicrosoftGraphProfilePhotoInner body, Context context) {
        return createPhotosWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotosWithResponseAsync(
        String groupId, String profilePhotoId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error(new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getPhotos(
                            this.client.getEndpoint(),
                            groupId,
                            profilePhotoId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotosWithResponseAsync(
        String groupId, String profilePhotoId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error(new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getPhotos(
                this.client.getEndpoint(), groupId, profilePhotoId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotosAsync(
        String groupId, String profilePhotoId, List<GroupsSelect> select, List<String> expand) {
        return getPhotosWithResponseAsync(groupId, profilePhotoId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphProfilePhotoInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotosAsync(String groupId, String profilePhotoId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getPhotosWithResponseAsync(groupId, profilePhotoId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphProfilePhotoInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphProfilePhotoInner getPhotos(String groupId, String profilePhotoId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getPhotosAsync(groupId, profilePhotoId, select, expand).block();
    }

    /**
     * Get photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphProfilePhotoInner> getPhotosWithResponse(
        String groupId, String profilePhotoId, List<GroupsSelect> select, List<String> expand, Context context) {
        return getPhotosWithResponseAsync(groupId, profilePhotoId, select, expand, context).block();
    }

    /**
     * Update the navigation property photos in groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updatePhotosWithResponseAsync(
        String groupId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error(new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.updatePhotos(this.client.getEndpoint(), groupId, profilePhotoId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property photos in groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updatePhotosWithResponseAsync(
        String groupId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error(new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updatePhotos(this.client.getEndpoint(), groupId, profilePhotoId, body, accept, context);
    }

    /**
     * Update the navigation property photos in groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updatePhotosAsync(String groupId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body) {
        return updatePhotosWithResponseAsync(groupId, profilePhotoId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property photos in groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updatePhotos(String groupId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body) {
        updatePhotosAsync(groupId, profilePhotoId, body).block();
    }

    /**
     * Update the navigation property photos in groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updatePhotosWithResponse(
        String groupId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body, Context context) {
        return updatePhotosWithResponseAsync(groupId, profilePhotoId, body, context).block();
    }

    /**
     * Delete navigation property photos for groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deletePhotosWithResponseAsync(String groupId, String profilePhotoId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error(new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.deletePhotos(this.client.getEndpoint(), groupId, profilePhotoId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property photos for groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deletePhotosWithResponseAsync(
        String groupId, String profilePhotoId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error(new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deletePhotos(this.client.getEndpoint(), groupId, profilePhotoId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property photos for groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deletePhotosAsync(String groupId, String profilePhotoId, String ifMatch) {
        return deletePhotosWithResponseAsync(groupId, profilePhotoId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property photos for groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deletePhotosAsync(String groupId, String profilePhotoId) {
        final String ifMatch = null;
        return deletePhotosWithResponseAsync(groupId, profilePhotoId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property photos for groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deletePhotos(String groupId, String profilePhotoId) {
        final String ifMatch = null;
        deletePhotosAsync(groupId, profilePhotoId, ifMatch).block();
    }

    /**
     * Delete navigation property photos for groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deletePhotosWithResponse(
        String groupId, String profilePhotoId, String ifMatch, Context context) {
        return deletePhotosWithResponseAsync(groupId, profilePhotoId, ifMatch, context).block();
    }

    /**
     * Get media content for the navigation property photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return media content for the navigation property photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StreamResponse> getPhotosContentWithResponseAsync(String groupId, String profilePhotoId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error(new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        final String accept = "application/octet-stream, application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.getPhotosContent(this.client.getEndpoint(), groupId, profilePhotoId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get media content for the navigation property photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return media content for the navigation property photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StreamResponse> getPhotosContentWithResponseAsync(
        String groupId, String profilePhotoId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error(new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        final String accept = "application/octet-stream, application/json";
        context = this.client.mergeContext(context);
        return service.getPhotosContent(this.client.getEndpoint(), groupId, profilePhotoId, accept, context);
    }

    /**
     * Get media content for the navigation property photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return media content for the navigation property photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Flux<ByteBuffer> getPhotosContentAsync(String groupId, String profilePhotoId) {
        return getPhotosContentWithResponseAsync(groupId, profilePhotoId).flatMapMany(StreamResponse::getValue);
    }

    /**
     * Get media content for the navigation property photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return media content for the navigation property photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public InputStream getPhotosContent(String groupId, String profilePhotoId) {
        Iterator<ByteBufferBackedInputStream> iterator =
            getPhotosContentAsync(groupId, profilePhotoId).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration =
            new Enumeration<InputStream>() {
                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public InputStream nextElement() {
                    return iterator.next();
                }
            };
        return new SequenceInputStream(enumeration);
    }

    /**
     * Get media content for the navigation property photos from groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return media content for the navigation property photos from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StreamResponse getPhotosContentWithResponse(String groupId, String profilePhotoId, Context context) {
        return getPhotosContentWithResponseAsync(groupId, profilePhotoId, context).block();
    }

    /**
     * Update media content for the navigation property photos in groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param data New media content.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setPhotosContentWithResponseAsync(
        String groupId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error(new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error(new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .setPhotosContent(
                            this.client.getEndpoint(), groupId, profilePhotoId, data, contentLength, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update media content for the navigation property photos in groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param data New media content.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> setPhotosContentWithResponseAsync(
        String groupId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error(new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error(new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .setPhotosContent(this.client.getEndpoint(), groupId, profilePhotoId, data, contentLength, accept, context);
    }

    /**
     * Update media content for the navigation property photos in groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param data New media content.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setPhotosContentAsync(
        String groupId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength) {
        return setPhotosContentWithResponseAsync(groupId, profilePhotoId, data, contentLength)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update media content for the navigation property photos in groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param data New media content.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setPhotosContent(String groupId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength) {
        setPhotosContentAsync(groupId, profilePhotoId, data, contentLength).block();
    }

    /**
     * Update media content for the navigation property photos in groups.
     *
     * @param groupId key: id of group.
     * @param profilePhotoId key: id of profilePhoto.
     * @param data New media content.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setPhotosContentWithResponse(
        String groupId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength, Context context) {
        return setPhotosContentWithResponseAsync(groupId, profilePhotoId, data, contentLength, context).block();
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRejectedSendersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRejectedSenders(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRejectedSendersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRejectedSenders(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listRejectedSendersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listRejectedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listRejectedSendersNextSinglePageAsync(nextLink));
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listRejectedSendersAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listRejectedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listRejectedSendersNextSinglePageAsync(nextLink));
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listRejectedSendersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listRejectedSendersSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listRejectedSendersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listRejectedSenders(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listRejectedSendersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listRejectedSenders(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listRejectedSendersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> createRejectedSendersWithResponseAsync(
        String groupId, MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createRejectedSenders(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> createRejectedSendersWithResponseAsync(
        String groupId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRejectedSenders(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property to rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> createRejectedSendersAsync(
        String groupId, MicrosoftGraphDirectoryObjectInner body) {
        return createRejectedSendersWithResponseAsync(groupId, body)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner createRejectedSenders(
        String groupId, MicrosoftGraphDirectoryObjectInner body) {
        return createRejectedSendersAsync(groupId, body).block();
    }

    /**
     * Create new navigation property to rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> createRejectedSendersWithResponse(
        String groupId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        return createRejectedSendersWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getRejectedSendersWithResponseAsync(
        String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getRejectedSenders(
                            this.client.getEndpoint(),
                            groupId,
                            directoryObjectId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getRejectedSendersWithResponseAsync(
        String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getRejectedSenders(
                this.client.getEndpoint(),
                groupId,
                directoryObjectId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getRejectedSendersAsync(
        String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand) {
        return getRejectedSendersWithResponseAsync(groupId, directoryObjectId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getRejectedSendersAsync(String groupId, String directoryObjectId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getRejectedSendersWithResponseAsync(groupId, directoryObjectId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner getRejectedSenders(String groupId, String directoryObjectId) {
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return getRejectedSendersAsync(groupId, directoryObjectId, select, expand).block();
    }

    /**
     * Get rejectedSenders from groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rejectedSenders from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> getRejectedSendersWithResponse(
        String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand, Context context) {
        return getRejectedSendersWithResponseAsync(groupId, directoryObjectId, select, expand, context).block();
    }

    /**
     * Update the navigation property rejectedSenders in groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateRejectedSendersWithResponseAsync(
        String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateRejectedSenders(
                            this.client.getEndpoint(), groupId, directoryObjectId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property rejectedSenders in groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateRejectedSendersWithResponseAsync(
        String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateRejectedSenders(this.client.getEndpoint(), groupId, directoryObjectId, body, accept, context);
    }

    /**
     * Update the navigation property rejectedSenders in groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateRejectedSendersAsync(
        String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        return updateRejectedSendersWithResponseAsync(groupId, directoryObjectId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property rejectedSenders in groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateRejectedSenders(
        String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        updateRejectedSendersAsync(groupId, directoryObjectId, body).block();
    }

    /**
     * Update the navigation property rejectedSenders in groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateRejectedSendersWithResponse(
        String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        return updateRejectedSendersWithResponseAsync(groupId, directoryObjectId, body, context).block();
    }

    /**
     * Delete navigation property rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRejectedSendersWithResponseAsync(
        String groupId, String directoryObjectId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteRejectedSenders(
                            this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRejectedSendersWithResponseAsync(
        String groupId, String directoryObjectId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteRejectedSenders(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteRejectedSendersAsync(String groupId, String directoryObjectId, String ifMatch) {
        return deleteRejectedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteRejectedSendersAsync(String groupId, String directoryObjectId) {
        final String ifMatch = null;
        return deleteRejectedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteRejectedSenders(String groupId, String directoryObjectId) {
        final String ifMatch = null;
        deleteRejectedSendersAsync(groupId, directoryObjectId, ifMatch).block();
    }

    /**
     * Delete navigation property rejectedSenders for groups.
     *
     * @param groupId key: id of group.
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteRejectedSendersWithResponse(
        String groupId, String directoryObjectId, String ifMatch, Context context) {
        return deleteRejectedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch, context).block();
    }

    /**
     * Get transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listTransitiveMemberOf(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listTransitiveMemberOf(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listTransitiveMemberOfSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listTransitiveMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listTransitiveMemberOfSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listTransitiveMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listTransitiveMemberOfSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listTransitiveMemberOfNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listTransitiveMemberOfAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listTransitiveMemberOfAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefTransitiveMemberOf(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefTransitiveMemberOf(
                this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMemberOfAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefTransitiveMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefTransitiveMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefTransitiveMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefTransitiveMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefTransitiveMemberOfAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () -> listRefTransitiveMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefTransitiveMemberOfNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMemberOf(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedIterable<>(listRefTransitiveMemberOfAsync(groupId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of transitiveMemberOf from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMemberOf(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(
            listRefTransitiveMemberOfAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to transitiveMemberOf for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(
        String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.createRefTransitiveMemberOf(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to transitiveMemberOf for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(
        String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefTransitiveMemberOf(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property ref to transitiveMemberOf for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefTransitiveMemberOfAsync(String groupId, Map<String, Object> body) {
        return createRefTransitiveMemberOfWithResponseAsync(groupId, body)
            .flatMap(
                (Response<Map<String, Object>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property ref to transitiveMemberOf for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefTransitiveMemberOf(String groupId, Map<String, Object> body) {
        return createRefTransitiveMemberOfAsync(groupId, body).block();
    }

    /**
     * Create new navigation property ref to transitiveMemberOf for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefTransitiveMemberOfWithResponse(
        String groupId, Map<String, Object> body, Context context) {
        return createRefTransitiveMemberOfWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Get transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMembersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listTransitiveMembers(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMembersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listTransitiveMembers(
                this.client.getEndpoint(),
                groupId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMembersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listTransitiveMembersSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listTransitiveMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMembersAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listTransitiveMembersSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listTransitiveMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMembersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listTransitiveMembersSinglePageAsync(
                    groupId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listTransitiveMembersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMembers(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        final List<GroupsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listTransitiveMembersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMembers(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        List<GroupsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listTransitiveMembersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMembersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefTransitiveMembers(
                            this.client.getEndpoint(),
                            groupId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMembersSinglePageAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefTransitiveMembers(
                this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMembersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefTransitiveMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefTransitiveMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMembersAsync(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefTransitiveMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby),
            nextLink -> listRefTransitiveMembersNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefTransitiveMembersAsync(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () -> listRefTransitiveMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefTransitiveMembersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMembers(String groupId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<GroupsOrderby> orderby = null;
        return new PagedIterable<>(listRefTransitiveMembersAsync(groupId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of transitiveMembers from groups.
     *
     * @param groupId key: id of group.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMembers from groups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMembers(
        String groupId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<GroupsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(
            listRefTransitiveMembersAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to transitiveMembers for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefTransitiveMembersWithResponseAsync(
        String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.createRefTransitiveMembers(this.client.getEndpoint(), groupId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to transitiveMembers for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefTransitiveMembersWithResponseAsync(
        String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefTransitiveMembers(this.client.getEndpoint(), groupId, body, accept, context);
    }

    /**
     * Create new navigation property ref to transitiveMembers for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefTransitiveMembersAsync(String groupId, Map<String, Object> body) {
        return createRefTransitiveMembersWithResponseAsync(groupId, body)
            .flatMap(
                (Response<Map<String, Object>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property ref to transitiveMembers for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefTransitiveMembers(String groupId, Map<String, Object> body) {
        return createRefTransitiveMembersAsync(groupId, body).block();
    }

    /**
     * Create new navigation property ref to transitiveMembers for groups.
     *
     * @param groupId key: id of group.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefTransitiveMembersWithResponse(
        String groupId, Map<String, Object> body, Context context) {
        return createRefTransitiveMembersWithResponseAsync(groupId, body, context).block();
    }

    /**
     * Invoke function delta.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphGroupInner>>> deltaWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delta(this.client.getEndpoint(), accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke function delta.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphGroupInner>>> deltaWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delta(this.client.getEndpoint(), accept, context);
    }

    /**
     * Invoke function delta.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphGroupInner>> deltaAsync() {
        return deltaWithResponseAsync()
            .flatMap(
                (Response<List<MicrosoftGraphGroupInner>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke function delta.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<MicrosoftGraphGroupInner> delta() {
        return deltaAsync().block();
    }

    /**
     * Invoke function delta.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<MicrosoftGraphGroupInner>> deltaWithResponse(Context context) {
        return deltaWithResponseAsync(context).block();
    }

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(
        GroupsGetAvailableExtensionPropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getAvailableExtensionProperties(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(
        GroupsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAvailableExtensionProperties(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(
        GroupsGetAvailableExtensionPropertiesRequestBody body) {
        return getAvailableExtensionPropertiesWithResponseAsync(body)
            .flatMap(
                (Response<List<MicrosoftGraphExtensionPropertyInner>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(
        GroupsGetAvailableExtensionPropertiesRequestBody body) {
        return getAvailableExtensionPropertiesAsync(body).block();
    }

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(
        GroupsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        return getAvailableExtensionPropertiesWithResponseAsync(body, context).block();
    }

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(
        GroupsGetByIdsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getByIds(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(
        GroupsGetByIdsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByIds(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(GroupsGetByIdsRequestBody body) {
        return getByIdsWithResponseAsync(body)
            .flatMap(
                (Response<List<MicrosoftGraphDirectoryObjectInner>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<MicrosoftGraphDirectoryObjectInner> getByIds(GroupsGetByIdsRequestBody body) {
        return getByIdsAsync(body).block();
    }

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(
        GroupsGetByIdsRequestBody body, Context context) {
        return getByIdsWithResponseAsync(body, context).block();
    }

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(GroupsValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateProperties(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> validatePropertiesWithResponseAsync(
        GroupsValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateProperties(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> validatePropertiesAsync(GroupsValidatePropertiesRequestBody body) {
        return validatePropertiesWithResponseAsync(body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateProperties(GroupsValidatePropertiesRequestBody body) {
        validatePropertiesAsync(body).block();
    }

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> validatePropertiesWithResponse(GroupsValidatePropertiesRequestBody body, Context context) {
        return validatePropertiesWithResponseAsync(body, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of appRoleAssignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of appRoleAssignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listAcceptedSendersNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listAcceptedSendersNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listAcceptedSendersNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listAcceptedSendersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listExtensionsNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphExtensionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listExtensionsNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMemberOfNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMemberOfNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefMemberOfNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefMemberOfNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMembersNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMembersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefMembersNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefMembersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersWithLicenseErrorsNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMembersWithLicenseErrorsNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersWithLicenseErrorsNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMembersWithLicenseErrorsNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersWithLicenseErrorsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefMembersWithLicenseErrorsNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersWithLicenseErrorsNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefMembersWithLicenseErrorsNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listOwnersNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listOwnersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefOwnersNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefOwnersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of resourceSpecificPermissionGrant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphResourceSpecificPermissionGrantInner>>
        listPermissionGrantsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listPermissionGrantsNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphResourceSpecificPermissionGrantInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of resourceSpecificPermissionGrant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphResourceSpecificPermissionGrantInner>>
        listPermissionGrantsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listPermissionGrantsNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of profilePhoto.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listPhotosNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphProfilePhotoInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of profilePhoto.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listPhotosNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRejectedSendersNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRejectedSendersNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRejectedSendersNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRejectedSendersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listTransitiveMemberOfNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listTransitiveMemberOfNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefTransitiveMemberOfNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefTransitiveMemberOfNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMembersNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listTransitiveMembersNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMembersNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listTransitiveMembersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefTransitiveMembersNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefTransitiveMembersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
