// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.GalleryImagesClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryImageInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryImageList;
import com.azure.resourcemanager.compute.models.GalleryImageUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in GalleryImagesClient. */
public final class GalleryImagesClientImpl implements GalleryImagesClient {
    private final ClientLogger logger = new ClientLogger(GalleryImagesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final GalleryImagesService service;

    /** The service client containing this operation class. */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of GalleryImagesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    GalleryImagesClientImpl(ComputeManagementClientImpl client) {
        this.service =
            RestProxy.create(GalleryImagesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientGalleryImages to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    private interface GalleryImagesService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries"
                + "/{galleryName}/images/{galleryImageName}")
        @ExpectedResponses({200, 201, 202})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("galleryName") String galleryName,
            @PathParam("galleryImageName") String galleryImageName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GalleryImageInner galleryImage,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries"
                + "/{galleryName}/images/{galleryImageName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("galleryName") String galleryName,
            @PathParam("galleryImageName") String galleryImageName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GalleryImageUpdate galleryImage,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries"
                + "/{galleryName}/images/{galleryImageName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryImageInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("galleryName") String galleryName,
            @PathParam("galleryImageName") String galleryImageName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries"
                + "/{galleryName}/images/{galleryImageName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("galleryName") String galleryName,
            @PathParam("galleryImageName") String galleryImageName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries"
                + "/{galleryName}/images")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryImageList>> listByGallery(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("galleryName") String galleryName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryImageList>> listByGalleryNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Create or update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
     * @param galleryImageName The name of the gallery Image Definition to be created or updated. The allowed characters
     *     are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImage == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryImage is required and cannot be null."));
        } else {
            galleryImage.validate();
        }
        final String apiVersion = "2019-12-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            galleryName,
                            galleryImageName,
                            apiVersion,
                            galleryImage,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create or update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
     * @param galleryImageName The name of the gallery Image Definition to be created or updated. The allowed characters
     *     are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryImageName,
        GalleryImageInner galleryImage,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImage == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryImage is required and cannot be null."));
        } else {
            galleryImage.validate();
        }
        final String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                galleryName,
                galleryImageName,
                apiVersion,
                galleryImage,
                context);
    }

    /**
     * Create or update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
     * @param galleryImageName The name of the gallery Image Definition to be created or updated. The allowed characters
     *     are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<GalleryImageInner>, GalleryImageInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImage);
        return this
            .client
            .<GalleryImageInner, GalleryImageInner>getLroResult(
                mono, this.client.getHttpPipeline(), GalleryImageInner.class, GalleryImageInner.class, Context.NONE);
    }

    /**
     * Create or update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
     * @param galleryImageName The name of the gallery Image Definition to be created or updated. The allowed characters
     *     are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<GalleryImageInner>, GalleryImageInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryImageName,
        GalleryImageInner galleryImage,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImage, context);
        return this
            .client
            .<GalleryImageInner, GalleryImageInner>getLroResult(
                mono, this.client.getHttpPipeline(), GalleryImageInner.class, GalleryImageInner.class, context);
    }

    /**
     * Create or update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
     * @param galleryImageName The name of the gallery Image Definition to be created or updated. The allowed characters
     *     are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GalleryImageInner>, GalleryImageInner> beginCreateOrUpdate(
        String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage).getSyncPoller();
    }

    /**
     * Create or update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
     * @param galleryImageName The name of the gallery Image Definition to be created or updated. The allowed characters
     *     are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GalleryImageInner>, GalleryImageInner> beginCreateOrUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryImageName,
        GalleryImageInner galleryImage,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage, context)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
     * @param galleryImageName The name of the gallery Image Definition to be created or updated. The allowed characters
     *     are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryImageInner> createOrUpdateAsync(
        String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
     * @param galleryImageName The name of the gallery Image Definition to be created or updated. The allowed characters
     *     are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryImageInner> createOrUpdateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryImageName,
        GalleryImageInner galleryImage,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
     * @param galleryImageName The name of the gallery Image Definition to be created or updated. The allowed characters
     *     are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryImageInner createOrUpdate(
        String resourceGroupName, String galleryName, String galleryImageName, GalleryImageInner galleryImage) {
        return createOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage).block();
    }

    /**
     * Create or update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be created.
     * @param galleryImageName The name of the gallery Image Definition to be created or updated. The allowed characters
     *     are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryImageInner createOrUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryImageName,
        GalleryImageInner galleryImage,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage, context).block();
    }

    /**
     * Update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be updated.
     * @param galleryImageName The name of the gallery Image Definition to be updated. The allowed characters are
     *     alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName, String galleryName, String galleryImageName, GalleryImageUpdate galleryImage) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImage == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryImage is required and cannot be null."));
        } else {
            galleryImage.validate();
        }
        final String apiVersion = "2019-12-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            galleryName,
                            galleryImageName,
                            apiVersion,
                            galleryImage,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be updated.
     * @param galleryImageName The name of the gallery Image Definition to be updated. The allowed characters are
     *     alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryImageName,
        GalleryImageUpdate galleryImage,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImage == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryImage is required and cannot be null."));
        } else {
            galleryImage.validate();
        }
        final String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                galleryName,
                galleryImageName,
                apiVersion,
                galleryImage,
                context);
    }

    /**
     * Update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be updated.
     * @param galleryImageName The name of the gallery Image Definition to be updated. The allowed characters are
     *     alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<GalleryImageInner>, GalleryImageInner> beginUpdateAsync(
        String resourceGroupName, String galleryName, String galleryImageName, GalleryImageUpdate galleryImage) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImage);
        return this
            .client
            .<GalleryImageInner, GalleryImageInner>getLroResult(
                mono, this.client.getHttpPipeline(), GalleryImageInner.class, GalleryImageInner.class, Context.NONE);
    }

    /**
     * Update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be updated.
     * @param galleryImageName The name of the gallery Image Definition to be updated. The allowed characters are
     *     alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<GalleryImageInner>, GalleryImageInner> beginUpdateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryImageName,
        GalleryImageUpdate galleryImage,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImage, context);
        return this
            .client
            .<GalleryImageInner, GalleryImageInner>getLroResult(
                mono, this.client.getHttpPipeline(), GalleryImageInner.class, GalleryImageInner.class, context);
    }

    /**
     * Update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be updated.
     * @param galleryImageName The name of the gallery Image Definition to be updated. The allowed characters are
     *     alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GalleryImageInner>, GalleryImageInner> beginUpdate(
        String resourceGroupName, String galleryName, String galleryImageName, GalleryImageUpdate galleryImage) {
        return beginUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage).getSyncPoller();
    }

    /**
     * Update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be updated.
     * @param galleryImageName The name of the gallery Image Definition to be updated. The allowed characters are
     *     alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GalleryImageInner>, GalleryImageInner> beginUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryImageName,
        GalleryImageUpdate galleryImage,
        Context context) {
        return beginUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage, context)
            .getSyncPoller();
    }

    /**
     * Update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be updated.
     * @param galleryImageName The name of the gallery Image Definition to be updated. The allowed characters are
     *     alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryImageInner> updateAsync(
        String resourceGroupName, String galleryName, String galleryImageName, GalleryImageUpdate galleryImage) {
        return beginUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be updated.
     * @param galleryImageName The name of the gallery Image Definition to be updated. The allowed characters are
     *     alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryImageInner> updateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryImageName,
        GalleryImageUpdate galleryImage,
        Context context) {
        return beginUpdateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be updated.
     * @param galleryImageName The name of the gallery Image Definition to be updated. The allowed characters are
     *     alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryImageInner update(
        String resourceGroupName, String galleryName, String galleryImageName, GalleryImageUpdate galleryImage) {
        return updateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage).block();
    }

    /**
     * Update a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be updated.
     * @param galleryImageName The name of the gallery Image Definition to be updated. The allowed characters are
     *     alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is 80
     *     characters.
     * @param galleryImage Specifies information about the gallery Image Definition that you want to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryImageInner update(
        String resourceGroupName,
        String galleryName,
        String galleryImageName,
        GalleryImageUpdate galleryImage,
        Context context) {
        return updateAsync(resourceGroupName, galleryName, galleryImageName, galleryImage, context).block();
    }

    /**
     * Retrieves information about a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the Image Definitions are to be retrieved.
     * @param galleryImageName The name of the gallery Image Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GalleryImageInner>> getWithResponseAsync(
        String resourceGroupName, String galleryName, String galleryImageName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            galleryName,
                            galleryImageName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Retrieves information about a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the Image Definitions are to be retrieved.
     * @param galleryImageName The name of the gallery Image Definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GalleryImageInner>> getWithResponseAsync(
        String resourceGroupName, String galleryName, String galleryImageName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                galleryName,
                galleryImageName,
                apiVersion,
                context);
    }

    /**
     * Retrieves information about a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the Image Definitions are to be retrieved.
     * @param galleryImageName The name of the gallery Image Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryImageInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        return getWithResponseAsync(resourceGroupName, galleryName, galleryImageName)
            .flatMap(
                (Response<GalleryImageInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Retrieves information about a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the Image Definitions are to be retrieved.
     * @param galleryImageName The name of the gallery Image Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryImageInner get(String resourceGroupName, String galleryName, String galleryImageName) {
        return getAsync(resourceGroupName, galleryName, galleryImageName).block();
    }

    /**
     * Retrieves information about a gallery Image Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the Image Definitions are to be retrieved.
     * @param galleryImageName The name of the gallery Image Definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Image Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GalleryImageInner> getWithResponse(
        String resourceGroupName, String galleryName, String galleryImageName, Context context) {
        return getWithResponseAsync(resourceGroupName, galleryName, galleryImageName, context).block();
    }

    /**
     * Delete a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be deleted.
     * @param galleryImageName The name of the gallery Image Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String galleryName, String galleryImageName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            galleryName,
                            galleryImageName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be deleted.
     * @param galleryImageName The name of the gallery Image Definition to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String galleryName, String galleryImageName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                galleryName,
                galleryImageName,
                apiVersion,
                context);
    }

    /**
     * Delete a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be deleted.
     * @param galleryImageName The name of the gallery Image Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String galleryName, String galleryImageName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, galleryName, galleryImageName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Delete a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be deleted.
     * @param galleryImageName The name of the gallery Image Definition to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String galleryName, String galleryImageName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, galleryName, galleryImageName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Delete a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be deleted.
     * @param galleryImageName The name of the gallery Image Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String galleryName, String galleryImageName) {
        return beginDeleteAsync(resourceGroupName, galleryName, galleryImageName).getSyncPoller();
    }

    /**
     * Delete a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be deleted.
     * @param galleryImageName The name of the gallery Image Definition to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String galleryName, String galleryImageName, Context context) {
        return beginDeleteAsync(resourceGroupName, galleryName, galleryImageName, context).getSyncPoller();
    }

    /**
     * Delete a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be deleted.
     * @param galleryImageName The name of the gallery Image Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        return beginDeleteAsync(resourceGroupName, galleryName, galleryImageName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be deleted.
     * @param galleryImageName The name of the gallery Image Definition to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName, String galleryName, String galleryImageName, Context context) {
        return beginDeleteAsync(resourceGroupName, galleryName, galleryImageName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be deleted.
     * @param galleryImageName The name of the gallery Image Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String galleryImageName) {
        deleteAsync(resourceGroupName, galleryName, galleryImageName).block();
    }

    /**
     * Delete a gallery image.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the Image Definition is to be deleted.
     * @param galleryImageName The name of the gallery Image Definition to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String galleryImageName, Context context) {
        deleteAsync(resourceGroupName, galleryName, galleryImageName, context).block();
    }

    /**
     * List gallery Image Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which Image Definitions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Images operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryImageInner>> listByGallerySinglePageAsync(
        String resourceGroupName, String galleryName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByGallery(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            galleryName,
                            apiVersion,
                            context))
            .<PagedResponse<GalleryImageInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * List gallery Image Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which Image Definitions are to be listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Images operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryImageInner>> listByGallerySinglePageAsync(
        String resourceGroupName, String galleryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return service
            .listByGallery(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                galleryName,
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * List gallery Image Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which Image Definitions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Images operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GalleryImageInner> listByGalleryAsync(String resourceGroupName, String galleryName) {
        return new PagedFlux<>(
            () -> listByGallerySinglePageAsync(resourceGroupName, galleryName),
            nextLink -> listByGalleryNextSinglePageAsync(nextLink));
    }

    /**
     * List gallery Image Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which Image Definitions are to be listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Images operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GalleryImageInner> listByGalleryAsync(
        String resourceGroupName, String galleryName, Context context) {
        return new PagedFlux<>(
            () -> listByGallerySinglePageAsync(resourceGroupName, galleryName, context),
            nextLink -> listByGalleryNextSinglePageAsync(nextLink, context));
    }

    /**
     * List gallery Image Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which Image Definitions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Images operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryImageInner> listByGallery(String resourceGroupName, String galleryName) {
        return new PagedIterable<>(listByGalleryAsync(resourceGroupName, galleryName));
    }

    /**
     * List gallery Image Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which Image Definitions are to be listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Images operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryImageInner> listByGallery(
        String resourceGroupName, String galleryName, Context context) {
        return new PagedIterable<>(listByGalleryAsync(resourceGroupName, galleryName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Images operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryImageInner>> listByGalleryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByGalleryNext(nextLink, context))
            .<PagedResponse<GalleryImageInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Images operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryImageInner>> listByGalleryNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByGalleryNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
