/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.ImageStorageProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class ImageInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImageInner.class);
    @JsonProperty(value="properties.sourceVirtualMachine")
    private SubResource sourceVirtualMachine;
    @JsonProperty(value="properties.storageProfile")
    private ImageStorageProfile storageProfile;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.hyperVGeneration")
    private HyperVGenerationTypes hyperVGeneration;

    public SubResource sourceVirtualMachine() {
        return this.sourceVirtualMachine;
    }

    public ImageInner withSourceVirtualMachine(SubResource sourceVirtualMachine) {
        this.sourceVirtualMachine = sourceVirtualMachine;
        return this;
    }

    public ImageStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public ImageInner withStorageProfile(ImageStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public ImageInner withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public void validate() {
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }
}

