/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CreationData;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.SnapshotSku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonFlatten
public class SnapshotInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SnapshotInner.class);
    @JsonProperty(value="managedBy", access=JsonProperty.Access.WRITE_ONLY)
    private String managedBy;
    @JsonProperty(value="sku")
    private SnapshotSku sku;
    @JsonProperty(value="properties.timeCreated", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;
    @JsonProperty(value="properties.osType")
    private OperatingSystemTypes osType;
    @JsonProperty(value="properties.hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="properties.creationData")
    private CreationData creationData;
    @JsonProperty(value="properties.diskSizeGB")
    private Integer diskSizeGB;
    @JsonProperty(value="properties.diskSizeBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long diskSizeBytes;
    @JsonProperty(value="properties.uniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String uniqueId;
    @JsonProperty(value="properties.encryptionSettingsCollection")
    private EncryptionSettingsCollection encryptionSettingsCollection;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.incremental")
    private Boolean incremental;
    @JsonProperty(value="properties.encryption")
    private Encryption encryption;

    public String managedBy() {
        return this.managedBy;
    }

    public SnapshotSku sku() {
        return this.sku;
    }

    public SnapshotInner withSku(SnapshotSku sku) {
        this.sku = sku;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public SnapshotInner withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public SnapshotInner withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public CreationData creationData() {
        return this.creationData;
    }

    public SnapshotInner withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public SnapshotInner withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public Long diskSizeBytes() {
        return this.diskSizeBytes;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    public SnapshotInner withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Boolean incremental() {
        return this.incremental;
    }

    public SnapshotInner withIncremental(Boolean incremental) {
        this.incremental = incremental;
        return this;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public SnapshotInner withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.creationData() != null) {
            this.creationData().validate();
        }
        if (this.encryptionSettingsCollection() != null) {
            this.encryptionSettingsCollection().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }
}

