/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.compute.fluent.VirtualMachineExtensionImagesClient;
import com.azure.resourcemanager.compute.fluent.VirtualMachineImagesClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.azure.resourcemanager.compute.implementation.VirtualMachinePublisherImpl;
import com.azure.resourcemanager.compute.models.VirtualMachinePublisher;
import com.azure.resourcemanager.compute.models.VirtualMachinePublishers;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;

public class VirtualMachinePublishersImpl
extends ReadableWrappersImpl<VirtualMachinePublisher, VirtualMachinePublisherImpl, VirtualMachineImageResourceInner>
implements VirtualMachinePublishers {
    private final VirtualMachineImagesClient imagesClientCollection;
    private final VirtualMachineExtensionImagesClient extensionsInnerCollection;

    public VirtualMachinePublishersImpl(VirtualMachineImagesClient imagesClientCollection, VirtualMachineExtensionImagesClient extensionsInnerCollection) {
        this.imagesClientCollection = imagesClientCollection;
        this.extensionsInnerCollection = extensionsInnerCollection;
    }

    public PagedIterable<VirtualMachinePublisher> listByRegion(Region region) {
        return this.listByRegion(region.toString());
    }

    protected VirtualMachinePublisherImpl wrapModel(VirtualMachineImageResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return new VirtualMachinePublisherImpl(Region.fromName((String)inner.location()), inner.name(), this.imagesClientCollection, this.extensionsInnerCollection);
    }

    public PagedIterable<VirtualMachinePublisher> listByRegion(String regionName) {
        return new PagedIterable(this.listByRegionAsync(regionName));
    }

    public PagedFlux<VirtualMachinePublisher> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    public PagedFlux<VirtualMachinePublisher> listByRegionAsync(String regionName) {
        return PagedConverter.convertListToPagedFlux(this.imagesClientCollection.listPublishersWithResponseAsync(regionName)).mapPage(this::wrapModel);
    }
}

