/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.VirtualMachineScaleSetsClient;
import com.azure.resourcemanager.compute.fluent.models.RecoveryWalkResponseInner;
import com.azure.resourcemanager.compute.fluent.models.UpgradeOperationHistoricalStatusInfoInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetInstanceViewInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetSkuInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.OrchestrationServiceStateInput;
import com.azure.resourcemanager.compute.models.VMScaleSetConvertToSinglePlacementGroupInput;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetListOSUpgradeHistory;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetListResult;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetListSkusResult;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetListWithLinkResult;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetReimageParameters;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetUpdate;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMInstanceIDs;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMInstanceRequiredIDs;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VirtualMachineScaleSetsClientImpl
implements InnerSupportsGet<VirtualMachineScaleSetInner>,
InnerSupportsListing<VirtualMachineScaleSetInner>,
InnerSupportsDelete<Void>,
VirtualMachineScaleSetsClient {
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetsClientImpl.class);
    private final VirtualMachineScaleSetsService service;
    private final ComputeManagementClientImpl client;

    VirtualMachineScaleSetsClientImpl(ComputeManagementClientImpl client) {
        this.service = (VirtualMachineScaleSetsService)RestProxy.create(VirtualMachineScaleSetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public PollerFlux<PollResult<VirtualMachineScaleSetInner>, VirtualMachineScaleSetInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, vmScaleSetName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineScaleSetInner.class), (Type)((Object)VirtualMachineScaleSetInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<VirtualMachineScaleSetInner>, VirtualMachineScaleSetInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, vmScaleSetName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineScaleSetInner.class), (Type)((Object)VirtualMachineScaleSetInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<VirtualMachineScaleSetInner>, VirtualMachineScaleSetInner> beginCreateOrUpdate(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<VirtualMachineScaleSetInner>, VirtualMachineScaleSetInner> beginCreateOrUpdate(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<VirtualMachineScaleSetInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<VirtualMachineScaleSetInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public VirtualMachineScaleSetInner createOrUpdate(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetInner parameters) {
        return (VirtualMachineScaleSetInner)((Object)this.createOrUpdateAsync(resourceGroupName, vmScaleSetName, parameters).block());
    }

    @Override
    public VirtualMachineScaleSetInner createOrUpdate(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetInner parameters, Context context) {
        return (VirtualMachineScaleSetInner)((Object)this.createOrUpdateAsync(resourceGroupName, vmScaleSetName, parameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetUpdate parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public PollerFlux<PollResult<VirtualMachineScaleSetInner>, VirtualMachineScaleSetInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetUpdate parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, vmScaleSetName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineScaleSetInner.class), (Type)((Object)VirtualMachineScaleSetInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<VirtualMachineScaleSetInner>, VirtualMachineScaleSetInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetUpdate parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, vmScaleSetName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineScaleSetInner.class), (Type)((Object)VirtualMachineScaleSetInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<VirtualMachineScaleSetInner>, VirtualMachineScaleSetInner> beginUpdate(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<VirtualMachineScaleSetInner>, VirtualMachineScaleSetInner> beginUpdate(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetUpdate parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<VirtualMachineScaleSetInner> updateAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<VirtualMachineScaleSetInner> updateAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetUpdate parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public VirtualMachineScaleSetInner update(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetUpdate parameters) {
        return (VirtualMachineScaleSetInner)((Object)this.updateAsync(resourceGroupName, vmScaleSetName, parameters).block());
    }

    @Override
    public VirtualMachineScaleSetInner update(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetUpdate parameters, Context context) {
        return (VirtualMachineScaleSetInner)((Object)this.updateAsync(resourceGroupName, vmScaleSetName, parameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmScaleSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmScaleSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, vmScaleSetName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, vmScaleSetName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmScaleSetName) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmScaleSetName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String vmScaleSetName) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String vmScaleSetName) {
        this.deleteAsync(resourceGroupName, vmScaleSetName).block();
    }

    @Override
    public void delete(String resourceGroupName, String vmScaleSetName, Context context) {
        this.deleteAsync(resourceGroupName, vmScaleSetName, context).block();
    }

    @Override
    public Mono<Response<VirtualMachineScaleSetInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String vmScaleSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<VirtualMachineScaleSetInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String vmScaleSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<VirtualMachineScaleSetInner> getByResourceGroupAsync(String resourceGroupName, String vmScaleSetName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, vmScaleSetName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((VirtualMachineScaleSetInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public VirtualMachineScaleSetInner getByResourceGroup(String resourceGroupName, String vmScaleSetName) {
        return (VirtualMachineScaleSetInner)((Object)this.getByResourceGroupAsync(resourceGroupName, vmScaleSetName).block());
    }

    @Override
    public Response<VirtualMachineScaleSetInner> getByResourceGroupWithResponse(String resourceGroupName, String vmScaleSetName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, vmScaleSetName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deallocateWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        return FluxUtil.withContext(context -> this.service.deallocate(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deallocateWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        context = this.client.mergeContext(context);
        return this.service.deallocate(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeallocateAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deallocateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeallocateAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deallocateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeallocate(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginDeallocateAsync(resourceGroupName, vmScaleSetName, instanceIds).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeallocate(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginDeallocateAsync(resourceGroupName, vmScaleSetName, instanceIds, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deallocateAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginDeallocateAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deallocateAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginDeallocateAsync(resourceGroupName, vmScaleSetName, instanceIds, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> deallocateAsync(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        return this.beginDeallocateAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deallocate(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        this.deallocateAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public void deallocate(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        this.deallocateAsync(resourceGroupName, vmScaleSetName, instanceIds, context).block();
    }

    @Override
    public void deallocate(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        this.deallocateAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteInstancesWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (instanceIds == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceIds is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceRequiredIDs vmInstanceIDs = new VirtualMachineScaleSetVMInstanceRequiredIDs();
        vmInstanceIDs.withInstanceIds(instanceIds);
        return FluxUtil.withContext(context -> this.service.deleteInstances(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteInstancesWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (instanceIds == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceIds is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceRequiredIDs vmInstanceIDs = new VirtualMachineScaleSetVMInstanceRequiredIDs();
        vmInstanceIDs.withInstanceIds(instanceIds);
        context = this.client.mergeContext(context);
        return this.service.deleteInstances(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteInstancesAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteInstancesWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteInstancesAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteInstancesWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteInstances(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginDeleteInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteInstances(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginDeleteInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteInstancesAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginDeleteInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteInstancesAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginDeleteInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteInstances(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        this.deleteInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public void deleteInstances(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        this.deleteInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds, context).block();
    }

    @Override
    public Mono<Response<VirtualMachineScaleSetInstanceViewInner>> getInstanceViewWithResponseAsync(String resourceGroupName, String vmScaleSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.getInstanceView(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<VirtualMachineScaleSetInstanceViewInner>> getInstanceViewWithResponseAsync(String resourceGroupName, String vmScaleSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.getInstanceView(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<VirtualMachineScaleSetInstanceViewInner> getInstanceViewAsync(String resourceGroupName, String vmScaleSetName) {
        return this.getInstanceViewWithResponseAsync(resourceGroupName, vmScaleSetName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((VirtualMachineScaleSetInstanceViewInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public VirtualMachineScaleSetInstanceViewInner getInstanceView(String resourceGroupName, String vmScaleSetName) {
        return (VirtualMachineScaleSetInstanceViewInner)this.getInstanceViewAsync(resourceGroupName, vmScaleSetName).block();
    }

    @Override
    public Response<VirtualMachineScaleSetInstanceViewInner> getInstanceViewWithResponse(String resourceGroupName, String vmScaleSetName, Context context) {
        return (Response)this.getInstanceViewWithResponseAsync(resourceGroupName, vmScaleSetName, context).block();
    }

    private Mono<PagedResponse<VirtualMachineScaleSetInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListResult)res.getValue()).value(), ((VirtualMachineScaleSetListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, "2019-12-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListResult)res.getValue()).value(), ((VirtualMachineScaleSetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<VirtualMachineScaleSetInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<VirtualMachineScaleSetInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-12-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListWithLinkResult)res.getValue()).value(), ((VirtualMachineScaleSetListWithLinkResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-12-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListWithLinkResult)res.getValue()).value(), ((VirtualMachineScaleSetListWithLinkResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<VirtualMachineScaleSetInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listAllNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<VirtualMachineScaleSetInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listAllNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetSkuInner>> listSkusSinglePageAsync(String resourceGroupName, String vmScaleSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.listSkus(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListSkusResult)res.getValue()).value(), ((VirtualMachineScaleSetListSkusResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetSkuInner>> listSkusSinglePageAsync(String resourceGroupName, String vmScaleSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.listSkus(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListSkusResult)res.getValue()).value(), ((VirtualMachineScaleSetListSkusResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<VirtualMachineScaleSetSkuInner> listSkusAsync(String resourceGroupName, String vmScaleSetName) {
        return new PagedFlux(() -> this.listSkusSinglePageAsync(resourceGroupName, vmScaleSetName), nextLink -> this.listSkusNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<VirtualMachineScaleSetSkuInner> listSkusAsync(String resourceGroupName, String vmScaleSetName, Context context) {
        return new PagedFlux(() -> this.listSkusSinglePageAsync(resourceGroupName, vmScaleSetName, context), nextLink -> this.listSkusNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetSkuInner> listSkus(String resourceGroupName, String vmScaleSetName) {
        return new PagedIterable(this.listSkusAsync(resourceGroupName, vmScaleSetName));
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetSkuInner> listSkus(String resourceGroupName, String vmScaleSetName, Context context) {
        return new PagedIterable(this.listSkusAsync(resourceGroupName, vmScaleSetName, context));
    }

    private Mono<PagedResponse<UpgradeOperationHistoricalStatusInfoInner>> getOSUpgradeHistorySinglePageAsync(String resourceGroupName, String vmScaleSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.getOSUpgradeHistory(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListOSUpgradeHistory)res.getValue()).value(), ((VirtualMachineScaleSetListOSUpgradeHistory)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<UpgradeOperationHistoricalStatusInfoInner>> getOSUpgradeHistorySinglePageAsync(String resourceGroupName, String vmScaleSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.getOSUpgradeHistory(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListOSUpgradeHistory)res.getValue()).value(), ((VirtualMachineScaleSetListOSUpgradeHistory)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<UpgradeOperationHistoricalStatusInfoInner> getOSUpgradeHistoryAsync(String resourceGroupName, String vmScaleSetName) {
        return new PagedFlux(() -> this.getOSUpgradeHistorySinglePageAsync(resourceGroupName, vmScaleSetName), nextLink -> this.getOSUpgradeHistoryNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<UpgradeOperationHistoricalStatusInfoInner> getOSUpgradeHistoryAsync(String resourceGroupName, String vmScaleSetName, Context context) {
        return new PagedFlux(() -> this.getOSUpgradeHistorySinglePageAsync(resourceGroupName, vmScaleSetName, context), nextLink -> this.getOSUpgradeHistoryNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<UpgradeOperationHistoricalStatusInfoInner> getOSUpgradeHistory(String resourceGroupName, String vmScaleSetName) {
        return new PagedIterable(this.getOSUpgradeHistoryAsync(resourceGroupName, vmScaleSetName));
    }

    @Override
    public PagedIterable<UpgradeOperationHistoricalStatusInfoInner> getOSUpgradeHistory(String resourceGroupName, String vmScaleSetName, Context context) {
        return new PagedIterable(this.getOSUpgradeHistoryAsync(resourceGroupName, vmScaleSetName, context));
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String vmScaleSetName, Boolean skipShutdown, List<String> instanceIds) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        return FluxUtil.withContext(context -> this.service.powerOff(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, skipShutdown, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String vmScaleSetName, Boolean skipShutdown, List<String> instanceIds, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        context = this.client.mergeContext(context);
        return this.service.powerOff(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, skipShutdown, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginPowerOffAsync(String resourceGroupName, String vmScaleSetName, Boolean skipShutdown, List<String> instanceIds) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, vmScaleSetName, skipShutdown, instanceIds);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginPowerOffAsync(String resourceGroupName, String vmScaleSetName, Boolean skipShutdown, List<String> instanceIds, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, vmScaleSetName, skipShutdown, instanceIds, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginPowerOff(String resourceGroupName, String vmScaleSetName, Boolean skipShutdown, List<String> instanceIds) {
        return this.beginPowerOffAsync(resourceGroupName, vmScaleSetName, skipShutdown, instanceIds).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginPowerOff(String resourceGroupName, String vmScaleSetName, Boolean skipShutdown, List<String> instanceIds, Context context) {
        return this.beginPowerOffAsync(resourceGroupName, vmScaleSetName, skipShutdown, instanceIds, context).getSyncPoller();
    }

    @Override
    public Mono<Void> powerOffAsync(String resourceGroupName, String vmScaleSetName, Boolean skipShutdown, List<String> instanceIds) {
        return this.beginPowerOffAsync(resourceGroupName, vmScaleSetName, skipShutdown, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> powerOffAsync(String resourceGroupName, String vmScaleSetName, Boolean skipShutdown, List<String> instanceIds, Context context) {
        return this.beginPowerOffAsync(resourceGroupName, vmScaleSetName, skipShutdown, instanceIds, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> powerOffAsync(String resourceGroupName, String vmScaleSetName) {
        Boolean skipShutdown = null;
        List<String> instanceIds = null;
        return this.beginPowerOffAsync(resourceGroupName, vmScaleSetName, skipShutdown, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void powerOff(String resourceGroupName, String vmScaleSetName, Boolean skipShutdown, List<String> instanceIds) {
        this.powerOffAsync(resourceGroupName, vmScaleSetName, skipShutdown, instanceIds).block();
    }

    @Override
    public void powerOff(String resourceGroupName, String vmScaleSetName, Boolean skipShutdown, List<String> instanceIds, Context context) {
        this.powerOffAsync(resourceGroupName, vmScaleSetName, skipShutdown, instanceIds, context).block();
    }

    @Override
    public void powerOff(String resourceGroupName, String vmScaleSetName) {
        Boolean skipShutdown = null;
        List<String> instanceIds = null;
        this.powerOffAsync(resourceGroupName, vmScaleSetName, skipShutdown, instanceIds).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        return FluxUtil.withContext(context -> this.service.restart(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        context = this.client.mergeContext(context);
        return this.service.restart(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginRestartAsync(resourceGroupName, vmScaleSetName, instanceIds).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginRestartAsync(resourceGroupName, vmScaleSetName, instanceIds, context).getSyncPoller();
    }

    @Override
    public Mono<Void> restartAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginRestartAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> restartAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginRestartAsync(resourceGroupName, vmScaleSetName, instanceIds, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> restartAsync(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        return this.beginRestartAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void restart(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        this.restartAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public void restart(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        this.restartAsync(resourceGroupName, vmScaleSetName, instanceIds, context).block();
    }

    @Override
    public void restart(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        this.restartAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginStartAsync(resourceGroupName, vmScaleSetName, instanceIds).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginStartAsync(resourceGroupName, vmScaleSetName, instanceIds, context).getSyncPoller();
    }

    @Override
    public Mono<Void> startAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginStartAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> startAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginStartAsync(resourceGroupName, vmScaleSetName, instanceIds, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> startAsync(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        return this.beginStartAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void start(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        this.startAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public void start(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        this.startAsync(resourceGroupName, vmScaleSetName, instanceIds, context).block();
    }

    @Override
    public void start(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        this.startAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> redeployWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        return FluxUtil.withContext(context -> this.service.redeploy(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> redeployWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        context = this.client.mergeContext(context);
        return this.service.redeploy(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginRedeployAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.redeployWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginRedeployAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.redeployWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRedeploy(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginRedeployAsync(resourceGroupName, vmScaleSetName, instanceIds).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRedeploy(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginRedeployAsync(resourceGroupName, vmScaleSetName, instanceIds, context).getSyncPoller();
    }

    @Override
    public Mono<Void> redeployAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginRedeployAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> redeployAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginRedeployAsync(resourceGroupName, vmScaleSetName, instanceIds, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> redeployAsync(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        return this.beginRedeployAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void redeploy(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        this.redeployAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public void redeploy(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        this.redeployAsync(resourceGroupName, vmScaleSetName, instanceIds, context).block();
    }

    @Override
    public void redeploy(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        this.redeployAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> performMaintenanceWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        return FluxUtil.withContext(context -> this.service.performMaintenance(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> performMaintenanceWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        context = this.client.mergeContext(context);
        return this.service.performMaintenance(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginPerformMaintenanceAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.performMaintenanceWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginPerformMaintenanceAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.performMaintenanceWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginPerformMaintenance(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceIds).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginPerformMaintenance(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceIds, context).getSyncPoller();
    }

    @Override
    public Mono<Void> performMaintenanceAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> performMaintenanceAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceIds, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> performMaintenanceAsync(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void performMaintenance(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        this.performMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public void performMaintenance(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        this.performMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceIds, context).block();
    }

    @Override
    public void performMaintenance(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        this.performMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateInstancesWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (instanceIds == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceIds is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceRequiredIDs vmInstanceIDs = new VirtualMachineScaleSetVMInstanceRequiredIDs();
        vmInstanceIDs.withInstanceIds(instanceIds);
        return FluxUtil.withContext(context -> this.service.updateInstances(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateInstancesWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (instanceIds == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceIds is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceRequiredIDs vmInstanceIDs = new VirtualMachineScaleSetVMInstanceRequiredIDs();
        vmInstanceIDs.withInstanceIds(instanceIds);
        context = this.client.mergeContext(context);
        return this.service.updateInstances(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginUpdateInstancesAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateInstancesWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginUpdateInstancesAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateInstancesWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginUpdateInstances(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginUpdateInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginUpdateInstances(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginUpdateInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds, context).getSyncPoller();
    }

    @Override
    public Mono<Void> updateInstancesAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginUpdateInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> updateInstancesAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginUpdateInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void updateInstances(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        this.updateInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public void updateInstances(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        this.updateInstancesAsync(resourceGroupName, vmScaleSetName, instanceIds, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (vmScaleSetReimageInput != null) {
            vmScaleSetReimageInput.validate();
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.reimage(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmScaleSetReimageInput, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (vmScaleSetReimageInput != null) {
            vmScaleSetReimageInput.validate();
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.reimage(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmScaleSetReimageInput, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginReimageAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, vmScaleSetName, vmScaleSetReimageInput);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginReimageAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, vmScaleSetName, vmScaleSetReimageInput, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginReimage(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput) {
        return this.beginReimageAsync(resourceGroupName, vmScaleSetName, vmScaleSetReimageInput).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginReimage(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput, Context context) {
        return this.beginReimageAsync(resourceGroupName, vmScaleSetName, vmScaleSetReimageInput, context).getSyncPoller();
    }

    @Override
    public Mono<Void> reimageAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput) {
        return this.beginReimageAsync(resourceGroupName, vmScaleSetName, vmScaleSetReimageInput).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> reimageAsync(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput, Context context) {
        return this.beginReimageAsync(resourceGroupName, vmScaleSetName, vmScaleSetReimageInput, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> reimageAsync(String resourceGroupName, String vmScaleSetName) {
        VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput = null;
        return this.beginReimageAsync(resourceGroupName, vmScaleSetName, vmScaleSetReimageInput).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void reimage(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput) {
        this.reimageAsync(resourceGroupName, vmScaleSetName, vmScaleSetReimageInput).block();
    }

    @Override
    public void reimage(String resourceGroupName, String vmScaleSetName, VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput, Context context) {
        this.reimageAsync(resourceGroupName, vmScaleSetName, vmScaleSetReimageInput, context).block();
    }

    @Override
    public void reimage(String resourceGroupName, String vmScaleSetName) {
        VirtualMachineScaleSetReimageParameters vmScaleSetReimageInput = null;
        this.reimageAsync(resourceGroupName, vmScaleSetName, vmScaleSetReimageInput).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> reimageAllWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        return FluxUtil.withContext(context -> this.service.reimageAll(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> reimageAllWithResponseAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDsInternal = null;
        if (instanceIds != null) {
            vmInstanceIDsInternal = new VirtualMachineScaleSetVMInstanceIDs();
            vmInstanceIDsInternal.withInstanceIds(instanceIds);
        }
        VirtualMachineScaleSetVMInstanceIDs vmInstanceIDs = vmInstanceIDsInternal;
        context = this.client.mergeContext(context);
        return this.service.reimageAll(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), vmInstanceIDs, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginReimageAllAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageAllWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginReimageAllAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageAllWithResponseAsync(resourceGroupName, vmScaleSetName, instanceIds, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginReimageAll(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginReimageAllAsync(resourceGroupName, vmScaleSetName, instanceIds).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginReimageAll(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginReimageAllAsync(resourceGroupName, vmScaleSetName, instanceIds, context).getSyncPoller();
    }

    @Override
    public Mono<Void> reimageAllAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        return this.beginReimageAllAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> reimageAllAsync(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        return this.beginReimageAllAsync(resourceGroupName, vmScaleSetName, instanceIds, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> reimageAllAsync(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        return this.beginReimageAllAsync(resourceGroupName, vmScaleSetName, instanceIds).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void reimageAll(String resourceGroupName, String vmScaleSetName, List<String> instanceIds) {
        this.reimageAllAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public void reimageAll(String resourceGroupName, String vmScaleSetName, List<String> instanceIds, Context context) {
        this.reimageAllAsync(resourceGroupName, vmScaleSetName, instanceIds, context).block();
    }

    @Override
    public void reimageAll(String resourceGroupName, String vmScaleSetName) {
        List<String> instanceIds = null;
        this.reimageAllAsync(resourceGroupName, vmScaleSetName, instanceIds).block();
    }

    @Override
    public Mono<Response<RecoveryWalkResponseInner>> forceRecoveryServiceFabricPlatformUpdateDomainWalkWithResponseAsync(String resourceGroupName, String vmScaleSetName, int platformUpdateDomain) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.forceRecoveryServiceFabricPlatformUpdateDomainWalk(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), platformUpdateDomain, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RecoveryWalkResponseInner>> forceRecoveryServiceFabricPlatformUpdateDomainWalkWithResponseAsync(String resourceGroupName, String vmScaleSetName, int platformUpdateDomain, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.forceRecoveryServiceFabricPlatformUpdateDomainWalk(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), platformUpdateDomain, context);
    }

    @Override
    public Mono<RecoveryWalkResponseInner> forceRecoveryServiceFabricPlatformUpdateDomainWalkAsync(String resourceGroupName, String vmScaleSetName, int platformUpdateDomain) {
        return this.forceRecoveryServiceFabricPlatformUpdateDomainWalkWithResponseAsync(resourceGroupName, vmScaleSetName, platformUpdateDomain).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RecoveryWalkResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public RecoveryWalkResponseInner forceRecoveryServiceFabricPlatformUpdateDomainWalk(String resourceGroupName, String vmScaleSetName, int platformUpdateDomain) {
        return (RecoveryWalkResponseInner)this.forceRecoveryServiceFabricPlatformUpdateDomainWalkAsync(resourceGroupName, vmScaleSetName, platformUpdateDomain).block();
    }

    @Override
    public Response<RecoveryWalkResponseInner> forceRecoveryServiceFabricPlatformUpdateDomainWalkWithResponse(String resourceGroupName, String vmScaleSetName, int platformUpdateDomain, Context context) {
        return (Response)this.forceRecoveryServiceFabricPlatformUpdateDomainWalkWithResponseAsync(resourceGroupName, vmScaleSetName, platformUpdateDomain, context).block();
    }

    @Override
    public Mono<Response<Void>> convertToSinglePlacementGroupWithResponseAsync(String resourceGroupName, String vmScaleSetName, String activePlacementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VMScaleSetConvertToSinglePlacementGroupInput parameters = new VMScaleSetConvertToSinglePlacementGroupInput();
        parameters.withActivePlacementGroupId(activePlacementGroupId);
        return FluxUtil.withContext(context -> this.service.convertToSinglePlacementGroup(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> convertToSinglePlacementGroupWithResponseAsync(String resourceGroupName, String vmScaleSetName, String activePlacementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VMScaleSetConvertToSinglePlacementGroupInput parameters = new VMScaleSetConvertToSinglePlacementGroupInput();
        parameters.withActivePlacementGroupId(activePlacementGroupId);
        context = this.client.mergeContext(context);
        return this.service.convertToSinglePlacementGroup(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<Void> convertToSinglePlacementGroupAsync(String resourceGroupName, String vmScaleSetName, String activePlacementGroupId) {
        return this.convertToSinglePlacementGroupWithResponseAsync(resourceGroupName, vmScaleSetName, activePlacementGroupId).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> convertToSinglePlacementGroupAsync(String resourceGroupName, String vmScaleSetName) {
        String activePlacementGroupId = null;
        return this.convertToSinglePlacementGroupWithResponseAsync(resourceGroupName, vmScaleSetName, activePlacementGroupId).flatMap(res -> Mono.empty());
    }

    @Override
    public void convertToSinglePlacementGroup(String resourceGroupName, String vmScaleSetName) {
        String activePlacementGroupId = null;
        this.convertToSinglePlacementGroupAsync(resourceGroupName, vmScaleSetName, activePlacementGroupId).block();
    }

    @Override
    public Response<Void> convertToSinglePlacementGroupWithResponse(String resourceGroupName, String vmScaleSetName, String activePlacementGroupId, Context context) {
        return (Response)this.convertToSinglePlacementGroupWithResponseAsync(resourceGroupName, vmScaleSetName, activePlacementGroupId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> setOrchestrationServiceStateWithResponseAsync(String resourceGroupName, String vmScaleSetName, OrchestrationServiceStateInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.setOrchestrationServiceState(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> setOrchestrationServiceStateWithResponseAsync(String resourceGroupName, String vmScaleSetName, OrchestrationServiceStateInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.setOrchestrationServiceState(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, "2019-12-01", this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginSetOrchestrationServiceStateAsync(String resourceGroupName, String vmScaleSetName, OrchestrationServiceStateInput parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.setOrchestrationServiceStateWithResponseAsync(resourceGroupName, vmScaleSetName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginSetOrchestrationServiceStateAsync(String resourceGroupName, String vmScaleSetName, OrchestrationServiceStateInput parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.setOrchestrationServiceStateWithResponseAsync(resourceGroupName, vmScaleSetName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginSetOrchestrationServiceState(String resourceGroupName, String vmScaleSetName, OrchestrationServiceStateInput parameters) {
        return this.beginSetOrchestrationServiceStateAsync(resourceGroupName, vmScaleSetName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginSetOrchestrationServiceState(String resourceGroupName, String vmScaleSetName, OrchestrationServiceStateInput parameters, Context context) {
        return this.beginSetOrchestrationServiceStateAsync(resourceGroupName, vmScaleSetName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<Void> setOrchestrationServiceStateAsync(String resourceGroupName, String vmScaleSetName, OrchestrationServiceStateInput parameters) {
        return this.beginSetOrchestrationServiceStateAsync(resourceGroupName, vmScaleSetName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> setOrchestrationServiceStateAsync(String resourceGroupName, String vmScaleSetName, OrchestrationServiceStateInput parameters, Context context) {
        return this.beginSetOrchestrationServiceStateAsync(resourceGroupName, vmScaleSetName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void setOrchestrationServiceState(String resourceGroupName, String vmScaleSetName, OrchestrationServiceStateInput parameters) {
        this.setOrchestrationServiceStateAsync(resourceGroupName, vmScaleSetName, parameters).block();
    }

    @Override
    public void setOrchestrationServiceState(String resourceGroupName, String vmScaleSetName, OrchestrationServiceStateInput parameters, Context context) {
        this.setOrchestrationServiceStateAsync(resourceGroupName, vmScaleSetName, parameters, context).block();
    }

    private Mono<PagedResponse<VirtualMachineScaleSetInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListResult)res.getValue()).value(), ((VirtualMachineScaleSetListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListResult)res.getValue()).value(), ((VirtualMachineScaleSetListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetInner>> listAllNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAllNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListWithLinkResult)res.getValue()).value(), ((VirtualMachineScaleSetListWithLinkResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetInner>> listAllNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAllNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListWithLinkResult)res.getValue()).value(), ((VirtualMachineScaleSetListWithLinkResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetSkuInner>> listSkusNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listSkusNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListSkusResult)res.getValue()).value(), ((VirtualMachineScaleSetListSkusResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetSkuInner>> listSkusNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listSkusNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListSkusResult)res.getValue()).value(), ((VirtualMachineScaleSetListSkusResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<UpgradeOperationHistoricalStatusInfoInner>> getOSUpgradeHistoryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getOSUpgradeHistoryNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListOSUpgradeHistory)res.getValue()).value(), ((VirtualMachineScaleSetListOSUpgradeHistory)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<UpgradeOperationHistoricalStatusInfoInner>> getOSUpgradeHistoryNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getOSUpgradeHistoryNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetListOSUpgradeHistory)res.getValue()).value(), ((VirtualMachineScaleSetListOSUpgradeHistory)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface VirtualMachineScaleSetsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetInner var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetUpdate var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/deallocate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deallocate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetVMInstanceIDs var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/delete")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteInstances(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetVMInstanceRequiredIDs var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/instanceView")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetInstanceViewInner>> getInstanceView(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/virtualMachineScaleSets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetListWithLinkResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetListSkusResult>> listSkus(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/osUpgradeHistory")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetListOSUpgradeHistory>> getOSUpgradeHistory(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/poweroff")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> powerOff(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="skipShutdown") Boolean var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") VirtualMachineScaleSetVMInstanceIDs var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restart(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetVMInstanceIDs var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetVMInstanceIDs var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/redeploy")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> redeploy(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetVMInstanceIDs var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/performMaintenance")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> performMaintenance(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetVMInstanceIDs var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/manualupgrade")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updateInstances(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetVMInstanceRequiredIDs var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/reimage")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> reimage(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetReimageParameters var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/reimageall")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> reimageAll(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineScaleSetVMInstanceIDs var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/forceRecoveryServiceFabricPlatformUpdateDomainWalk")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecoveryWalkResponseInner>> forceRecoveryServiceFabricPlatformUpdateDomainWalk(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="platformUpdateDomain") int var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/convertToSinglePlacementGroup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> convertToSinglePlacementGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VMScaleSetConvertToSinglePlacementGroupInput var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/setOrchestrationServiceState")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> setOrchestrationServiceState(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") OrchestrationServiceStateInput var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetListWithLinkResult>> listAllNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetListSkusResult>> listSkusNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetListOSUpgradeHistory>> getOSUpgradeHistoryNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

