/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.compute.fluent.VirtualMachineSizesClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineSizeInner;
import com.azure.resourcemanager.compute.implementation.VirtualMachineSizeImpl;
import com.azure.resourcemanager.compute.models.VirtualMachineSize;
import com.azure.resourcemanager.compute.models.VirtualMachineSizes;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;

class VirtualMachineSizesImpl
extends ReadableWrappersImpl<VirtualMachineSize, VirtualMachineSizeImpl, VirtualMachineSizeInner>
implements VirtualMachineSizes {
    private final VirtualMachineSizesClient innerCollection;

    VirtualMachineSizesImpl(VirtualMachineSizesClient innerCollection) {
        this.innerCollection = innerCollection;
    }

    public PagedIterable<VirtualMachineSize> listByRegion(Region region) {
        return this.listByRegion(region.toString());
    }

    protected VirtualMachineSizeImpl wrapModel(VirtualMachineSizeInner inner) {
        if (inner == null) {
            return null;
        }
        return new VirtualMachineSizeImpl(inner);
    }

    public PagedIterable<VirtualMachineSize> listByRegion(String regionName) {
        return this.wrapList(this.innerCollection.list(regionName));
    }

    public PagedFlux<VirtualMachineSize> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    public PagedFlux<VirtualMachineSize> listByRegionAsync(String regionName) {
        return this.innerCollection.listAsync(regionName).mapPage(VirtualMachineSizeImpl::new);
    }
}

