/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.compute.fluent.VirtualMachineImagesClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.azure.resourcemanager.compute.implementation.VirtualMachineSkuImpl;
import com.azure.resourcemanager.compute.models.VirtualMachineOffer;
import com.azure.resourcemanager.compute.models.VirtualMachineSku;
import com.azure.resourcemanager.compute.models.VirtualMachineSkus;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;

class VirtualMachineSkusImpl
extends ReadableWrappersImpl<VirtualMachineSku, VirtualMachineSkuImpl, VirtualMachineImageResourceInner>
implements VirtualMachineSkus {
    private final VirtualMachineImagesClient innerCollection;
    private final VirtualMachineOffer offer;

    VirtualMachineSkusImpl(VirtualMachineOffer offer, VirtualMachineImagesClient innerCollection) {
        this.innerCollection = innerCollection;
        this.offer = offer;
    }

    public PagedIterable<VirtualMachineSku> list() {
        return new PagedIterable(this.listAsync());
    }

    protected VirtualMachineSkuImpl wrapModel(VirtualMachineImageResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return new VirtualMachineSkuImpl(this.offer, inner.name(), this.innerCollection);
    }

    public PagedFlux<VirtualMachineSku> listAsync() {
        return PagedConverter.convertListToPagedFlux(this.innerCollection.listSkusWithResponseAsync(this.offer.region().toString(), this.offer.publisher().name(), this.offer.name())).mapPage(this::wrapModel);
    }
}

