/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.resourcemanager.compute.models.DiskVolumeType;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import java.util.Locale;
import java.util.Objects;

public abstract class VirtualMachineEncryptionConfiguration<T extends VirtualMachineEncryptionConfiguration<T>> {
    protected final String keyVaultId;
    protected final String aadClientId;
    protected final String aadSecret;
    protected DiskVolumeType volumeType = DiskVolumeType.ALL;
    protected String keyEncryptionKeyUrl;
    protected String keyEncryptionKeyVaultId;
    protected String encryptionAlgorithm = "RSA-OAEP";
    protected String passPhrase;

    protected VirtualMachineEncryptionConfiguration(String keyVaultId, String aadClientId, String aadSecret) {
        this.keyVaultId = Objects.requireNonNull(keyVaultId, "KeyVaultId parameter holding resource id of the KeyVault to store disk encryption key is required.");
        this.aadClientId = Objects.requireNonNull(aadClientId, "aadClientId parameter holding AAD client id to access the KeyVault is required.");
        this.aadSecret = Objects.requireNonNull(aadSecret, "aadSecret parameter holding AAD secret to access the KeyVault is required.");
    }

    protected VirtualMachineEncryptionConfiguration(String keyVaultId) {
        Objects.requireNonNull(keyVaultId, "KeyVaultId parameter holding resource id of the keyVault to store disk encryption key is required.");
        this.keyVaultId = keyVaultId;
        this.aadClientId = null;
        this.aadSecret = null;
    }

    public abstract OperatingSystemTypes osType();

    public String aadClientId() {
        return this.aadClientId;
    }

    public String aadSecret() {
        return this.aadSecret;
    }

    public DiskVolumeType volumeType() {
        if (this.volumeType != null) {
            return this.volumeType;
        }
        return DiskVolumeType.ALL;
    }

    public String keyVaultId() {
        return this.keyVaultId;
    }

    public String keyVaultUrl() {
        String keyVaultName = ResourceUtils.nameFromResourceId((String)this.keyVaultId);
        return String.format("https://%s.vault.azure.net/", keyVaultName.toLowerCase(Locale.ROOT));
    }

    public String keyEncryptionKeyVaultId() {
        return this.keyEncryptionKeyVaultId;
    }

    public String keyEncryptionKeyUrl() {
        return this.keyEncryptionKeyUrl;
    }

    public String volumeEncryptionKeyEncryptAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String linuxPassPhrase() {
        return this.passPhrase;
    }

    public T withVolumeType(DiskVolumeType volumeType) {
        this.volumeType = volumeType;
        return (T)this;
    }

    public T withVolumeEncryptionKeyEncrypted(String keyEncryptionKeyUrl) {
        return this.withVolumeEncryptionKeyEncrypted(keyEncryptionKeyUrl, null);
    }

    public T withVolumeEncryptionKeyEncrypted(String keyEncryptionKeyUrl, String keyEncryptionKeyKevVaultId) {
        this.keyEncryptionKeyUrl = keyEncryptionKeyUrl;
        this.keyEncryptionKeyVaultId = keyEncryptionKeyKevVaultId;
        return (T)this;
    }

    public T withVolumeEncryptionKeyEncryptAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return (T)this;
    }
}

