/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.IpVersion;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetUpdatePublicIpAddressConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class VirtualMachineScaleSetUpdateIpConfiguration
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetUpdateIpConfiguration.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="properties.subnet")
    private ApiEntityReference subnet;
    @JsonProperty(value="properties.primary")
    private Boolean primary;
    @JsonProperty(value="properties.publicIPAddressConfiguration")
    private VirtualMachineScaleSetUpdatePublicIpAddressConfiguration publicIpAddressConfiguration;
    @JsonProperty(value="properties.privateIPAddressVersion")
    private IpVersion privateIpAddressVersion;
    @JsonProperty(value="properties.applicationGatewayBackendAddressPools")
    private List<SubResource> applicationGatewayBackendAddressPools;
    @JsonProperty(value="properties.applicationSecurityGroups")
    private List<SubResource> applicationSecurityGroups;
    @JsonProperty(value="properties.loadBalancerBackendAddressPools")
    private List<SubResource> loadBalancerBackendAddressPools;
    @JsonProperty(value="properties.loadBalancerInboundNatPools")
    private List<SubResource> loadBalancerInboundNatPools;

    public String name() {
        return this.name;
    }

    public VirtualMachineScaleSetUpdateIpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public ApiEntityReference subnet() {
        return this.subnet;
    }

    public VirtualMachineScaleSetUpdateIpConfiguration withSubnet(ApiEntityReference subnet) {
        this.subnet = subnet;
        return this;
    }

    public Boolean primary() {
        return this.primary;
    }

    public VirtualMachineScaleSetUpdateIpConfiguration withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public VirtualMachineScaleSetUpdatePublicIpAddressConfiguration publicIpAddressConfiguration() {
        return this.publicIpAddressConfiguration;
    }

    public VirtualMachineScaleSetUpdateIpConfiguration withPublicIpAddressConfiguration(VirtualMachineScaleSetUpdatePublicIpAddressConfiguration publicIpAddressConfiguration) {
        this.publicIpAddressConfiguration = publicIpAddressConfiguration;
        return this;
    }

    public IpVersion privateIpAddressVersion() {
        return this.privateIpAddressVersion;
    }

    public VirtualMachineScaleSetUpdateIpConfiguration withPrivateIpAddressVersion(IpVersion privateIpAddressVersion) {
        this.privateIpAddressVersion = privateIpAddressVersion;
        return this;
    }

    public List<SubResource> applicationGatewayBackendAddressPools() {
        return this.applicationGatewayBackendAddressPools;
    }

    public VirtualMachineScaleSetUpdateIpConfiguration withApplicationGatewayBackendAddressPools(List<SubResource> applicationGatewayBackendAddressPools) {
        this.applicationGatewayBackendAddressPools = applicationGatewayBackendAddressPools;
        return this;
    }

    public List<SubResource> applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    public VirtualMachineScaleSetUpdateIpConfiguration withApplicationSecurityGroups(List<SubResource> applicationSecurityGroups) {
        this.applicationSecurityGroups = applicationSecurityGroups;
        return this;
    }

    public List<SubResource> loadBalancerBackendAddressPools() {
        return this.loadBalancerBackendAddressPools;
    }

    public VirtualMachineScaleSetUpdateIpConfiguration withLoadBalancerBackendAddressPools(List<SubResource> loadBalancerBackendAddressPools) {
        this.loadBalancerBackendAddressPools = loadBalancerBackendAddressPools;
        return this;
    }

    public List<SubResource> loadBalancerInboundNatPools() {
        return this.loadBalancerInboundNatPools;
    }

    public VirtualMachineScaleSetUpdateIpConfiguration withLoadBalancerInboundNatPools(List<SubResource> loadBalancerInboundNatPools) {
        this.loadBalancerInboundNatPools = loadBalancerInboundNatPools;
        return this;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
        if (this.publicIpAddressConfiguration() != null) {
            this.publicIpAddressConfiguration().validate();
        }
    }
}

