/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.models.DiskInner;
import com.azure.resourcemanager.compute.models.CreationSource;
import com.azure.resourcemanager.compute.models.DiskCreateOption;
import com.azure.resourcemanager.compute.models.DiskSkuTypes;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.EncryptionType;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.Snapshot;
import com.azure.resourcemanager.compute.models.VirtualMachineCustomImage;
import com.azure.resourcemanager.compute.models.VirtualMachineImage;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.util.Set;
import reactor.core.publisher.Mono;

public interface Disk
extends GroupableResource<ComputeManager, DiskInner>,
Refreshable<Disk>,
Updatable<Update> {
    public DiskSkuTypes sku();

    public DiskCreateOption creationMethod();

    public boolean isAttachedToVirtualMachine();

    public String virtualMachineId();

    public int sizeInGB();

    public long sizeInByte();

    public OperatingSystemTypes osType();

    public CreationSource source();

    public Set<AvailabilityZoneId> availabilityZones();

    public EncryptionSettingsCollection encryptionSettings();

    public Encryption encryption();

    public String grantAccess(int var1);

    public Mono<String> grantAccessAsync(int var1);

    public void revokeAccess();

    public Mono<Void> revokeAccessAsync();

    public boolean isHibernationSupported();

    public static interface Update
    extends Appliable<Disk>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithSize,
    UpdateStages.WithOSSettings,
    UpdateStages.WithDiskEncryption,
    UpdateStages.WithHibernationSupport {
    }

    public static interface UpdateStages {

        public static interface WithHibernationSupport {
            public Update withHibernationSupport();

            public Update withoutHibernationSupport();
        }

        public static interface WithDiskEncryption {
            public Update withDiskEncryptionSet(String var1, EncryptionType var2);
        }

        public static interface WithOSSettings {
            public Update withOSType(OperatingSystemTypes var1);
        }

        public static interface WithSize {
            public Update withSizeInGB(int var1);
        }

        public static interface WithSku {
            public Update withSku(DiskSkuTypes var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Disk>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSku,
        WithAvailabilityZone,
        WithDiskEncryption,
        WithHibernationSupport {
            public Accepted<Disk> beginCreate();
        }

        public static interface WithHibernationSupport {
            public WithCreate withHibernationSupport();
        }

        public static interface WithDiskEncryption {
            public WithCreate withDiskEncryptionSet(String var1);
        }

        public static interface WithSku {
            public WithCreate withSku(DiskSkuTypes var1);
        }

        public static interface WithCreateAndSize
        extends WithCreate {
            public WithCreate withSizeInGB(int var1);
        }

        public static interface WithAvailabilityZone {
            public WithCreate withAvailabilityZone(AvailabilityZoneId var1);
        }

        public static interface WithStorageAccount {
            public WithCreateAndSize withStorageAccountId(String var1);

            public WithCreateAndSize withStorageAccountName(String var1);

            public WithCreateAndSize withStorageAccount(StorageAccount var1);
        }

        public static interface WithDataDiskFromImage {
            public WithCreateAndSize fromImage(String var1, int var2);

            public WithCreateAndSize fromImage(VirtualMachineImage var1, int var2);

            public WithCreateAndSize fromImage(VirtualMachineCustomImage var1, int var2);
        }

        public static interface WithOSDiskFromImage {
            public WithCreateAndSize fromImage(String var1, OperatingSystemTypes var2);

            public WithCreateAndSize fromImage(VirtualMachineImage var1);

            public WithCreateAndSize fromImage(VirtualMachineCustomImage var1);
        }

        public static interface WithDataDiskFromSnapshot {
            public WithCreateAndSize fromSnapshot(String var1);

            public WithCreateAndSize fromSnapshot(Snapshot var1);
        }

        public static interface WithDataDiskFromDisk {
            public WithCreateAndSize fromDisk(String var1);

            public WithCreateAndSize fromDisk(Disk var1);
        }

        public static interface WithDataDiskFromUpload {
            public WithCreate withUploadSizeInMB(long var1);
        }

        public static interface WithDataDiskFromVhd {
            public WithStorageAccount fromVhd(String var1);
        }

        public static interface WithDataDiskSource
        extends WithDataDiskFromVhd,
        WithDataDiskFromUpload,
        WithDataDiskFromDisk,
        WithDataDiskFromSnapshot {
            public WithCreate withSizeInGB(int var1);
        }

        public static interface WithData {
            public WithDataDiskSource withData();
        }

        public static interface WithLinuxDiskSource {
            public WithCreateAndSize withLinuxFromDisk(String var1);

            public WithCreateAndSize withLinuxFromDisk(Disk var1);

            public WithCreateAndSize withLinuxFromSnapshot(String var1);

            public WithCreateAndSize withLinuxFromSnapshot(Snapshot var1);

            public WithStorageAccount withLinuxFromVhd(String var1);
        }

        public static interface WithWindowsDiskSource {
            public WithCreateAndSize withWindowsFromDisk(String var1);

            public WithCreateAndSize withWindowsFromDisk(Disk var1);

            public WithCreateAndSize withWindowsFromSnapshot(String var1);

            public WithCreateAndSize withWindowsFromSnapshot(Snapshot var1);

            public WithStorageAccount withWindowsFromVhd(String var1);
        }

        public static interface WithDiskSource
        extends WithWindowsDiskSource,
        WithLinuxDiskSource,
        WithData {
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithDiskSource> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithDiskSource,
    DefinitionStages.WithWindowsDiskSource,
    DefinitionStages.WithLinuxDiskSource,
    DefinitionStages.WithData,
    DefinitionStages.WithDataDiskSource,
    DefinitionStages.WithDataDiskFromVhd,
    DefinitionStages.WithDataDiskFromUpload,
    DefinitionStages.WithDataDiskFromDisk,
    DefinitionStages.WithDataDiskFromSnapshot,
    DefinitionStages.WithStorageAccount,
    DefinitionStages.WithCreateAndSize,
    DefinitionStages.WithCreate {
    }
}

