// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The container execution command, for liveness or readiness probe. */
@Fluent
public final class ContainerExec {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ContainerExec.class);

    /*
     * The commands to execute within the container.
     */
    @JsonProperty(value = "command")
    private List<String> command;

    /**
     * Get the command property: The commands to execute within the container.
     *
     * @return the command value.
     */
    public List<String> command() {
        return this.command;
    }

    /**
     * Set the command property: The commands to execute within the container.
     *
     * @param command the command value to set.
     * @return the ContainerExec object itself.
     */
    public ContainerExec withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
