// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ContainerGroupNetworkProtocol. */
public final class ContainerGroupNetworkProtocol extends ExpandableStringEnum<ContainerGroupNetworkProtocol> {
    /** Static value TCP for ContainerGroupNetworkProtocol. */
    public static final ContainerGroupNetworkProtocol TCP = fromString("TCP");

    /** Static value UDP for ContainerGroupNetworkProtocol. */
    public static final ContainerGroupNetworkProtocol UDP = fromString("UDP");

    /**
     * Creates or finds a ContainerGroupNetworkProtocol from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ContainerGroupNetworkProtocol.
     */
    @JsonCreator
    public static ContainerGroupNetworkProtocol fromString(String name) {
        return fromString(name, ContainerGroupNetworkProtocol.class);
    }

    /** @return known ContainerGroupNetworkProtocol values. */
    public static Collection<ContainerGroupNetworkProtocol> values() {
        return values(ContainerGroupNetworkProtocol.class);
    }
}
