// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitStatsInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitsArpTableListResultInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitsRoutesTableListResultInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitsRoutesTableSummaryListResultInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ExpressRouteCircuitsClient. */
public interface ExpressRouteCircuitsClient
    extends InnerSupportsGet<ExpressRouteCircuitInner>,
        InnerSupportsListing<ExpressRouteCircuitInner>,
        InnerSupportsDelete<Void> {
    /**
     * Deletes the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String circuitName);

    /**
     * Deletes the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String circuitName);

    /**
     * Deletes the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String circuitName);

    /**
     * Deletes the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String circuitName, Context context);

    /**
     * Deletes the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String circuitName);

    /**
     * Deletes the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String circuitName);

    /**
     * Deletes the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String circuitName, Context context);

    /**
     * Gets information about the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the specified express route circuit.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ExpressRouteCircuitInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String circuitName);

    /**
     * Gets information about the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the specified express route circuit.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitInner> getByResourceGroupAsync(String resourceGroupName, String circuitName);

    /**
     * Gets information about the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the specified express route circuit.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitInner getByResourceGroup(String resourceGroupName, String circuitName);

    /**
     * Gets information about the specified express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of express route circuit.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the specified express route circuit.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ExpressRouteCircuitInner> getByResourceGroupWithResponse(
        String resourceGroupName, String circuitName, Context context);

    /**
     * Creates or updates an express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @param parameters ExpressRouteCircuit resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String circuitName, ExpressRouteCircuitInner parameters);

    /**
     * Creates or updates an express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @param parameters ExpressRouteCircuit resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ExpressRouteCircuitInner>, ExpressRouteCircuitInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String circuitName, ExpressRouteCircuitInner parameters);

    /**
     * Creates or updates an express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @param parameters ExpressRouteCircuit resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ExpressRouteCircuitInner>, ExpressRouteCircuitInner> beginCreateOrUpdate(
        String resourceGroupName, String circuitName, ExpressRouteCircuitInner parameters);

    /**
     * Creates or updates an express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @param parameters ExpressRouteCircuit resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ExpressRouteCircuitInner>, ExpressRouteCircuitInner> beginCreateOrUpdate(
        String resourceGroupName, String circuitName, ExpressRouteCircuitInner parameters, Context context);

    /**
     * Creates or updates an express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @param parameters ExpressRouteCircuit resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitInner> createOrUpdateAsync(
        String resourceGroupName, String circuitName, ExpressRouteCircuitInner parameters);

    /**
     * Creates or updates an express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @param parameters ExpressRouteCircuit resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitInner createOrUpdate(
        String resourceGroupName, String circuitName, ExpressRouteCircuitInner parameters);

    /**
     * Creates or updates an express route circuit.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @param parameters ExpressRouteCircuit resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitInner createOrUpdate(
        String resourceGroupName, String circuitName, ExpressRouteCircuitInner parameters, Context context);

    /**
     * Updates an express route circuit tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ExpressRouteCircuitInner>> updateTagsWithResponseAsync(
        String resourceGroupName, String circuitName, Map<String, String> tags);

    /**
     * Updates an express route circuit tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitInner> updateTagsAsync(
        String resourceGroupName, String circuitName, Map<String, String> tags);

    /**
     * Updates an express route circuit tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitInner> updateTagsAsync(String resourceGroupName, String circuitName);

    /**
     * Updates an express route circuit tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitInner updateTags(String resourceGroupName, String circuitName);

    /**
     * Updates an express route circuit tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the circuit.
     * @param tags Resource tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCircuit resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ExpressRouteCircuitInner> updateTagsWithResponse(
        String resourceGroupName, String circuitName, Map<String, String> tags, Context context);

    /**
     * Gets the currently advertised ARP table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> listArpTableWithResponseAsync(
        String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised ARP table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>
        beginListArpTableAsync(String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised ARP table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>
        beginListArpTable(String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised ARP table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>
        beginListArpTable(
            String resourceGroupName, String circuitName, String peeringName, String devicePath, Context context);

    /**
     * Gets the currently advertised ARP table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitsArpTableListResultInner> listArpTableAsync(
        String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised ARP table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitsArpTableListResultInner listArpTable(
        String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised ARP table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitsArpTableListResultInner listArpTable(
        String resourceGroupName, String circuitName, String peeringName, String devicePath, Context context);

    /**
     * Gets the currently advertised routes table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> listRoutesTableWithResponseAsync(
        String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<
            PollResult<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>
        beginListRoutesTableAsync(String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<
            PollResult<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>
        beginListRoutesTable(String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<
            PollResult<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>
        beginListRoutesTable(
            String resourceGroupName, String circuitName, String peeringName, String devicePath, Context context);

    /**
     * Gets the currently advertised routes table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitsRoutesTableListResultInner> listRoutesTableAsync(
        String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitsRoutesTableListResultInner listRoutesTable(
        String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitsRoutesTableListResultInner listRoutesTable(
        String resourceGroupName, String circuitName, String peeringName, String devicePath, Context context);

    /**
     * Gets the currently advertised routes table summary associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table summary associated with the express route circuit in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> listRoutesTableSummaryWithResponseAsync(
        String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table summary associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table summary associated with the express route circuit in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<
            PollResult<ExpressRouteCircuitsRoutesTableSummaryListResultInner>,
            ExpressRouteCircuitsRoutesTableSummaryListResultInner>
        beginListRoutesTableSummaryAsync(
            String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table summary associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table summary associated with the express route circuit in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<
            PollResult<ExpressRouteCircuitsRoutesTableSummaryListResultInner>,
            ExpressRouteCircuitsRoutesTableSummaryListResultInner>
        beginListRoutesTableSummary(
            String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table summary associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table summary associated with the express route circuit in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<
            PollResult<ExpressRouteCircuitsRoutesTableSummaryListResultInner>,
            ExpressRouteCircuitsRoutesTableSummaryListResultInner>
        beginListRoutesTableSummary(
            String resourceGroupName, String circuitName, String peeringName, String devicePath, Context context);

    /**
     * Gets the currently advertised routes table summary associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table summary associated with the express route circuit in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitsRoutesTableSummaryListResultInner> listRoutesTableSummaryAsync(
        String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table summary associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table summary associated with the express route circuit in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitsRoutesTableSummaryListResultInner listRoutesTableSummary(
        String resourceGroupName, String circuitName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table summary associated with the express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table summary associated with the express route circuit in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitsRoutesTableSummaryListResultInner listRoutesTableSummary(
        String resourceGroupName, String circuitName, String peeringName, String devicePath, Context context);

    /**
     * Gets all the stats from an express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the stats from an express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ExpressRouteCircuitStatsInner>> getStatsWithResponseAsync(
        String resourceGroupName, String circuitName);

    /**
     * Gets all the stats from an express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the stats from an express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitStatsInner> getStatsAsync(String resourceGroupName, String circuitName);

    /**
     * Gets all the stats from an express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the stats from an express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitStatsInner getStats(String resourceGroupName, String circuitName);

    /**
     * Gets all the stats from an express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the stats from an express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ExpressRouteCircuitStatsInner> getStatsWithResponse(
        String resourceGroupName, String circuitName, Context context);

    /**
     * Gets all stats from an express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all stats from an express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ExpressRouteCircuitStatsInner>> getPeeringStatsWithResponseAsync(
        String resourceGroupName, String circuitName, String peeringName);

    /**
     * Gets all stats from an express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all stats from an express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitStatsInner> getPeeringStatsAsync(
        String resourceGroupName, String circuitName, String peeringName);

    /**
     * Gets all stats from an express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all stats from an express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitStatsInner getPeeringStats(String resourceGroupName, String circuitName, String peeringName);

    /**
     * Gets all stats from an express route circuit in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param circuitName The name of the express route circuit.
     * @param peeringName The name of the peering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all stats from an express route circuit in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ExpressRouteCircuitStatsInner> getPeeringStatsWithResponse(
        String resourceGroupName, String circuitName, String peeringName, Context context);

    /**
     * Gets all the express route circuits in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the express route circuits in a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ExpressRouteCircuitInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Gets all the express route circuits in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the express route circuits in a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ExpressRouteCircuitInner> listByResourceGroup(String resourceGroupName);

    /**
     * Gets all the express route circuits in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the express route circuits in a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ExpressRouteCircuitInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Gets all the express route circuits in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the express route circuits in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ExpressRouteCircuitInner> listAsync();

    /**
     * Gets all the express route circuits in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the express route circuits in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ExpressRouteCircuitInner> list();

    /**
     * Gets all the express route circuits in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the express route circuits in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ExpressRouteCircuitInner> list(Context context);
}
