// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.EndpointServiceResultInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response for the ListAvailableEndpointServices API service call. */
@Fluent
public final class EndpointServicesListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(EndpointServicesListResult.class);

    /*
     * List of available endpoint services in a region.
     */
    @JsonProperty(value = "value")
    private List<EndpointServiceResultInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: List of available endpoint services in a region.
     *
     * @return the value value.
     */
    public List<EndpointServiceResultInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of available endpoint services in a region.
     *
     * @param value the value value to set.
     * @return the EndpointServicesListResult object itself.
     */
    public EndpointServicesListResult withValue(List<EndpointServiceResultInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the EndpointServicesListResult object itself.
     */
    public EndpointServicesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
