// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list of RouteTables to advertise the routes to. */
@Fluent
public final class PropagatedRouteTable {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PropagatedRouteTable.class);

    /*
     * The list of labels.
     */
    @JsonProperty(value = "labels")
    private List<String> labels;

    /*
     * The list of resource ids of all the RouteTables.
     */
    @JsonProperty(value = "ids")
    private List<SubResource> ids;

    /**
     * Get the labels property: The list of labels.
     *
     * @return the labels value.
     */
    public List<String> labels() {
        return this.labels;
    }

    /**
     * Set the labels property: The list of labels.
     *
     * @param labels the labels value to set.
     * @return the PropagatedRouteTable object itself.
     */
    public PropagatedRouteTable withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    /**
     * Get the ids property: The list of resource ids of all the RouteTables.
     *
     * @return the ids value.
     */
    public List<SubResource> ids() {
        return this.ids;
    }

    /**
     * Set the ids property: The list of resource ids of all the RouteTables.
     *
     * @param ids the ids value to set.
     * @return the PropagatedRouteTable object itself.
     */
    public PropagatedRouteTable withIds(List<SubResource> ids) {
        this.ids = ids;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
