// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Routing Configuration indicating the associated and propagated route tables for this connection. */
@Fluent
public final class RoutingConfiguration {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RoutingConfiguration.class);

    /*
     * The resource id RouteTable associated with this RoutingConfiguration.
     */
    @JsonProperty(value = "associatedRouteTable")
    private SubResource associatedRouteTable;

    /*
     * The list of RouteTables to advertise the routes to.
     */
    @JsonProperty(value = "propagatedRouteTables")
    private PropagatedRouteTable propagatedRouteTables;

    /*
     * List of routes that control routing from VirtualHub into a virtual
     * network connection.
     */
    @JsonProperty(value = "vnetRoutes")
    private VnetRoute vnetRoutes;

    /**
     * Get the associatedRouteTable property: The resource id RouteTable associated with this RoutingConfiguration.
     *
     * @return the associatedRouteTable value.
     */
    public SubResource associatedRouteTable() {
        return this.associatedRouteTable;
    }

    /**
     * Set the associatedRouteTable property: The resource id RouteTable associated with this RoutingConfiguration.
     *
     * @param associatedRouteTable the associatedRouteTable value to set.
     * @return the RoutingConfiguration object itself.
     */
    public RoutingConfiguration withAssociatedRouteTable(SubResource associatedRouteTable) {
        this.associatedRouteTable = associatedRouteTable;
        return this;
    }

    /**
     * Get the propagatedRouteTables property: The list of RouteTables to advertise the routes to.
     *
     * @return the propagatedRouteTables value.
     */
    public PropagatedRouteTable propagatedRouteTables() {
        return this.propagatedRouteTables;
    }

    /**
     * Set the propagatedRouteTables property: The list of RouteTables to advertise the routes to.
     *
     * @param propagatedRouteTables the propagatedRouteTables value to set.
     * @return the RoutingConfiguration object itself.
     */
    public RoutingConfiguration withPropagatedRouteTables(PropagatedRouteTable propagatedRouteTables) {
        this.propagatedRouteTables = propagatedRouteTables;
        return this;
    }

    /**
     * Get the vnetRoutes property: List of routes that control routing from VirtualHub into a virtual network
     * connection.
     *
     * @return the vnetRoutes value.
     */
    public VnetRoute vnetRoutes() {
        return this.vnetRoutes;
    }

    /**
     * Set the vnetRoutes property: List of routes that control routing from VirtualHub into a virtual network
     * connection.
     *
     * @param vnetRoutes the vnetRoutes value to set.
     * @return the RoutingConfiguration object itself.
     */
    public RoutingConfiguration withVnetRoutes(VnetRoute vnetRoutes) {
        this.vnetRoutes = vnetRoutes;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (propagatedRouteTables() != null) {
            propagatedRouteTables().validate();
        }
        if (vnetRoutes() != null) {
            vnetRoutes().validate();
        }
    }
}
